/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

import greycat.Graph;
import greycat.Node;
import greycat.base.BaseNode;
import greycat.internal.tree.NDTree;
import greycat.struct.Profile;
import greycat.struct.ProfileResult;

public class NDTreeNode
extends BaseNode
implements Profile {
    public static String NAME = "NDTreeNode";
    public static String BOUND_MIN = "bound_min";
    public static String BOUND_MAX = "bound_max";
    public static String RESOLUTION = "resolution";
    private static String E_TREE = "etree";
    private NDTree _ndTree = null;

    public NDTreeNode(long p_world, long p_time, long p_id, Graph p_graph) {
        super(p_world, p_time, p_id, p_graph);
    }

    private NDTree getTree() {
        if (this._ndTree == null) {
            this._ndTree = (NDTree)this.getOrCreate(E_TREE, (byte)23);
        }
        return this._ndTree;
    }

    @Override
    public final Node set(String name, byte type, Object value) {
        if (name.equals(BOUND_MIN)) {
            this.setMinBound((double[])value);
        } else if (name.equals(BOUND_MAX)) {
            this.setMaxBound((double[])value);
        } else if (name.equals(RESOLUTION)) {
            this.setResolution((double[])value);
        } else {
            super.set(name, type, value);
        }
        return this;
    }

    @Override
    public final void setDistance(int distanceType) {
        this.getTree().setDistance(distanceType);
    }

    @Override
    public final void setResolution(double[] resolution) {
        this.getTree().setResolution(resolution);
    }

    @Override
    public final void setMinBound(double[] min) {
        this.getTree().setMinBound(min);
    }

    @Override
    public final void setMaxBound(double[] max) {
        this.getTree().setMaxBound(max);
    }

    @Override
    public final void insert(double[] keys, long value) {
        this.getTree().insert(keys, value);
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this._ndTree.setBufferSize(bufferSize);
    }

    @Override
    public final void profile(double[] keys) {
        this.getTree().profile(keys);
    }

    @Override
    public final void profileWith(double[] keys, long occurrence) {
        this.getTree().profileWith(keys, occurrence);
    }

    @Override
    public final ProfileResult queryAround(double[] keys, int nbElem) {
        return this.getTree().queryAround(keys, nbElem);
    }

    @Override
    public final ProfileResult queryRadius(double[] keys, double radius) {
        return this.getTree().queryRadius(keys, radius);
    }

    @Override
    public final ProfileResult queryBoundedRadius(double[] keys, double radius, int max) {
        return this.getTree().queryBoundedRadius(keys, radius, max);
    }

    @Override
    public final ProfileResult queryArea(double[] min, double[] max) {
        return this.getTree().queryArea(min, max);
    }

    @Override
    public final long size() {
        return this.getTree().size();
    }

    @Override
    public final long treeSize() {
        return this.getTree().treeSize();
    }
}

