/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

import greycat.internal.tree.VolatileTreeResult;
import greycat.utility.distance.Distance;

class TreeHelper {
    TreeHelper() {
    }

    static boolean checkBoundsIntersection(double[] targetmin, double[] targetmax, double[] boundMin, double[] boundMax) {
        for (int i = 0; i < boundMax.length; ++i) {
            if (!(targetmin[i] > boundMax[i]) && !(targetmax[i] < boundMin[i])) continue;
            return false;
        }
        return true;
    }

    static boolean checkKeyInsideBounds(double[] key, double[] boundMin, double[] boundMax) {
        for (int i = 0; i < boundMax.length; ++i) {
            if (!(key[i] > boundMax[i]) && !(key[i] < boundMin[i])) continue;
            return false;
        }
        return true;
    }

    static double getclosestDistance(double[] target, double[] boundMin, double[] boundMax, Distance distance) {
        double[] closest = new double[target.length];
        for (int i = 0; i < target.length; ++i) {
            closest[i] = target[i] >= boundMax[i] ? boundMax[i] : (target[i] <= boundMin[i] ? boundMin[i] : target[i]);
        }
        return distance.measure(closest, target);
    }

    static void filterAndInsert(double[] key, long value, double[] target, double[] targetmin, double[] targetmax, double[] targetcenter, Distance distance, double radius, VolatileTreeResult nnl) {
        if (targetmin != null) {
            if (TreeHelper.checkKeyInsideBounds(key, targetmin, targetmax)) {
                nnl.insert(key, value, distance.measure(key, targetcenter));
            }
        } else {
            double dist = distance.measure(key, target);
            if (radius > 0.0) {
                if (dist < radius) {
                    nnl.insert(key, value, dist);
                }
            } else {
                nnl.insert(key, value, dist);
            }
        }
    }
}

