/*
 * Decompiled with CFR 0.152.
 */
package greycat.internal.tree;

import greycat.internal.tree.NDTree;
import greycat.struct.DMatrix;
import greycat.struct.EGraph;
import greycat.struct.ENode;
import greycat.struct.LMatrix;
import greycat.struct.ProfileResult;
import greycat.struct.TreeResult;

public class VolatileTreeResult
implements ProfileResult {
    private static double maxPriority = Double.MAX_VALUE;
    private static int _KEYS = 1;
    private static int _VALUES = 2;
    private static int _DISTANCES = 3;
    private ENode node;
    private int capacity;
    private int count;
    private double worst;
    private DMatrix _keys;
    private LMatrix _values;
    private DMatrix _distances;

    public VolatileTreeResult(ENode node, int capacity) {
        this.node = node;
        this.count = 0;
        this._keys = (DMatrix)node.getOrCreateAt(_KEYS, (byte)15);
        this._values = (LMatrix)node.getOrCreateAt(_VALUES, (byte)16);
        this._distances = (DMatrix)node.getOrCreateAt(_DISTANCES, (byte)15);
        this.capacity = capacity;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public TreeResult groupBy(double[] resolutions) {
        if (this.count == 0) {
            return null;
        }
        if (resolutions.length != this._keys.rows()) {
            throw new RuntimeException("Resolutions and keys are not the same size!");
        }
        int count = 0;
        for (int i = 0; i < resolutions.length; ++i) {
            if (!(resolutions[i] < 0.0)) continue;
            ++count;
        }
        if (count == resolutions.length) {
            throw new RuntimeException("All resolutions can't be negative!");
        }
        double[] newmin = new double[resolutions.length];
        double[] newmax = new double[resolutions.length];
        double[] firstkey = this.keys(0);
        System.arraycopy(firstkey, 0, newmin, 0, firstkey.length);
        System.arraycopy(firstkey, 0, newmax, 0, firstkey.length);
        double d = 0.0;
        int t = 0;
        int[] indexCollapse = new int[count];
        for (int j = 0; j < firstkey.length; ++j) {
            if (resolutions[j] < 0.0) {
                newmin[j] = 0.0;
                newmax[j] = 0.0;
                indexCollapse[t] = j;
                ++t;
                continue;
            }
            for (int i = 1; i < count; ++i) {
                d = this._keys.get(j, i);
                if (d > newmax[j]) {
                    newmax[j] = d;
                }
                if (!(d < newmin[j])) continue;
                newmin[j] = d;
            }
        }
        NDTree tempTree = new NDTree(this.node.egraph().graph().space().newVolatileGraph());
        tempTree.setResolution(resolutions);
        tempTree.setMinBound(newmin);
        tempTree.setMaxBound(newmax);
        for (int i = 0; i < count; ++i) {
            double[] k = this._keys.column(i);
            for (t = 0; t < count; ++t) {
                k[indexCollapse[t]] = 0.0;
            }
            tempTree.profileWith(k, this._values.get(0, i));
        }
        return tempTree.queryArea(newmin, newmax);
    }

    @Override
    public boolean insert(double[] key, long value, double distance) {
        if (this.capacity > 0 && this.count == this.capacity) {
            this.add(key, value, distance, true);
            return true;
        }
        this.add(key, value, distance, false);
        return true;
    }

    private void add(double[] key, long value, double distance, boolean remove) {
        if (this.count == 0) {
            this._keys.appendColumn(new double[key.length]);
            this._values.appendColumn(new long[1]);
            this._distances.appendColumn(new double[]{maxPriority});
        }
        if (remove) {
            if (distance > this.getWorstDistance()) {
                return;
            }
            this.remove();
            ++this.count;
            for (int i = 0; i < this._keys.rows(); ++i) {
                this._keys.set(i, this.count, key[i]);
            }
            this._values.set(0, this.count, value);
            this._distances.set(0, this.count, distance);
        } else {
            ++this.count;
            this._keys.appendColumn(key);
            this._values.appendColumn(new long[]{value});
            this._distances.appendColumn(new double[]{distance});
        }
        this.bubbleUp(this.count);
        this.worst = this._distances.get(0, 1);
    }

    private void remove() {
        if (this.count == 0) {
            return;
        }
        for (int i = 0; i < this._keys.rows(); ++i) {
            this._keys.set(i, 1, this._keys.get(i, this.count));
            this._keys.set(i, this.count, 0.0);
        }
        this._values.set(0, 1, this._values.get(0, this.count));
        this._distances.set(0, 1, this._distances.get(0, this.count));
        this._values.set(0, this.count, 0L);
        this._distances.set(0, this.count, 0.0);
        --this.count;
        this.bubbleDown(1);
    }

    private void bubbleUp(int pos) {
        int i;
        double[] okey = this._keys.column(pos);
        long element = this._values.column(pos)[0];
        double priority = this._distances.column(pos)[0];
        int halfpos = (int)Math.floor(pos / 2);
        while (this._distances.column(halfpos)[0] < priority) {
            this._distances.set(0, pos, this._distances.get(0, halfpos));
            this._values.set(0, pos, this._values.get(0, halfpos));
            for (i = 0; i < this._keys.rows(); ++i) {
                this._keys.set(i, pos, this._keys.get(i, halfpos));
            }
            pos = (int)Math.floor(pos / 2);
            halfpos = (int)Math.floor(pos / 2);
        }
        this._distances.set(0, pos, priority);
        this._values.set(0, pos, element);
        for (i = 0; i < this._keys.rows(); ++i) {
            this._keys.set(i, pos, okey[i]);
        }
    }

    private void bubbleDown(int pos) {
        int i;
        double[] okey = this._keys.column(pos);
        long element = this._values.column(pos)[0];
        double priority = this._distances.column(pos)[0];
        while (pos * 2 <= this.count) {
            int child = pos * 2;
            if (child != this.count && this._distances.get(0, child) < this._distances.get(0, child + 1)) {
                ++child;
            }
            if (!(priority < this._distances.get(0, child))) break;
            this._distances.set(0, pos, this._distances.get(0, child));
            this._values.set(0, pos, this._values.get(0, child));
            for (i = 0; i < this._keys.rows(); ++i) {
                this._keys.set(i, pos, this._keys.get(i, child));
            }
            pos = child;
        }
        this._distances.set(0, pos, priority);
        this._values.set(0, pos, element);
        for (i = 0; i < this._keys.rows(); ++i) {
            this._keys.set(i, pos, okey[i]);
        }
    }

    @Override
    public double[] keys(int index) {
        return this._keys.column(index + 1);
    }

    @Override
    public long value(int index) {
        return this._values.get(index + 1, 0);
    }

    @Override
    public double distance(int index) {
        return this._distances.get(index + 1, 0);
    }

    @Override
    public double getWorstDistance() {
        if (this.count == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.worst;
    }

    @Override
    public void free() {
        EGraph g = this.node.egraph();
        this.node.drop();
        if (g.size() == 0) {
            g.free();
        }
    }

    @Override
    public boolean isCapacityReached() {
        return this.capacity > 0 && this.count == this.capacity;
    }

    private void swap(int i, int j) {
        int k;
        double[] tempkey = this._keys.column(i);
        long tempvalue = this._values.get(0, i);
        double tempdist = this._distances.get(0, i);
        this._distances.set(0, i, this._distances.get(0, j));
        this._values.set(0, i, this._values.get(0, j));
        for (k = 0; k < this._keys.rows(); ++k) {
            this._keys.set(k, i, this._keys.get(k, j));
        }
        this._distances.set(0, j, tempdist);
        this._values.set(0, j, tempvalue);
        for (k = 0; k < this._keys.rows(); ++k) {
            this._keys.set(k, j, tempkey[k]);
        }
    }

    private int partition(int l, int h, boolean ascending) {
        double x = this._distances.get(0, h);
        int i = l - 1;
        for (int j = l; j <= h - 1; ++j) {
            if (ascending) {
                if (!(this._distances.get(0, j) <= x)) continue;
                this.swap(++i, j);
                continue;
            }
            if (!(this._distances.get(0, j) > x)) continue;
            this.swap(++i, j);
        }
        this.swap(i + 1, h);
        return i + 1;
    }

    private void quickSort(int l, int h, boolean ascending) {
        int[] stack = new int[h - l + 1];
        int top = -1;
        stack[++top] = l;
        stack[++top] = h;
        while (top >= 0) {
            int p;
            if ((p = this.partition(l = stack[top--], h = stack[top--], ascending)) - 1 > l) {
                stack[++top] = l;
                stack[++top] = p - 1;
            }
            if (p + 1 >= h) continue;
            stack[++top] = p + 1;
            stack[++top] = h;
        }
    }

    @Override
    public void sort(boolean ascending) {
        if (this.count > 1) {
            this.quickSort(1, this.count, ascending);
        }
    }
}

