/*
 * Decompiled with CFR 0.152.
 */
package greycat.scheduler;

import greycat.plugin.Job;
import greycat.plugin.Scheduler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorScheduler
implements Scheduler {
    private ExecutorService service;
    private int _workers = -1;

    @Override
    public void dispatch(byte affinity, final Job job) {
        this.service.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    job.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void start() {
        this.service = this._workers == -1 ? Executors.newCachedThreadPool() : Executors.newWorkStealingPool(this._workers);
    }

    @Override
    public void stop() {
        this.service.shutdown();
        this.service = null;
    }

    @Override
    public int workers() {
        return this._workers;
    }
}

