/*
 * Decompiled with CFR 0.152.
 */
package greycat.scheduler;

import greycat.plugin.Job;
import greycat.plugin.Scheduler;
import greycat.scheduler.JobQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class HybridScheduler
implements Scheduler {
    private Worker[] _workers = null;
    private final BlockingDeque<Job> globalQueue = new LinkedBlockingDeque<Job>();
    private int nbWorkers = -1;

    @Override
    public void dispatch(byte affinity, Job job) {
        switch (affinity) {
            case 0: {
                Thread currentThread = Thread.currentThread();
                if (Thread.currentThread() instanceof Worker) {
                    Worker currentWorker = (Worker)currentThread;
                    currentWorker.dispatch(job);
                    break;
                }
                this.globalQueue.add(job);
                break;
            }
            default: {
                this.globalQueue.add(job);
            }
        }
    }

    @Override
    public void start() {
        int nbcore = this.nbWorkers;
        if (nbcore == -1) {
            nbcore = Runtime.getRuntime().availableProcessors();
        }
        this._workers = new Worker[nbcore];
        for (int i = 0; i < this._workers.length; ++i) {
            this._workers[i] = new Worker();
            this._workers[i].start();
        }
    }

    @Override
    public void stop() {
        if (this._workers != null) {
            for (int i = 0; i < this._workers.length; ++i) {
                this._workers[i].running = false;
            }
            this._workers = null;
        }
    }

    @Override
    public int workers() {
        return this._workers.length;
    }

    private final class Worker
    extends Thread {
        private final JobQueue localQueue = new JobQueue();
        private final AtomicInteger wip = new AtomicInteger();
        private boolean running = true;

        Worker() {
            this.setDaemon(false);
        }

        @Override
        public void run() {
            while (this.running) {
                Job globalPolled = null;
                try {
                    globalPolled = (Job)HybridScheduler.this.globalQueue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (globalPolled == null) continue;
                try {
                    globalPolled.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void dispatch(Job job) {
            this.localQueue.add(job);
            if (this.wip.getAndIncrement() == 0) {
                do {
                    Job polled;
                    if ((polled = this.localQueue.poll()) == null) continue;
                    polled.run();
                } while (this.wip.decrementAndGet() > 0);
            }
        }
    }
}

