/*
 * Decompiled with CFR 0.152.
 */
package greycat.scheduler;

import greycat.plugin.Job;
import greycat.plugin.Scheduler;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class TrampolineScheduler
implements Scheduler {
    private final Deque<Job> queue = new ConcurrentLinkedDeque<Job>();
    private final AtomicInteger wip = new AtomicInteger(0);

    @Override
    public void dispatch(byte affinity, Job job) {
        this.queue.add(job);
        if (this.wip.getAndIncrement() == 0) {
            do {
                Job polled;
                if ((polled = this.queue.poll()) == null) continue;
                polled.run();
            } while (this.wip.decrementAndGet() > 0);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public int workers() {
        return 1;
    }
}

