/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility;

import greycat.struct.Buffer;

public class Base64 {
    private static final byte[] encodeArray;
    private static final int[] decodeArray;

    public static void encodeLongToBuffer(long l, Buffer buffer) {
        boolean empty = true;
        long tmp = l;
        if (l < 0L) {
            tmp = -tmp;
        }
        for (int i = 47; i >= 5; i -= 6) {
            if (empty && ((int)(tmp >> i) & 0x3F) == 0) continue;
            empty = false;
            buffer.write(encodeArray[(int)(tmp >> i) & 0x3F]);
        }
        buffer.write(encodeArray[(int)((tmp & 0x1FL) << 1) + (l < 0L ? 1 : 0)]);
    }

    public static long decodeToLongWithBounds(Buffer buffer, long offsetBegin, long offsetEnd) {
        long result = 0L;
        result += (long)((decodeArray[buffer.read(offsetEnd - 1L)] & 0xFF) >> 1);
        long length = offsetEnd - offsetBegin;
        for (long i = 1L; i < length; ++i) {
            result += (long)(decodeArray[buffer.read(offsetEnd - 1L - i)] & 0xFF) << (int)(6L * i - 1L);
        }
        if ((decodeArray[buffer.read(offsetEnd - 1L)] & 0xFF & 1) != 0) {
            result = -result;
        }
        return result;
    }

    public static void encodeIntToBuffer(int l, Buffer buffer) {
        boolean empty = true;
        int tmp = l;
        if (l < 0) {
            tmp = -tmp;
        }
        for (int i = 29; i >= 5; i -= 6) {
            if (empty && (tmp >> i & 0x3F) == 0) continue;
            empty = false;
            buffer.write(encodeArray[tmp >> i & 0x3F]);
        }
        buffer.write(encodeArray[((tmp & 0x1F) << 1) + (l < 0 ? 1 : 0)]);
    }

    public static int decodeToIntWithBounds(Buffer buffer, long offsetBegin, long offsetEnd) {
        int result = 0;
        result += (decodeArray[buffer.read(offsetEnd - 1L)] & 0xFF) >> 1;
        long length = offsetEnd - offsetBegin;
        int i = 1;
        while ((long)i < length) {
            result += (decodeArray[buffer.read(offsetEnd - 1L - (long)i)] & 0xFF) << 6 * i - 1;
            ++i;
        }
        if ((decodeArray[buffer.read(offsetEnd - 1L)] & 0xFF & 1) != 0) {
            result = -result;
        }
        return result;
    }

    public static void encodeBoolArrayToBuffer(boolean[] boolArr, Buffer buffer) {
        int tmpVal = 0;
        for (int i = 0; i < boolArr.length; ++i) {
            tmpVal |= (boolArr[i] ? 1 : 0) << i % 6;
            if (i % 6 != 5 && i != boolArr.length - 1) continue;
            buffer.write(encodeArray[tmpVal]);
            tmpVal = 0;
        }
    }

    public static boolean[] decodeToBoolArrayWithBounds(Buffer buffer, long offsetBegin, long offsetEnd, int arraySize) {
        boolean[] resultTmp = new boolean[arraySize];
        long length = offsetEnd - offsetBegin;
        int i = 0;
        while ((long)i < length) {
            int bitarray = decodeArray[buffer.read(offsetBegin + (long)i)] & 0xFF;
            for (int bit_i = 0; bit_i < 6 && 6 * i + bit_i < arraySize; ++bit_i) {
                resultTmp[6 * i + bit_i] = (bitarray & 1 << bit_i) != 0;
            }
            ++i;
        }
        return resultTmp;
    }

    public static void encodeDoubleToBuffer(double d, Buffer buffer) {
        long l = Double.doubleToLongBits(d);
        buffer.write(encodeArray[(int)(l >> 58) & 0x3F]);
        buffer.write(encodeArray[(int)(l >> 52) & 0x3F]);
        buffer.write(encodeArray[(int)(l >> 48) & 0xF]);
        for (int i = 42; i >= 0; i -= 6) {
            if ((l >> i & 0x3FL) == 0L && (l & (-1L << i ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                return;
            }
            buffer.write(encodeArray[(int)(l >> i) & 0x3F]);
        }
    }

    public static double decodeToDoubleWithBounds(Buffer buffer, long offsetBegin, long offsetEnd) {
        long result = 0L;
        result += ((long)decodeArray[buffer.read(offsetBegin)] & 0xFFL) << 58;
        result += ((long)decodeArray[buffer.read(offsetBegin + 1L)] & 0xFFL) << 52;
        int i = 2;
        while ((long)i < offsetEnd - offsetBegin) {
            result += ((long)decodeArray[buffer.read(offsetBegin + (long)i)] & 0xFFL) << 48 - 6 * (i - 2);
            ++i;
        }
        return Double.longBitsToDouble(result);
    }

    public static void encodeStringToBuffer(String s, Buffer buffer) {
        int sLength = s.length();
        int currentEncodedChar = 0;
        int freeBitsInCurrentChar = 6;
        for (int charIdx = 0; charIdx < sLength; ++charIdx) {
            char currentSourceChar = s.charAt(charIdx);
            if (freeBitsInCurrentChar == 6) {
                buffer.write(encodeArray[currentSourceChar >> 2 & 0x3F]);
                currentEncodedChar = (currentSourceChar & 3) << 4;
                freeBitsInCurrentChar = 4;
                continue;
            }
            if (freeBitsInCurrentChar == 4) {
                buffer.write(encodeArray[(currentEncodedChar | currentSourceChar >> 4 & 0xF) & 0x3F]);
                currentEncodedChar = (currentSourceChar & 0xF) << 2;
                freeBitsInCurrentChar = 2;
                continue;
            }
            if (freeBitsInCurrentChar != 2) continue;
            buffer.write(encodeArray[(currentEncodedChar | currentSourceChar >> 6 & 3) & 0x3F]);
            buffer.write(encodeArray[currentSourceChar & 0x3F]);
            freeBitsInCurrentChar = 6;
        }
        if (freeBitsInCurrentChar != 6) {
            buffer.write(encodeArray[currentEncodedChar]);
        }
    }

    public static String decodeToStringWithBounds(Buffer buffer, long offsetBegin, long offsetEnd) {
        if (offsetBegin == offsetEnd) {
            return null;
        }
        String result = "";
        int currentDecodedChar = 0;
        int freeBitsInCurrentChar = 8;
        for (long charIdx = offsetBegin; charIdx < offsetEnd; ++charIdx) {
            int currentSourceChar = decodeArray[buffer.read(charIdx)];
            if (freeBitsInCurrentChar == 8) {
                currentDecodedChar = currentSourceChar << 2;
                freeBitsInCurrentChar = 2;
                continue;
            }
            if (freeBitsInCurrentChar == 2) {
                result = result + (char)(currentDecodedChar | currentSourceChar >> 4);
                currentDecodedChar = (currentSourceChar & 0xF) << 4;
                freeBitsInCurrentChar = 4;
                continue;
            }
            if (freeBitsInCurrentChar == 4) {
                result = result + (char)(currentDecodedChar | currentSourceChar >> 2);
                currentDecodedChar = (currentSourceChar & 3) << 6;
                freeBitsInCurrentChar = 6;
                continue;
            }
            if (freeBitsInCurrentChar != 6) continue;
            result = result + (char)(currentDecodedChar | currentSourceChar);
            freeBitsInCurrentChar = 8;
        }
        return result;
    }

    static {
        int c;
        encodeArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        decodeArray = new int[123];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((byte)(c + 1))) {
            Base64.decodeArray[c] = i++;
        }
        for (c = 97; c <= 122; c = (int)((byte)(c + 1))) {
            Base64.decodeArray[c] = i++;
        }
        for (c = 48; c <= 57; c = (int)((byte)(c + 1))) {
            Base64.decodeArray[c] = i++;
        }
        Base64.decodeArray[43] = i++;
        Base64.decodeArray[47] = i;
    }
}

