/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility;

import greycat.utility.EnforcerChecker;
import java.util.HashMap;
import java.util.Map;

public class Enforcer {
    private final Map<String, EnforcerChecker> checkers = new HashMap<String, EnforcerChecker>();

    public Enforcer asBool(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                if (input != null && inputType != 1) {
                    throw new RuntimeException("Property " + propertyName + " should be Boolean value, currently " + input);
                }
            }
        });
    }

    public Enforcer asString(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                if (input != null && inputType != 2) {
                    throw new RuntimeException("Property " + propertyName + " should be String value, currently " + input);
                }
            }
        });
    }

    public Enforcer asLong(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                if (input != null && inputType != 3 && inputType != 4) {
                    throw new RuntimeException("Property " + propertyName + " should be long value, currently " + input);
                }
            }
        });
    }

    public Enforcer asLongWithin(final String propertyName, final long min, final long max) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                long inputDouble = (Long)input;
                if (input != null && (inputType != 3 && inputType != 4 || inputDouble < min || inputDouble > max)) {
                    throw new RuntimeException("Property " + propertyName + " should be long value [" + min + "," + max + "], currently " + input);
                }
            }
        });
    }

    public Enforcer asDouble(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                if (input != null && inputType != 5 && inputType != 4 && inputType != 3) {
                    throw new RuntimeException("Property " + propertyName + " should be double value, currently " + input);
                }
            }
        });
    }

    public Enforcer asDoubleWithin(final String propertyName, final double min, final double max) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                double inputDouble = input instanceof Integer ? (double)((Integer)input).intValue() : (input instanceof Long ? (double)((Long)input).longValue() : (Double)input);
                if (input != null && (inputType != 5 && inputType != 4 && inputType != 3 || inputDouble < min || inputDouble > max)) {
                    throw new RuntimeException("Property " + propertyName + " should be double value [" + min + "," + max + "], currently " + input);
                }
            }
        });
    }

    public Enforcer asInt(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                if (input != null && inputType != 4 && inputType != 3) {
                    throw new RuntimeException("Property " + propertyName + " should be integer value, currently " + input);
                }
            }
        });
    }

    public Enforcer asIntWithin(final String propertyName, final int min, final int max) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                int inputInt = (Integer)input;
                if (input != null && (inputType != 4 && inputType != 3 || inputInt < min || inputInt > max)) {
                    throw new RuntimeException("Property " + propertyName + " should be integer value [" + min + "," + max + "], currently " + input);
                }
            }
        });
    }

    public Enforcer asIntGreaterOrEquals(final String propertyName, final int min) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                int inputInt = (Integer)input;
                if (input != null && (inputType != 4 && inputType != 3 || inputInt < min)) {
                    throw new RuntimeException("Property " + propertyName + " should be integer value >=" + min + ", currently " + input);
                }
            }
        });
    }

    public Enforcer asDoubleArray(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                if (input != null && inputType != 6) {
                    throw new RuntimeException("Property " + propertyName + " should be doubleArray value, currently " + input);
                }
            }
        });
    }

    public Enforcer asPositiveInt(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                int inputInt = (Integer)input;
                if (input != null && inputType != 4 || inputInt <= 0) {
                    throw new RuntimeException("Property " + propertyName + " should be a positive integer, currently " + input);
                }
            }
        });
    }

    public Enforcer asNonNegativeDouble(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                double inputDouble = input instanceof Integer ? (double)((Integer)input).intValue() : (input instanceof Long ? (double)((Long)input).longValue() : (Double)input);
                if (input != null && (inputType != 5 && inputType != 4 && inputType != 3 || !(inputDouble >= 0.0))) {
                    throw new RuntimeException("Property " + propertyName + " should be a non-negative double, currently " + input);
                }
            }
        });
    }

    public Enforcer asPositiveDouble(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                double inputDouble = input instanceof Integer ? (double)((Integer)input).intValue() : (input instanceof Long ? (double)((Long)input).longValue() : (Double)input);
                if (input != null && (inputType != 5 && inputType != 4 && inputType != 3 || !(inputDouble > 0.0))) {
                    throw new RuntimeException("Property " + propertyName + " should be a positive double, currently " + input);
                }
            }
        });
    }

    public Enforcer asNonNegativeOrNanDouble(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                double inputDouble = input instanceof Integer ? (double)((Integer)input).intValue() : (input instanceof Long ? (double)((Long)input).longValue() : (Double)input);
                if (input != null && (inputType != 5 && inputType != 4 && inputType != 3 || inputDouble < 0.0)) {
                    throw new RuntimeException("Property " + propertyName + " should be a positive double, currently " + input);
                }
            }
        });
    }

    public Enforcer asPositiveLong(final String propertyName) {
        return this.declare(propertyName, new EnforcerChecker(){

            @Override
            public void check(byte inputType, Object input) throws RuntimeException {
                Long inputLong = input instanceof Integer ? Long.valueOf(((Integer)input).intValue()) : Long.valueOf((Long)input);
                if (input != null && (inputType != 3 && inputType != 4 || inputLong <= 0L)) {
                    throw new RuntimeException("Property " + propertyName + " should be a positive long, currently " + input);
                }
            }
        });
    }

    public Enforcer declare(String propertyName, EnforcerChecker checker) {
        this.checkers.put(propertyName, checker);
        return this;
    }

    public void check(String propertyName, byte propertyType, Object propertyValue) {
        EnforcerChecker checker = this.checkers.get(propertyName);
        if (checker != null) {
            checker.check(propertyType, propertyValue);
        }
    }
}

