/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility;

public class HashHelper {
    private static final long PRIME1 = 2654435761L;
    private static final long PRIME2 = 2246822519L;
    private static final long PRIME3 = 3266489917L;
    private static final long PRIME4 = 668265263L;
    private static final long PRIME5 = 374761393L;
    private static final int len = 24;
    private static final long[] byteTable = HashHelper.createLookupTable();
    private static final long HSTART = -4953706369002393500L;
    private static final long HMULT = 7664345821815920749L;

    public static long longHash(long number, long max) {
        long hash = number % max;
        return hash < 0L ? hash * -1L : hash;
    }

    public static long simpleTripleHash(byte p0, long p1, long p2, long p3, long max) {
        long hash = ((long)p0 ^ p1 ^ p2 ^ p3) % max;
        if (hash < 0L) {
            hash *= -1L;
        }
        return hash;
    }

    public static long tripleHash(byte p0, long p1, long p2, long p3, long max) {
        if (max <= 0L) {
            throw new IllegalArgumentException("Max must be > 0");
        }
        long v1 = 374761393L;
        long v2 = v1 * 2246822519L + 24L;
        long v3 = v2 * 3266489917L;
        long v4 = v3 * 668265263L;
        v1 = (v1 << 13 | v1 >>> 51) + p1;
        v2 = (v2 << 11 | v2 >>> 53) + p2;
        v3 = (v3 << 17 | v3 >>> 47) + p3;
        v4 = (v4 << 19 | v4 >>> 45) + (long)p0;
        v1 += v1 << 17 | v1 >>> 47;
        v2 += v2 << 19 | v2 >>> 45;
        v3 += v3 << 13 | v3 >>> 51;
        v4 += v4 << 11 | v4 >>> 53;
        v1 *= 2654435761L;
        v2 *= 2654435761L;
        v3 *= 2654435761L;
        v4 *= 2654435761L;
        v1 += p1;
        v2 += p2;
        v3 += p3;
        v4 += 374761393L;
        v1 *= 2246822519L;
        v2 *= 2246822519L;
        v3 *= 2246822519L;
        v4 *= 2246822519L;
        v1 += v1 << 11 | v1 >>> 53;
        v2 += v2 << 17 | v2 >>> 47;
        v3 += v3 << 19 | v3 >>> 45;
        v4 += v4 << 13 | v4 >>> 51;
        long crc = (v1 *= 3266489917L) + ((v2 *= 3266489917L) << 3 | v2 >>> 61) + ((v3 *= 3266489917L) << 6 | v3 >>> 58) + ((v4 *= 3266489917L) << 9 | v4 >>> 55);
        crc ^= crc >>> 11;
        crc += 1773867275647728407L;
        crc ^= crc >>> 15;
        crc *= 2246822519L;
        crc = (crc ^= crc >>> 13) < 0L ? crc * -1L : crc;
        return crc %= max;
    }

    public static long rand() {
        return (long)(Math.random() * 9.00719925474099E15);
    }

    public static boolean equals(String src, String other) {
        return src.equals(other);
    }

    public static double DOUBLE_MIN_VALUE() {
        return Double.MIN_VALUE;
    }

    public static double DOUBLE_MAX_VALUE() {
        return Double.MAX_VALUE;
    }

    public static boolean isDefined(Object param) {
        return param != null;
    }

    public static int hash(String data) {
        return data.hashCode();
    }

    public static long hashBytes(byte[] data) {
        long h = -4953706369002393500L;
        long hmult = 7664345821815920749L;
        long[] ht = byteTable;
        int dataLength = data.length;
        for (int i = 0; i < dataLength; ++i) {
            h = h * 7664345821815920749L ^ ht[data[i] & 0xFF];
        }
        return h % 0x1FFFFFFFFFFFFEL;
    }

    private static final long[] createLookupTable() {
        long[] byteTable = new long[256];
        long h = 6074001001750140548L;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 31; ++j) {
                h = h >>> 7 ^ h;
                h = h << 11 ^ h;
                h = h >>> 10 ^ h;
            }
            byteTable[i] = h;
        }
        return byteTable;
    }
}

