/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility;

import greycat.struct.LongLongMapCallBack;
import greycat.utility.HashHelper;
import java.util.Arrays;

public class LongMap {
    private int mapSize = 0;
    private int capacity = 0;
    private long[] keys = null;
    private long[] values = null;
    private int[] next_hashs = null;
    private final boolean _withValue;

    public LongMap(boolean withValue) {
        this._withValue = withValue;
    }

    private long key(int i) {
        return this.keys[i];
    }

    private void setKey(int i, long newValue) {
        this.keys[i] = newValue;
    }

    private long value(int i) {
        return this.values[i];
    }

    private void setValue(int i, long newValue) {
        this.values[i] = newValue;
    }

    private int next(int i) {
        return this.next_hashs[i];
    }

    private void setNext(int i, int newValue) {
        this.next_hashs[i] = newValue;
    }

    private int hash(int i, int capacity) {
        return this.next_hashs[i + capacity];
    }

    private void setHash(int i, int newValue, int capacity) {
        this.next_hashs[i + capacity] = newValue;
    }

    private void reallocate(int newCapacity) {
        if (newCapacity > this.capacity) {
            long[] new_keys = new long[newCapacity];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, new_keys, 0, this.capacity);
            }
            this.keys = new_keys;
            if (this._withValue) {
                long[] new_values = new long[newCapacity];
                if (this.values != null) {
                    System.arraycopy(this.values, 0, new_values, 0, this.capacity);
                }
                this.values = new_values;
            }
            int[] new_next_hashes = new int[newCapacity * 3];
            Arrays.fill(new_next_hashes, 0, newCapacity * 3, -1);
            this.next_hashs = new_next_hashes;
            for (int i = 0; i < this.mapSize; ++i) {
                int new_key_hash = (int)HashHelper.longHash(this.key(i), newCapacity * 2);
                this.setNext(i, this.hash(new_key_hash, newCapacity));
                this.setHash(new_key_hash, i, newCapacity);
            }
            this.capacity = newCapacity;
        }
    }

    public final long get(long requestKey) {
        long result = 0x1FFFFFFFFFFFFFL;
        if (this.keys != null) {
            int hashIndex = (int)HashHelper.longHash(requestKey, this.capacity * 2);
            int m = this.hash(hashIndex, this.capacity);
            while (m >= 0) {
                if (requestKey == this.key(m)) {
                    result = this.value(m);
                    break;
                }
                m = this.next(m);
            }
        }
        return result;
    }

    public final void each(LongLongMapCallBack callback) {
        for (int i = 0; i < this.mapSize; ++i) {
            callback.on(this.key(i), this.value(i));
        }
    }

    public final long getKey(int index) {
        return this.key(index);
    }

    public final int size() {
        return this.mapSize;
    }

    public final void remove(long requestKey) {
        if (this.keys != null && this.mapSize != 0) {
            long hashCapacity = this.capacity * 2;
            int hashIndex = (int)HashHelper.longHash(requestKey, hashCapacity);
            int m = this.hash(hashIndex, this.capacity);
            int found = -1;
            while (m >= 0) {
                if (requestKey == this.key(m)) {
                    found = m;
                    break;
                }
                m = this.next(m);
            }
            if (found != -1) {
                int toRemoveHash = (int)HashHelper.longHash(requestKey, hashCapacity);
                m = this.hash(toRemoveHash, this.capacity);
                if (m == found) {
                    this.setHash(toRemoveHash, this.next(m), this.capacity);
                } else {
                    while (m != -1) {
                        int next_of_m = this.next(m);
                        if (next_of_m == found) {
                            this.setNext(m, this.next(next_of_m));
                            break;
                        }
                        m = next_of_m;
                    }
                }
                int lastIndex = this.mapSize - 1;
                if (lastIndex == found) {
                    --this.mapSize;
                } else {
                    long lastKey = this.key(lastIndex);
                    this.setKey(found, lastKey);
                    if (this._withValue) {
                        this.setValue(found, this.value(lastIndex));
                    }
                    this.setNext(found, this.next(lastIndex));
                    int victimHash = (int)HashHelper.longHash(lastKey, hashCapacity);
                    m = this.hash(victimHash, this.capacity);
                    if (m == lastIndex) {
                        this.setHash(victimHash, found, this.capacity);
                    } else {
                        while (m != -1) {
                            int next_of_m = this.next(m);
                            if (next_of_m == lastIndex) {
                                this.setNext(m, found);
                                break;
                            }
                            m = next_of_m;
                        }
                    }
                    --this.mapSize;
                }
            }
        }
    }

    public final boolean add(long insertKey) {
        return this.put(insertKey, insertKey);
    }

    public final boolean put(long insertKey, long insertValue) {
        int currentHash;
        if (this.keys == null) {
            this.reallocate(8);
            this.setKey(0, insertKey);
            if (this._withValue) {
                this.setValue(0, insertValue);
            }
            this.setHash((int)HashHelper.longHash(insertKey, this.capacity * 2), 0, this.capacity);
            this.setNext(0, -1);
            ++this.mapSize;
            return true;
        }
        long hashCapacity = this.capacity * 2;
        int insertKeyHash = (int)HashHelper.longHash(insertKey, hashCapacity);
        int m = currentHash = this.hash(insertKeyHash, this.capacity);
        int found = -1;
        while (m >= 0) {
            if (insertKey == this.key(m)) {
                found = m;
                break;
            }
            m = this.next(m);
        }
        if (found == -1) {
            int lastIndex = this.mapSize;
            if (lastIndex == this.capacity) {
                this.reallocate(this.capacity * 2);
                hashCapacity = this.capacity * 2;
                insertKeyHash = (int)HashHelper.longHash(insertKey, hashCapacity);
                currentHash = this.hash(insertKeyHash, this.capacity);
            }
            this.setKey(lastIndex, insertKey);
            if (this._withValue) {
                this.setValue(lastIndex, insertValue);
            }
            this.setHash((int)HashHelper.longHash(insertKey, this.capacity * 2), lastIndex, this.capacity);
            this.setNext(lastIndex, currentHash);
            ++this.mapSize;
            return true;
        }
        if (this._withValue && this.value(found) != insertValue) {
            this.setValue(found, insertValue);
            return true;
        }
        return false;
    }
}

