/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility;

import greycat.Action;
import greycat.TaskContext;
import greycat.TaskHook;
import java.util.HashMap;
import java.util.Map;

public class VerboseHook
implements TaskHook {
    private Map<TaskContext, Integer> ctxIdents = new HashMap<TaskContext, Integer>();

    @Override
    public synchronized void start(TaskContext initialContext) {
        this.ctxIdents.put(initialContext, 0);
        System.out.println("StartTask:" + initialContext);
    }

    @Override
    public synchronized void beforeAction(Action action, TaskContext context) {
        Integer currentPrefix = this.ctxIdents.get(context);
        for (int i = 0; i < currentPrefix; ++i) {
            System.out.print("\t");
        }
        String taskName = action.toString();
        System.out.println(context.template(taskName));
    }

    @Override
    public synchronized void afterAction(Action action, TaskContext context) {
    }

    @Override
    public synchronized void beforeTask(TaskContext parentContext, TaskContext context) {
        Integer currentPrefix = this.ctxIdents.get(parentContext);
        this.ctxIdents.put(context, currentPrefix + 1);
    }

    @Override
    public synchronized void afterTask(TaskContext context) {
        this.ctxIdents.remove(context);
    }

    @Override
    public synchronized void end(TaskContext finalContext) {
        System.out.println("EndTask:" + finalContext.toString());
    }
}

