/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility.distance;

import greycat.utility.distance.CosineDistance;
import greycat.utility.distance.Distance;
import greycat.utility.distance.EuclideanDistance;
import greycat.utility.distance.GaussianDistance;
import greycat.utility.distance.GeoDistance;
import greycat.utility.distance.PearsonDistance;

public class Distances {
    public static final int EUCLIDEAN = 0;
    public static final int GEODISTANCE = 1;
    public static final int COSINE = 2;
    public static final int PEARSON = 3;
    public static final int GAUSSIAN = 4;
    public static final int DEFAULT = 0;

    public static Distance getDistance(int distance, double[] distancearg) {
        switch (distance) {
            case 0: {
                return EuclideanDistance.instance();
            }
            case 1: {
                return GeoDistance.instance();
            }
            case 2: {
                return CosineDistance.instance();
            }
            case 3: {
                return PearsonDistance.instance();
            }
            case 4: {
                return new GaussianDistance(distancearg);
            }
        }
        return Distances.getDistance(0, null);
    }
}

