/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility.distance;

import greycat.utility.distance.Distance;

public class GaussianDistance
implements Distance {
    double[] err;

    public GaussianDistance(double[] covariance) {
        this.err = covariance;
    }

    @Override
    public double measure(double[] x, double[] y) {
        double max = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double temp = (x[i] - y[i]) * (x[i] - y[i]) / this.err[i];
            if (!(temp > max)) continue;
            max = temp;
        }
        return Math.sqrt(max);
    }

    @Override
    public boolean compare(double x, double y) {
        return x < y;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return Double.MAX_VALUE;
    }
}

