/*
 * Decompiled with CFR 0.152.
 */
package greycat.utility.distance;

import greycat.utility.distance.Distance;

public class GeoDistance
implements Distance {
    private static GeoDistance static_instance = null;

    public static GeoDistance instance() {
        if (static_instance == null) {
            static_instance = new GeoDistance();
        }
        return static_instance;
    }

    private GeoDistance() {
    }

    @Override
    public final double measure(double[] x, double[] y) {
        double earthRadius = 6371000.0;
        double dLat = GeoDistance.toRadians(y[0] - x[0]);
        double dLng = GeoDistance.toRadians(y[1] - x[1]);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(GeoDistance.toRadians(x[0])) * Math.cos(GeoDistance.toRadians(y[0])) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return earthRadius * c;
    }

    private static double toRadians(double angledeg) {
        return Math.toRadians(angledeg);
    }

    @Override
    public final boolean compare(double x, double y) {
        return x < y;
    }

    @Override
    public final double getMinValue() {
        return 0.0;
    }

    @Override
    public final double getMaxValue() {
        return Double.MAX_VALUE;
    }
}

