/*
 * Decompiled with CFR 0.152.
 */
package com.dimafeng.testcontainers;

import com.dimafeng.testcontainers.ContainerDef;
import com.dimafeng.testcontainers.RabbitMQContainer$;
import com.dimafeng.testcontainers.RabbitMQContainer$Binding$;
import com.dimafeng.testcontainers.RabbitMQContainer$Def$;
import com.dimafeng.testcontainers.RabbitMQContainer$Exchange$;
import com.dimafeng.testcontainers.RabbitMQContainer$OperatorPolicy$;
import com.dimafeng.testcontainers.RabbitMQContainer$Parameter$;
import com.dimafeng.testcontainers.RabbitMQContainer$Permission$;
import com.dimafeng.testcontainers.RabbitMQContainer$Policy$;
import com.dimafeng.testcontainers.RabbitMQContainer$Queue$;
import com.dimafeng.testcontainers.RabbitMQContainer$SslConfig$;
import com.dimafeng.testcontainers.RabbitMQContainer$User$;
import com.dimafeng.testcontainers.RabbitMQContainer$VHost$;
import com.dimafeng.testcontainers.RabbitMQContainer$VHostLimit$;
import com.dimafeng.testcontainers.SingleContainer;
import java.io.Serializable;
import java.util.Set;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class RabbitMQContainer
extends SingleContainer<org.testcontainers.containers.RabbitMQContainer>
implements Product,
Serializable {
    private final DockerImageName dockerImageName;
    private final String adminPassword;
    private final Seq queues;
    private final Seq exchanges;
    private final Seq bindings;
    private final Seq users;
    private final Seq vhosts;
    private final Seq vhostsLimits;
    private final Seq operatorPolicies;
    private final Seq policies;
    private final Seq parameters;
    private final Seq permissions;
    private final Seq pluginsEnabled;
    private final Option ssl;
    private final Option rabbitMqConfig;
    private final Option rabbitMqConfigErlang;
    private final Option rabbitMqConfigSysctl;
    private final org.testcontainers.containers.RabbitMQContainer container;

    public static RabbitMQContainer apply(DockerImageName dockerImageName, String string, Seq<Queue> seq, Seq<Exchange> seq2, Seq<Binding> seq3, Seq<User> seq4, Seq<VHost> seq5, Seq<VHostLimit> seq6, Seq<OperatorPolicy> seq7, Seq<Policy> seq8, Seq<Parameter> seq9, Seq<Permission> seq10, Seq<String> seq11, Option<SslConfig> option, Option<MountableFile> option2, Option<MountableFile> option3, Option<MountableFile> option4) {
        return RabbitMQContainer$.MODULE$.apply(dockerImageName, string, seq, seq2, seq3, seq4, seq5, seq6, seq7, seq8, seq9, seq10, seq11, option, option2, option3, option4);
    }

    public static String defaultAdminPassword() {
        return RabbitMQContainer$.MODULE$.defaultAdminPassword();
    }

    public static String defaultDockerImageName() {
        return RabbitMQContainer$.MODULE$.defaultDockerImageName();
    }

    public static String defaultImage() {
        return RabbitMQContainer$.MODULE$.defaultImage();
    }

    public static String defaultTag() {
        return RabbitMQContainer$.MODULE$.defaultTag();
    }

    public static RabbitMQContainer fromProduct(Product product) {
        return RabbitMQContainer$.MODULE$.fromProduct(product);
    }

    public static RabbitMQContainer unapply(RabbitMQContainer rabbitMQContainer) {
        return RabbitMQContainer$.MODULE$.unapply(rabbitMQContainer);
    }

    public static DockerImageName $lessinit$greater$default$1() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$1();
    }

    public static String $lessinit$greater$default$2() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$2();
    }

    public static Seq<Queue> $lessinit$greater$default$3() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<Exchange> $lessinit$greater$default$4() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Binding> $lessinit$greater$default$5() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<User> $lessinit$greater$default$6() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<VHost> $lessinit$greater$default$7() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$7();
    }

    public static Seq<VHostLimit> $lessinit$greater$default$8() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$8();
    }

    public static Seq<OperatorPolicy> $lessinit$greater$default$9() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$9();
    }

    public static Seq<Policy> $lessinit$greater$default$10() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$10();
    }

    public static Seq<Parameter> $lessinit$greater$default$11() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$11();
    }

    public static Seq<Permission> $lessinit$greater$default$12() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$12();
    }

    public static Seq<String> $lessinit$greater$default$13() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$13();
    }

    public static Option<SslConfig> $lessinit$greater$default$14() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$14();
    }

    public static Option<MountableFile> $lessinit$greater$default$15() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$15();
    }

    public static Option<MountableFile> $lessinit$greater$default$16() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$16();
    }

    public static Option<MountableFile> $lessinit$greater$default$17() {
        return RabbitMQContainer$.MODULE$.$lessinit$greater$default$17();
    }

    public RabbitMQContainer(DockerImageName dockerImageName, String adminPassword, Seq<Queue> queues, Seq<Exchange> exchanges, Seq<Binding> bindings, Seq<User> users, Seq<VHost> vhosts, Seq<VHostLimit> vhostsLimits, Seq<OperatorPolicy> operatorPolicies, Seq<Policy> policies, Seq<Parameter> parameters, Seq<Permission> permissions, Seq<String> pluginsEnabled, Option<SslConfig> ssl, Option<MountableFile> rabbitMqConfig, Option<MountableFile> rabbitMqConfigErlang, Option<MountableFile> rabbitMqConfigSysctl) {
        this.dockerImageName = dockerImageName;
        this.adminPassword = adminPassword;
        this.queues = queues;
        this.exchanges = exchanges;
        this.bindings = bindings;
        this.users = users;
        this.vhosts = vhosts;
        this.vhostsLimits = vhostsLimits;
        this.operatorPolicies = operatorPolicies;
        this.policies = policies;
        this.parameters = parameters;
        this.permissions = permissions;
        this.pluginsEnabled = pluginsEnabled;
        this.ssl = ssl;
        this.rabbitMqConfig = rabbitMqConfig;
        this.rabbitMqConfigErlang = rabbitMqConfigErlang;
        this.rabbitMqConfigSysctl = rabbitMqConfigSysctl;
        org.testcontainers.containers.RabbitMQContainer c = new org.testcontainers.containers.RabbitMQContainer(dockerImageName);
        c.withAdminPassword(adminPassword);
        vhosts.foreach((Function1 & Serializable)x$1 -> {
            org.testcontainers.containers.RabbitMQContainer rabbitMQContainer;
            VHost vHost = x$1;
            if (vHost == null) throw new MatchError((Object)vHost);
            VHost vHost2 = RabbitMQContainer$VHost$.MODULE$.unapply(vHost);
            String string = vHost2._1();
            Option<Object> option = vHost2._2();
            String name = string;
            if (option instanceof Some) {
                boolean tracing = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
                rabbitMQContainer = c.withVhost(name, tracing);
                return rabbitMQContainer;
            } else {
                String name2 = string;
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)vHost);
                rabbitMQContainer = c.withVhost(name2);
            }
            return rabbitMQContainer;
        });
        vhostsLimits.foreach((Function1 & Serializable)x -> c.withVhostLimit(x.vhost(), x.name(), x.value()));
        queues.foreach((Function1 & Serializable)x -> c.withQueue(x.name(), x.autoDelete(), x.durable(), this.toJavaArguments(x.arguments())));
        exchanges.foreach((Function1 & Serializable)x -> {
            org.testcontainers.containers.RabbitMQContainer rabbitMQContainer;
            Option<String> option = x.vhost();
            if (option instanceof Some) {
                String vhost = (String)((Some)option).value();
                rabbitMQContainer = c.withExchange(vhost, x.name(), x.exchangeType(), x.autoDelete(), x.internal(), x.durable(), this.toJavaArguments(x.arguments()));
            } else if (None$.MODULE$.equals(option)) {
                rabbitMQContainer = c.withExchange(x.name(), x.exchangeType(), x.autoDelete(), x.internal(), x.durable(), this.toJavaArguments(x.arguments()));
            } else {
                throw new MatchError(option);
            }
            return rabbitMQContainer;
        });
        bindings.foreach((Function1 & Serializable)x -> c.withBinding(x.source(), x.destination(), this.toJavaArguments(x.arguments()), x.routingKey(), x.destinationType()));
        users.foreach((Function1 & Serializable)x -> x.tags().isEmpty() ? c.withUser(x.name(), x.password()) : c.withUser(x.name(), x.password(), (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(x.tags()).asJava()));
        operatorPolicies.foreach((Function1 & Serializable)x -> c.withOperatorPolicy(x.name(), x.pattern(), this.toJavaArguments(x.definition()), x.priority(), x.applyTo()));
        policies.foreach((Function1 & Serializable)x -> c.withPolicy(x.name(), x.pattern(), this.toJavaArguments(x.definition()), x.priority(), x.applyTo()));
        parameters.foreach((Function1 & Serializable)x -> c.withParameter(x.component(), x.name(), x.value()));
        permissions.foreach((Function1 & Serializable)x -> c.withPermission(x.vhost(), x.user(), x.configure(), x.write(), x.read()));
        if (pluginsEnabled.nonEmpty()) {
            c.withPluginsEnabled((String[])Arrays$.MODULE$.seqToArray(pluginsEnabled, String.class));
        }
        ssl.foreach((Function1)(JProcedure1 & Serializable)x -> {
            c.withSSL(x.keyFile(), x.certFile(), x.caFile(), x.verify());
            x.failIfNoCert().foreach((Function1 & Serializable)xx -> RabbitMQContainer.$init$$$anonfun$15$$anonfun$1(c, BoxesRunTime.unboxToBoolean((Object)xx)));
            x.verificationDepth().foreach((Function1 & Serializable)xx -> RabbitMQContainer.$init$$$anonfun$17$$anonfun$2(c, BoxesRunTime.unboxToInt((Object)xx)));
        });
        rabbitMqConfig.foreach((Function1 & Serializable)x$0 -> c.withRabbitMQConfig(x$0));
        rabbitMqConfigErlang.foreach((Function1 & Serializable)x$0 -> c.withRabbitMQConfigErlang(x$0));
        rabbitMqConfigSysctl.foreach((Function1 & Serializable)x$0 -> c.withRabbitMQConfigSysctl(x$0));
        this.container = c;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RabbitMQContainer)) return false;
        RabbitMQContainer rabbitMQContainer = (RabbitMQContainer)object;
        DockerImageName dockerImageName = this.dockerImageName();
        DockerImageName dockerImageName2 = rabbitMQContainer.dockerImageName();
        if (dockerImageName == null) {
            if (dockerImageName2 != null) {
                return false;
            }
        } else if (!dockerImageName.equals(dockerImageName2)) return false;
        String string = this.adminPassword();
        String string2 = rabbitMQContainer.adminPassword();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<Queue> seq = this.queues();
        Seq<Queue> seq2 = rabbitMQContainer.queues();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Exchange> seq3 = this.exchanges();
        Seq<Exchange> seq4 = rabbitMQContainer.exchanges();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        Seq<Binding> seq5 = this.bindings();
        Seq<Binding> seq6 = rabbitMQContainer.bindings();
        if (seq5 == null) {
            if (seq6 != null) {
                return false;
            }
        } else if (!seq5.equals(seq6)) return false;
        Seq<User> seq7 = this.users();
        Seq<User> seq8 = rabbitMQContainer.users();
        if (seq7 == null) {
            if (seq8 != null) {
                return false;
            }
        } else if (!seq7.equals(seq8)) return false;
        Seq<VHost> seq9 = this.vhosts();
        Seq<VHost> seq10 = rabbitMQContainer.vhosts();
        if (seq9 == null) {
            if (seq10 != null) {
                return false;
            }
        } else if (!seq9.equals(seq10)) return false;
        Seq<VHostLimit> seq11 = this.vhostsLimits();
        Seq<VHostLimit> seq12 = rabbitMQContainer.vhostsLimits();
        if (seq11 == null) {
            if (seq12 != null) {
                return false;
            }
        } else if (!seq11.equals(seq12)) return false;
        Seq<OperatorPolicy> seq13 = this.operatorPolicies();
        Seq<OperatorPolicy> seq14 = rabbitMQContainer.operatorPolicies();
        if (seq13 == null) {
            if (seq14 != null) {
                return false;
            }
        } else if (!seq13.equals(seq14)) return false;
        Seq<Policy> seq15 = this.policies();
        Seq<Policy> seq16 = rabbitMQContainer.policies();
        if (seq15 == null) {
            if (seq16 != null) {
                return false;
            }
        } else if (!seq15.equals(seq16)) return false;
        Seq<Parameter> seq17 = this.parameters();
        Seq<Parameter> seq18 = rabbitMQContainer.parameters();
        if (seq17 == null) {
            if (seq18 != null) {
                return false;
            }
        } else if (!seq17.equals(seq18)) return false;
        Seq<Permission> seq19 = this.permissions();
        Seq<Permission> seq20 = rabbitMQContainer.permissions();
        if (seq19 == null) {
            if (seq20 != null) {
                return false;
            }
        } else if (!seq19.equals(seq20)) return false;
        Seq<String> seq21 = this.pluginsEnabled();
        Seq<String> seq22 = rabbitMQContainer.pluginsEnabled();
        if (seq21 == null) {
            if (seq22 != null) {
                return false;
            }
        } else if (!seq21.equals(seq22)) return false;
        Option<SslConfig> option = this.ssl();
        Option<SslConfig> option2 = rabbitMQContainer.ssl();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<MountableFile> option3 = this.rabbitMqConfig();
        Option<MountableFile> option4 = rabbitMQContainer.rabbitMqConfig();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<MountableFile> option5 = this.rabbitMqConfigErlang();
        Option<MountableFile> option6 = rabbitMQContainer.rabbitMqConfigErlang();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<MountableFile> option7 = this.rabbitMqConfigSysctl();
        Option<MountableFile> option8 = rabbitMQContainer.rabbitMqConfigSysctl();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        if (!rabbitMQContainer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof RabbitMQContainer;
    }

    public int productArity() {
        return 17;
    }

    public String productPrefix() {
        return "RabbitMQContainer";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            case 5: {
                object = this._6();
                break;
            }
            case 6: {
                object = this._7();
                break;
            }
            case 7: {
                object = this._8();
                break;
            }
            case 8: {
                object = this._9();
                break;
            }
            case 9: {
                object = this._10();
                break;
            }
            case 10: {
                object = this._11();
                break;
            }
            case 11: {
                object = this._12();
                break;
            }
            case 12: {
                object = this._13();
                break;
            }
            case 13: {
                object = this._14();
                break;
            }
            case 14: {
                object = this._15();
                break;
            }
            case 15: {
                object = this._16();
                break;
            }
            case 16: {
                object = this._17();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "dockerImageName";
                break;
            }
            case 1: {
                string = "adminPassword";
                break;
            }
            case 2: {
                string = "queues";
                break;
            }
            case 3: {
                string = "exchanges";
                break;
            }
            case 4: {
                string = "bindings";
                break;
            }
            case 5: {
                string = "users";
                break;
            }
            case 6: {
                string = "vhosts";
                break;
            }
            case 7: {
                string = "vhostsLimits";
                break;
            }
            case 8: {
                string = "operatorPolicies";
                break;
            }
            case 9: {
                string = "policies";
                break;
            }
            case 10: {
                string = "parameters";
                break;
            }
            case 11: {
                string = "permissions";
                break;
            }
            case 12: {
                string = "pluginsEnabled";
                break;
            }
            case 13: {
                string = "ssl";
                break;
            }
            case 14: {
                string = "rabbitMqConfig";
                break;
            }
            case 15: {
                string = "rabbitMqConfigErlang";
                break;
            }
            case 16: {
                string = "rabbitMqConfigSysctl";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public DockerImageName dockerImageName() {
        return this.dockerImageName;
    }

    public String adminPassword() {
        return this.adminPassword;
    }

    public Seq<Queue> queues() {
        return this.queues;
    }

    public Seq<Exchange> exchanges() {
        return this.exchanges;
    }

    public Seq<Binding> bindings() {
        return this.bindings;
    }

    public Seq<User> users() {
        return this.users;
    }

    public Seq<VHost> vhosts() {
        return this.vhosts;
    }

    public Seq<VHostLimit> vhostsLimits() {
        return this.vhostsLimits;
    }

    public Seq<OperatorPolicy> operatorPolicies() {
        return this.operatorPolicies;
    }

    public Seq<Policy> policies() {
        return this.policies;
    }

    public Seq<Parameter> parameters() {
        return this.parameters;
    }

    public Seq<Permission> permissions() {
        return this.permissions;
    }

    public Seq<String> pluginsEnabled() {
        return this.pluginsEnabled;
    }

    public Option<SslConfig> ssl() {
        return this.ssl;
    }

    public Option<MountableFile> rabbitMqConfig() {
        return this.rabbitMqConfig;
    }

    public Option<MountableFile> rabbitMqConfigErlang() {
        return this.rabbitMqConfigErlang;
    }

    public Option<MountableFile> rabbitMqConfigSysctl() {
        return this.rabbitMqConfigSysctl;
    }

    public org.testcontainers.containers.RabbitMQContainer container() {
        return this.container;
    }

    private java.util.Map<String, Object> toJavaArguments(scala.collection.immutable.Map<String, String> map) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return Tuple2$.MODULE$.apply((Object)k, (Object)v);
        })).asJava();
    }

    public String adminUsername() {
        return this.container().getAdminUsername();
    }

    public int amqpPort() {
        return Predef$.MODULE$.Integer2int(this.container().getAmqpPort());
    }

    public int amqpsPort() {
        return Predef$.MODULE$.Integer2int(this.container().getAmqpsPort());
    }

    public int httpPort() {
        return Predef$.MODULE$.Integer2int(this.container().getHttpPort());
    }

    public int httpsPort() {
        return Predef$.MODULE$.Integer2int(this.container().getHttpsPort());
    }

    public String amqpUrl() {
        return this.container().getAmqpUrl();
    }

    public String amqpsUrl() {
        return this.container().getAmqpsUrl();
    }

    public String httpUrl() {
        return this.container().getHttpUrl();
    }

    public String httpsUrl() {
        return this.container().getHttpsUrl();
    }

    public RabbitMQContainer copy(DockerImageName dockerImageName, String adminPassword, Seq<Queue> queues, Seq<Exchange> exchanges, Seq<Binding> bindings, Seq<User> users, Seq<VHost> vhosts, Seq<VHostLimit> vhostsLimits, Seq<OperatorPolicy> operatorPolicies, Seq<Policy> policies, Seq<Parameter> parameters, Seq<Permission> permissions, Seq<String> pluginsEnabled, Option<SslConfig> ssl, Option<MountableFile> rabbitMqConfig, Option<MountableFile> rabbitMqConfigErlang, Option<MountableFile> rabbitMqConfigSysctl) {
        return new RabbitMQContainer(dockerImageName, adminPassword, queues, exchanges, bindings, users, vhosts, vhostsLimits, operatorPolicies, policies, parameters, permissions, pluginsEnabled, ssl, rabbitMqConfig, rabbitMqConfigErlang, rabbitMqConfigSysctl);
    }

    public DockerImageName copy$default$1() {
        return this.dockerImageName();
    }

    public String copy$default$2() {
        return this.adminPassword();
    }

    public Seq<Queue> copy$default$3() {
        return this.queues();
    }

    public Seq<Exchange> copy$default$4() {
        return this.exchanges();
    }

    public Seq<Binding> copy$default$5() {
        return this.bindings();
    }

    public Seq<User> copy$default$6() {
        return this.users();
    }

    public Seq<VHost> copy$default$7() {
        return this.vhosts();
    }

    public Seq<VHostLimit> copy$default$8() {
        return this.vhostsLimits();
    }

    public Seq<OperatorPolicy> copy$default$9() {
        return this.operatorPolicies();
    }

    public Seq<Policy> copy$default$10() {
        return this.policies();
    }

    public Seq<Parameter> copy$default$11() {
        return this.parameters();
    }

    public Seq<Permission> copy$default$12() {
        return this.permissions();
    }

    public Seq<String> copy$default$13() {
        return this.pluginsEnabled();
    }

    public Option<SslConfig> copy$default$14() {
        return this.ssl();
    }

    public Option<MountableFile> copy$default$15() {
        return this.rabbitMqConfig();
    }

    public Option<MountableFile> copy$default$16() {
        return this.rabbitMqConfigErlang();
    }

    public Option<MountableFile> copy$default$17() {
        return this.rabbitMqConfigSysctl();
    }

    public DockerImageName _1() {
        return this.dockerImageName();
    }

    public String _2() {
        return this.adminPassword();
    }

    public Seq<Queue> _3() {
        return this.queues();
    }

    public Seq<Exchange> _4() {
        return this.exchanges();
    }

    public Seq<Binding> _5() {
        return this.bindings();
    }

    public Seq<User> _6() {
        return this.users();
    }

    public Seq<VHost> _7() {
        return this.vhosts();
    }

    public Seq<VHostLimit> _8() {
        return this.vhostsLimits();
    }

    public Seq<OperatorPolicy> _9() {
        return this.operatorPolicies();
    }

    public Seq<Policy> _10() {
        return this.policies();
    }

    public Seq<Parameter> _11() {
        return this.parameters();
    }

    public Seq<Permission> _12() {
        return this.permissions();
    }

    public Seq<String> _13() {
        return this.pluginsEnabled();
    }

    public Option<SslConfig> _14() {
        return this.ssl();
    }

    public Option<MountableFile> _15() {
        return this.rabbitMqConfig();
    }

    public Option<MountableFile> _16() {
        return this.rabbitMqConfigErlang();
    }

    public Option<MountableFile> _17() {
        return this.rabbitMqConfigSysctl();
    }

    private static final /* synthetic */ org.testcontainers.containers.RabbitMQContainer $init$$$anonfun$15$$anonfun$1(org.testcontainers.containers.RabbitMQContainer c$12, boolean xx) {
        return (org.testcontainers.containers.RabbitMQContainer)c$12.withEnv("RABBITMQ_SSL_FAIL_IF_NO_PEER_CERT", String.valueOf(xx));
    }

    private static final /* synthetic */ org.testcontainers.containers.RabbitMQContainer $init$$$anonfun$17$$anonfun$2(org.testcontainers.containers.RabbitMQContainer c$13, int xx) {
        return (org.testcontainers.containers.RabbitMQContainer)c$13.withEnv("RABBITMQ_SSL_DEPTH", String.valueOf(xx));
    }

    public static class Binding
    implements Product,
    Serializable {
        private final String source;
        private final String destination;
        private final String routingKey;
        private final String destinationType;
        private final scala.collection.immutable.Map arguments;

        public static Binding apply(String string, String string2, String string3, String string4, scala.collection.immutable.Map<String, String> map) {
            return RabbitMQContainer$Binding$.MODULE$.apply(string, string2, string3, string4, map);
        }

        public static Binding fromProduct(Product product) {
            return RabbitMQContainer$Binding$.MODULE$.fromProduct(product);
        }

        public static Binding unapply(Binding binding) {
            return RabbitMQContainer$Binding$.MODULE$.unapply(binding);
        }

        public static String $lessinit$greater$default$3() {
            return RabbitMQContainer$Binding$.MODULE$.$lessinit$greater$default$3();
        }

        public static String $lessinit$greater$default$4() {
            return RabbitMQContainer$Binding$.MODULE$.$lessinit$greater$default$4();
        }

        public static scala.collection.immutable.Map<String, String> $lessinit$greater$default$5() {
            return RabbitMQContainer$Binding$.MODULE$.$lessinit$greater$default$5();
        }

        public Binding(String source, String destination, String routingKey, String destinationType, scala.collection.immutable.Map<String, String> arguments) {
            this.source = source;
            this.destination = destination;
            this.routingKey = routingKey;
            this.destinationType = destinationType;
            this.arguments = arguments;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Binding)) return false;
            Binding binding = (Binding)object;
            String string = this.source();
            String string2 = binding.source();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.destination();
            String string4 = binding.destination();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.routingKey();
            String string6 = binding.routingKey();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.destinationType();
            String string8 = binding.destinationType();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            scala.collection.immutable.Map<String, String> map = this.arguments();
            scala.collection.immutable.Map<String, String> map2 = binding.arguments();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!binding.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Binding;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Binding";
        }

        public Object productElement(int n) {
            scala.collection.immutable.Map<String, String> map;
            int n2 = n;
            switch (n2) {
                case 0: {
                    map = this._1();
                    break;
                }
                case 1: {
                    map = this._2();
                    break;
                }
                case 2: {
                    map = this._3();
                    break;
                }
                case 3: {
                    map = this._4();
                    break;
                }
                case 4: {
                    map = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return map;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "source";
                    break;
                }
                case 1: {
                    string = "destination";
                    break;
                }
                case 2: {
                    string = "routingKey";
                    break;
                }
                case 3: {
                    string = "destinationType";
                    break;
                }
                case 4: {
                    string = "arguments";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String source() {
            return this.source;
        }

        public String destination() {
            return this.destination;
        }

        public String routingKey() {
            return this.routingKey;
        }

        public String destinationType() {
            return this.destinationType;
        }

        public scala.collection.immutable.Map<String, String> arguments() {
            return this.arguments;
        }

        public Binding copy(String source, String destination, String routingKey, String destinationType, scala.collection.immutable.Map<String, String> arguments) {
            return new Binding(source, destination, routingKey, destinationType, arguments);
        }

        public String copy$default$1() {
            return this.source();
        }

        public String copy$default$2() {
            return this.destination();
        }

        public String copy$default$3() {
            return this.routingKey();
        }

        public String copy$default$4() {
            return this.destinationType();
        }

        public scala.collection.immutable.Map<String, String> copy$default$5() {
            return this.arguments();
        }

        public String _1() {
            return this.source();
        }

        public String _2() {
            return this.destination();
        }

        public String _3() {
            return this.routingKey();
        }

        public String _4() {
            return this.destinationType();
        }

        public scala.collection.immutable.Map<String, String> _5() {
            return this.arguments();
        }
    }

    public static class Def
    implements ContainerDef,
    Product,
    Serializable {
        private final Option customContent;

        public static Def apply(Option<String> option) {
            return RabbitMQContainer$Def$.MODULE$.apply(option);
        }

        public static Def fromProduct(Product product) {
            return RabbitMQContainer$Def$.MODULE$.fromProduct(product);
        }

        public static Def unapply(Def def) {
            return RabbitMQContainer$Def$.MODULE$.unapply(def);
        }

        public static Option<String> $lessinit$greater$default$1() {
            return RabbitMQContainer$Def$.MODULE$.$lessinit$greater$default$1();
        }

        public Def(Option<String> customContent) {
            this.customContent = customContent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Def)) return false;
            Def def = (Def)object;
            Option<String> option = this.customContent();
            Option<String> option2 = def.customContent();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!def.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Def;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Def";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "customContent";
        }

        public Option<String> customContent() {
            return this.customContent;
        }

        public RabbitMQContainer createContainer() {
            return new RabbitMQContainer(RabbitMQContainer$.MODULE$.$lessinit$greater$default$1(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$2(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$3(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$4(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$5(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$6(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$7(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$8(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$9(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$10(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$11(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$12(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$13(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$14(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$15(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$16(), RabbitMQContainer$.MODULE$.$lessinit$greater$default$17());
        }

        public Def copy(Option<String> customContent) {
            return new Def(customContent);
        }

        public Option<String> copy$default$1() {
            return this.customContent();
        }

        public Option<String> _1() {
            return this.customContent();
        }
    }

    public static class Exchange
    implements Product,
    Serializable {
        private final String name;
        private final String exchangeType;
        private final boolean autoDelete;
        private final boolean internal;
        private final boolean durable;
        private final scala.collection.immutable.Map arguments;
        private final Option vhost;

        public static Exchange apply(String string, String string2, boolean bl, boolean bl2, boolean bl3, scala.collection.immutable.Map<String, String> map, Option<String> option) {
            return RabbitMQContainer$Exchange$.MODULE$.apply(string, string2, bl, bl2, bl3, map, option);
        }

        public static Exchange fromProduct(Product product) {
            return RabbitMQContainer$Exchange$.MODULE$.fromProduct(product);
        }

        public static Exchange unapply(Exchange exchange) {
            return RabbitMQContainer$Exchange$.MODULE$.unapply(exchange);
        }

        public static boolean $lessinit$greater$default$3() {
            return RabbitMQContainer$Exchange$.MODULE$.$lessinit$greater$default$3();
        }

        public static boolean $lessinit$greater$default$4() {
            return RabbitMQContainer$Exchange$.MODULE$.$lessinit$greater$default$4();
        }

        public static boolean $lessinit$greater$default$5() {
            return RabbitMQContainer$Exchange$.MODULE$.$lessinit$greater$default$5();
        }

        public static scala.collection.immutable.Map<String, String> $lessinit$greater$default$6() {
            return RabbitMQContainer$Exchange$.MODULE$.$lessinit$greater$default$6();
        }

        public static Option<String> $lessinit$greater$default$7() {
            return RabbitMQContainer$Exchange$.MODULE$.$lessinit$greater$default$7();
        }

        public Exchange(String name, String exchangeType, boolean autoDelete, boolean internal, boolean durable, scala.collection.immutable.Map<String, String> arguments, Option<String> vhost) {
            this.name = name;
            this.exchangeType = exchangeType;
            this.autoDelete = autoDelete;
            this.internal = internal;
            this.durable = durable;
            this.arguments = arguments;
            this.vhost = vhost;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.exchangeType()));
            n = Statics.mix((int)n, (int)(this.autoDelete() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.internal() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.durable() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.arguments()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.vhost()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Exchange)) return false;
            Exchange exchange = (Exchange)object;
            if (this.autoDelete() != exchange.autoDelete()) return false;
            if (this.internal() != exchange.internal()) return false;
            if (this.durable() != exchange.durable()) return false;
            String string = this.name();
            String string2 = exchange.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.exchangeType();
            String string4 = exchange.exchangeType();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            scala.collection.immutable.Map<String, String> map = this.arguments();
            scala.collection.immutable.Map<String, String> map2 = exchange.arguments();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<String> option = this.vhost();
            Option<String> option2 = exchange.vhost();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!exchange.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Exchange;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Exchange";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._4());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._5());
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "exchangeType";
                    break;
                }
                case 2: {
                    string = "autoDelete";
                    break;
                }
                case 3: {
                    string = "internal";
                    break;
                }
                case 4: {
                    string = "durable";
                    break;
                }
                case 5: {
                    string = "arguments";
                    break;
                }
                case 6: {
                    string = "vhost";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public String exchangeType() {
            return this.exchangeType;
        }

        public boolean autoDelete() {
            return this.autoDelete;
        }

        public boolean internal() {
            return this.internal;
        }

        public boolean durable() {
            return this.durable;
        }

        public scala.collection.immutable.Map<String, String> arguments() {
            return this.arguments;
        }

        public Option<String> vhost() {
            return this.vhost;
        }

        public Exchange copy(String name, String exchangeType, boolean autoDelete, boolean internal, boolean durable, scala.collection.immutable.Map<String, String> arguments, Option<String> vhost) {
            return new Exchange(name, exchangeType, autoDelete, internal, durable, arguments, vhost);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.exchangeType();
        }

        public boolean copy$default$3() {
            return this.autoDelete();
        }

        public boolean copy$default$4() {
            return this.internal();
        }

        public boolean copy$default$5() {
            return this.durable();
        }

        public scala.collection.immutable.Map<String, String> copy$default$6() {
            return this.arguments();
        }

        public Option<String> copy$default$7() {
            return this.vhost();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.exchangeType();
        }

        public boolean _3() {
            return this.autoDelete();
        }

        public boolean _4() {
            return this.internal();
        }

        public boolean _5() {
            return this.durable();
        }

        public scala.collection.immutable.Map<String, String> _6() {
            return this.arguments();
        }

        public Option<String> _7() {
            return this.vhost();
        }
    }

    public static class OperatorPolicy
    implements Product,
    Serializable {
        private final String name;
        private final String pattern;
        private final scala.collection.immutable.Map definition;
        private final int priority;
        private final String applyTo;

        public static OperatorPolicy apply(String string, String string2, scala.collection.immutable.Map<String, String> map, int n, String string3) {
            return RabbitMQContainer$OperatorPolicy$.MODULE$.apply(string, string2, map, n, string3);
        }

        public static OperatorPolicy fromProduct(Product product) {
            return RabbitMQContainer$OperatorPolicy$.MODULE$.fromProduct(product);
        }

        public static OperatorPolicy unapply(OperatorPolicy operatorPolicy) {
            return RabbitMQContainer$OperatorPolicy$.MODULE$.unapply(operatorPolicy);
        }

        public static int $lessinit$greater$default$4() {
            return RabbitMQContainer$OperatorPolicy$.MODULE$.$lessinit$greater$default$4();
        }

        public static String $lessinit$greater$default$5() {
            return RabbitMQContainer$OperatorPolicy$.MODULE$.$lessinit$greater$default$5();
        }

        public OperatorPolicy(String name, String pattern, scala.collection.immutable.Map<String, String> definition, int priority, String applyTo) {
            this.name = name;
            this.pattern = pattern;
            this.definition = definition;
            this.priority = priority;
            this.applyTo = applyTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pattern()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.definition()));
            n = Statics.mix((int)n, (int)this.priority());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.applyTo()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OperatorPolicy)) return false;
            OperatorPolicy operatorPolicy = (OperatorPolicy)object;
            if (this.priority() != operatorPolicy.priority()) return false;
            String string = this.name();
            String string2 = operatorPolicy.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pattern();
            String string4 = operatorPolicy.pattern();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            scala.collection.immutable.Map<String, String> map = this.definition();
            scala.collection.immutable.Map<String, String> map2 = operatorPolicy.definition();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            String string5 = this.applyTo();
            String string6 = operatorPolicy.applyTo();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!operatorPolicy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OperatorPolicy;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "OperatorPolicy";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "pattern";
                    break;
                }
                case 2: {
                    string = "definition";
                    break;
                }
                case 3: {
                    string = "priority";
                    break;
                }
                case 4: {
                    string = "applyTo";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public String pattern() {
            return this.pattern;
        }

        public scala.collection.immutable.Map<String, String> definition() {
            return this.definition;
        }

        public int priority() {
            return this.priority;
        }

        public String applyTo() {
            return this.applyTo;
        }

        public OperatorPolicy copy(String name, String pattern, scala.collection.immutable.Map<String, String> definition, int priority, String applyTo) {
            return new OperatorPolicy(name, pattern, definition, priority, applyTo);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.pattern();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.definition();
        }

        public int copy$default$4() {
            return this.priority();
        }

        public String copy$default$5() {
            return this.applyTo();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.pattern();
        }

        public scala.collection.immutable.Map<String, String> _3() {
            return this.definition();
        }

        public int _4() {
            return this.priority();
        }

        public String _5() {
            return this.applyTo();
        }
    }

    public static class Parameter
    implements Product,
    Serializable {
        private final String component;
        private final String name;
        private final String value;

        public static Parameter apply(String string, String string2, String string3) {
            return RabbitMQContainer$Parameter$.MODULE$.apply(string, string2, string3);
        }

        public static Parameter fromProduct(Product product) {
            return RabbitMQContainer$Parameter$.MODULE$.fromProduct(product);
        }

        public static Parameter unapply(Parameter parameter) {
            return RabbitMQContainer$Parameter$.MODULE$.unapply(parameter);
        }

        public Parameter(String component, String name, String value) {
            this.component = component;
            this.name = name;
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Parameter)) return false;
            Parameter parameter = (Parameter)object;
            String string = this.component();
            String string2 = parameter.component();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = parameter.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.value();
            String string6 = parameter.value();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!parameter.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Parameter;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Parameter";
        }

        public Object productElement(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = this._1();
                    break;
                }
                case 1: {
                    string = this._2();
                    break;
                }
                case 2: {
                    string = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "component";
                    break;
                }
                case 1: {
                    string = "name";
                    break;
                }
                case 2: {
                    string = "value";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String component() {
            return this.component;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Parameter copy(String component, String name, String value) {
            return new Parameter(component, name, value);
        }

        public String copy$default$1() {
            return this.component();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.value();
        }

        public String _1() {
            return this.component();
        }

        public String _2() {
            return this.name();
        }

        public String _3() {
            return this.value();
        }
    }

    public static class Permission
    implements Product,
    Serializable {
        private final String vhost;
        private final String user;
        private final String configure;
        private final String write;
        private final String read;

        public static Permission apply(String string, String string2, String string3, String string4, String string5) {
            return RabbitMQContainer$Permission$.MODULE$.apply(string, string2, string3, string4, string5);
        }

        public static Permission fromProduct(Product product) {
            return RabbitMQContainer$Permission$.MODULE$.fromProduct(product);
        }

        public static Permission unapply(Permission permission) {
            return RabbitMQContainer$Permission$.MODULE$.unapply(permission);
        }

        public Permission(String vhost, String user, String configure, String write, String read) {
            this.vhost = vhost;
            this.user = user;
            this.configure = configure;
            this.write = write;
            this.read = read;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Permission)) return false;
            Permission permission = (Permission)object;
            String string = this.vhost();
            String string2 = permission.vhost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.user();
            String string4 = permission.user();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.configure();
            String string6 = permission.configure();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.write();
            String string8 = permission.write();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.read();
            String string10 = permission.read();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            if (!permission.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Permission;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Permission";
        }

        public Object productElement(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = this._1();
                    break;
                }
                case 1: {
                    string = this._2();
                    break;
                }
                case 2: {
                    string = this._3();
                    break;
                }
                case 3: {
                    string = this._4();
                    break;
                }
                case 4: {
                    string = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "vhost";
                    break;
                }
                case 1: {
                    string = "user";
                    break;
                }
                case 2: {
                    string = "configure";
                    break;
                }
                case 3: {
                    string = "write";
                    break;
                }
                case 4: {
                    string = "read";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String vhost() {
            return this.vhost;
        }

        public String user() {
            return this.user;
        }

        public String configure() {
            return this.configure;
        }

        public String write() {
            return this.write;
        }

        public String read() {
            return this.read;
        }

        public Permission copy(String vhost, String user, String configure, String write, String read) {
            return new Permission(vhost, user, configure, write, read);
        }

        public String copy$default$1() {
            return this.vhost();
        }

        public String copy$default$2() {
            return this.user();
        }

        public String copy$default$3() {
            return this.configure();
        }

        public String copy$default$4() {
            return this.write();
        }

        public String copy$default$5() {
            return this.read();
        }

        public String _1() {
            return this.vhost();
        }

        public String _2() {
            return this.user();
        }

        public String _3() {
            return this.configure();
        }

        public String _4() {
            return this.write();
        }

        public String _5() {
            return this.read();
        }
    }

    public static class Policy
    implements Product,
    Serializable {
        private final String name;
        private final String pattern;
        private final scala.collection.immutable.Map definition;
        private final int priority;
        private final String applyTo;

        public static Policy apply(String string, String string2, scala.collection.immutable.Map<String, String> map, int n, String string3) {
            return RabbitMQContainer$Policy$.MODULE$.apply(string, string2, map, n, string3);
        }

        public static Policy fromProduct(Product product) {
            return RabbitMQContainer$Policy$.MODULE$.fromProduct(product);
        }

        public static Policy unapply(Policy policy) {
            return RabbitMQContainer$Policy$.MODULE$.unapply(policy);
        }

        public static int $lessinit$greater$default$4() {
            return RabbitMQContainer$Policy$.MODULE$.$lessinit$greater$default$4();
        }

        public static String $lessinit$greater$default$5() {
            return RabbitMQContainer$Policy$.MODULE$.$lessinit$greater$default$5();
        }

        public Policy(String name, String pattern, scala.collection.immutable.Map<String, String> definition, int priority, String applyTo) {
            this.name = name;
            this.pattern = pattern;
            this.definition = definition;
            this.priority = priority;
            this.applyTo = applyTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pattern()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.definition()));
            n = Statics.mix((int)n, (int)this.priority());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.applyTo()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Policy)) return false;
            Policy policy = (Policy)object;
            if (this.priority() != policy.priority()) return false;
            String string = this.name();
            String string2 = policy.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pattern();
            String string4 = policy.pattern();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            scala.collection.immutable.Map<String, String> map = this.definition();
            scala.collection.immutable.Map<String, String> map2 = policy.definition();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            String string5 = this.applyTo();
            String string6 = policy.applyTo();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!policy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Policy;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Policy";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "pattern";
                    break;
                }
                case 2: {
                    string = "definition";
                    break;
                }
                case 3: {
                    string = "priority";
                    break;
                }
                case 4: {
                    string = "applyTo";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public String pattern() {
            return this.pattern;
        }

        public scala.collection.immutable.Map<String, String> definition() {
            return this.definition;
        }

        public int priority() {
            return this.priority;
        }

        public String applyTo() {
            return this.applyTo;
        }

        public Policy copy(String name, String pattern, scala.collection.immutable.Map<String, String> definition, int priority, String applyTo) {
            return new Policy(name, pattern, definition, priority, applyTo);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.pattern();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.definition();
        }

        public int copy$default$4() {
            return this.priority();
        }

        public String copy$default$5() {
            return this.applyTo();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.pattern();
        }

        public scala.collection.immutable.Map<String, String> _3() {
            return this.definition();
        }

        public int _4() {
            return this.priority();
        }

        public String _5() {
            return this.applyTo();
        }
    }

    public static class Queue
    implements Product,
    Serializable {
        private final String name;
        private final boolean autoDelete;
        private final boolean durable;
        private final scala.collection.immutable.Map arguments;

        public static Queue apply(String string, boolean bl, boolean bl2, scala.collection.immutable.Map<String, String> map) {
            return RabbitMQContainer$Queue$.MODULE$.apply(string, bl, bl2, map);
        }

        public static Queue fromProduct(Product product) {
            return RabbitMQContainer$Queue$.MODULE$.fromProduct(product);
        }

        public static Queue unapply(Queue queue) {
            return RabbitMQContainer$Queue$.MODULE$.unapply(queue);
        }

        public static boolean $lessinit$greater$default$2() {
            return RabbitMQContainer$Queue$.MODULE$.$lessinit$greater$default$2();
        }

        public static boolean $lessinit$greater$default$3() {
            return RabbitMQContainer$Queue$.MODULE$.$lessinit$greater$default$3();
        }

        public static scala.collection.immutable.Map<String, String> $lessinit$greater$default$4() {
            return RabbitMQContainer$Queue$.MODULE$.$lessinit$greater$default$4();
        }

        public Queue(String name, boolean autoDelete, boolean durable, scala.collection.immutable.Map<String, String> arguments) {
            this.name = name;
            this.autoDelete = autoDelete;
            this.durable = durable;
            this.arguments = arguments;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)(this.autoDelete() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.durable() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.arguments()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Queue)) return false;
            Queue queue = (Queue)object;
            if (this.autoDelete() != queue.autoDelete()) return false;
            if (this.durable() != queue.durable()) return false;
            String string = this.name();
            String string2 = queue.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            scala.collection.immutable.Map<String, String> map = this.arguments();
            scala.collection.immutable.Map<String, String> map2 = queue.arguments();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!queue.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Queue;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Queue";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "autoDelete";
                    break;
                }
                case 2: {
                    string = "durable";
                    break;
                }
                case 3: {
                    string = "arguments";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public boolean autoDelete() {
            return this.autoDelete;
        }

        public boolean durable() {
            return this.durable;
        }

        public scala.collection.immutable.Map<String, String> arguments() {
            return this.arguments;
        }

        public Queue copy(String name, boolean autoDelete, boolean durable, scala.collection.immutable.Map<String, String> arguments) {
            return new Queue(name, autoDelete, durable, arguments);
        }

        public String copy$default$1() {
            return this.name();
        }

        public boolean copy$default$2() {
            return this.autoDelete();
        }

        public boolean copy$default$3() {
            return this.durable();
        }

        public scala.collection.immutable.Map<String, String> copy$default$4() {
            return this.arguments();
        }

        public String _1() {
            return this.name();
        }

        public boolean _2() {
            return this.autoDelete();
        }

        public boolean _3() {
            return this.durable();
        }

        public scala.collection.immutable.Map<String, String> _4() {
            return this.arguments();
        }
    }

    public static class SslConfig
    implements Product,
    Serializable {
        private final MountableFile keyFile;
        private final MountableFile certFile;
        private final MountableFile caFile;
        private final RabbitMQContainer.SslVerification verify;
        private final Option failIfNoCert;
        private final Option verificationDepth;

        public static SslConfig apply(MountableFile mountableFile, MountableFile mountableFile2, MountableFile mountableFile3, RabbitMQContainer.SslVerification sslVerification, Option<Object> option, Option<Object> option2) {
            return RabbitMQContainer$SslConfig$.MODULE$.apply(mountableFile, mountableFile2, mountableFile3, sslVerification, option, option2);
        }

        public static SslConfig fromProduct(Product product) {
            return RabbitMQContainer$SslConfig$.MODULE$.fromProduct(product);
        }

        public static SslConfig unapply(SslConfig sslConfig) {
            return RabbitMQContainer$SslConfig$.MODULE$.unapply(sslConfig);
        }

        public static Option<Object> $lessinit$greater$default$5() {
            return RabbitMQContainer$SslConfig$.MODULE$.$lessinit$greater$default$5();
        }

        public static Option<Object> $lessinit$greater$default$6() {
            return RabbitMQContainer$SslConfig$.MODULE$.$lessinit$greater$default$6();
        }

        public SslConfig(MountableFile keyFile, MountableFile certFile, MountableFile caFile, RabbitMQContainer.SslVerification verify, Option<Object> failIfNoCert, Option<Object> verificationDepth) {
            this.keyFile = keyFile;
            this.certFile = certFile;
            this.caFile = caFile;
            this.verify = verify;
            this.failIfNoCert = failIfNoCert;
            this.verificationDepth = verificationDepth;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SslConfig)) return false;
            SslConfig sslConfig = (SslConfig)object;
            MountableFile mountableFile = this.keyFile();
            MountableFile mountableFile2 = sslConfig.keyFile();
            if (mountableFile == null) {
                if (mountableFile2 != null) {
                    return false;
                }
            } else if (!mountableFile.equals(mountableFile2)) return false;
            MountableFile mountableFile3 = this.certFile();
            MountableFile mountableFile4 = sslConfig.certFile();
            if (mountableFile3 == null) {
                if (mountableFile4 != null) {
                    return false;
                }
            } else if (!mountableFile3.equals(mountableFile4)) return false;
            MountableFile mountableFile5 = this.caFile();
            MountableFile mountableFile6 = sslConfig.caFile();
            if (mountableFile5 == null) {
                if (mountableFile6 != null) {
                    return false;
                }
            } else if (!mountableFile5.equals(mountableFile6)) return false;
            RabbitMQContainer.SslVerification sslVerification = this.verify();
            RabbitMQContainer.SslVerification sslVerification2 = sslConfig.verify();
            if (sslVerification == null) {
                if (sslVerification2 != null) {
                    return false;
                }
            } else if (!sslVerification.equals(sslVerification2)) return false;
            Option<Object> option = this.failIfNoCert();
            Option<Object> option2 = sslConfig.failIfNoCert();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.verificationDepth();
            Option<Object> option4 = sslConfig.verificationDepth();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!sslConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SslConfig;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "SslConfig";
        }

        public Object productElement(int n) {
            Option<Object> option;
            int n2 = n;
            switch (n2) {
                case 0: {
                    option = this._1();
                    break;
                }
                case 1: {
                    option = this._2();
                    break;
                }
                case 2: {
                    option = this._3();
                    break;
                }
                case 3: {
                    option = this._4();
                    break;
                }
                case 4: {
                    option = this._5();
                    break;
                }
                case 5: {
                    option = this._6();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "keyFile";
                    break;
                }
                case 1: {
                    string = "certFile";
                    break;
                }
                case 2: {
                    string = "caFile";
                    break;
                }
                case 3: {
                    string = "verify";
                    break;
                }
                case 4: {
                    string = "failIfNoCert";
                    break;
                }
                case 5: {
                    string = "verificationDepth";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public MountableFile keyFile() {
            return this.keyFile;
        }

        public MountableFile certFile() {
            return this.certFile;
        }

        public MountableFile caFile() {
            return this.caFile;
        }

        public RabbitMQContainer.SslVerification verify() {
            return this.verify;
        }

        public Option<Object> failIfNoCert() {
            return this.failIfNoCert;
        }

        public Option<Object> verificationDepth() {
            return this.verificationDepth;
        }

        public SslConfig copy(MountableFile keyFile, MountableFile certFile, MountableFile caFile, RabbitMQContainer.SslVerification verify, Option<Object> failIfNoCert, Option<Object> verificationDepth) {
            return new SslConfig(keyFile, certFile, caFile, verify, failIfNoCert, verificationDepth);
        }

        public MountableFile copy$default$1() {
            return this.keyFile();
        }

        public MountableFile copy$default$2() {
            return this.certFile();
        }

        public MountableFile copy$default$3() {
            return this.caFile();
        }

        public RabbitMQContainer.SslVerification copy$default$4() {
            return this.verify();
        }

        public Option<Object> copy$default$5() {
            return this.failIfNoCert();
        }

        public Option<Object> copy$default$6() {
            return this.verificationDepth();
        }

        public MountableFile _1() {
            return this.keyFile();
        }

        public MountableFile _2() {
            return this.certFile();
        }

        public MountableFile _3() {
            return this.caFile();
        }

        public RabbitMQContainer.SslVerification _4() {
            return this.verify();
        }

        public Option<Object> _5() {
            return this.failIfNoCert();
        }

        public Option<Object> _6() {
            return this.verificationDepth();
        }
    }

    public static class User
    implements Product,
    Serializable {
        private final String name;
        private final String password;
        private final scala.collection.immutable.Set tags;

        public static User apply(String string, String string2, scala.collection.immutable.Set<String> set) {
            return RabbitMQContainer$User$.MODULE$.apply(string, string2, set);
        }

        public static User fromProduct(Product product) {
            return RabbitMQContainer$User$.MODULE$.fromProduct(product);
        }

        public static User unapply(User user) {
            return RabbitMQContainer$User$.MODULE$.unapply(user);
        }

        public static scala.collection.immutable.Set<String> $lessinit$greater$default$3() {
            return RabbitMQContainer$User$.MODULE$.$lessinit$greater$default$3();
        }

        public User(String name, String password, scala.collection.immutable.Set<String> tags) {
            this.name = name;
            this.password = password;
            this.tags = tags;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof User)) return false;
            User user = (User)object;
            String string = this.name();
            String string2 = user.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.password();
            String string4 = user.password();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            scala.collection.immutable.Set<String> set = this.tags();
            scala.collection.immutable.Set<String> set2 = user.tags();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!user.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof User;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "User";
        }

        public Object productElement(int n) {
            scala.collection.immutable.Set<String> set;
            int n2 = n;
            switch (n2) {
                case 0: {
                    set = this._1();
                    break;
                }
                case 1: {
                    set = this._2();
                    break;
                }
                case 2: {
                    set = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return set;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "password";
                    break;
                }
                case 2: {
                    string = "tags";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public String password() {
            return this.password;
        }

        public scala.collection.immutable.Set<String> tags() {
            return this.tags;
        }

        public User copy(String name, String password, scala.collection.immutable.Set<String> tags) {
            return new User(name, password, tags);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.password();
        }

        public scala.collection.immutable.Set<String> copy$default$3() {
            return this.tags();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.password();
        }

        public scala.collection.immutable.Set<String> _3() {
            return this.tags();
        }
    }

    public static class VHost
    implements Product,
    Serializable {
        private final String name;
        private final Option tracing;

        public static VHost apply(String string, Option<Object> option) {
            return RabbitMQContainer$VHost$.MODULE$.apply(string, option);
        }

        public static VHost fromProduct(Product product) {
            return RabbitMQContainer$VHost$.MODULE$.fromProduct(product);
        }

        public static VHost unapply(VHost vHost) {
            return RabbitMQContainer$VHost$.MODULE$.unapply(vHost);
        }

        public static Option<Object> $lessinit$greater$default$2() {
            return RabbitMQContainer$VHost$.MODULE$.$lessinit$greater$default$2();
        }

        public VHost(String name, Option<Object> tracing) {
            this.name = name;
            this.tracing = tracing;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VHost)) return false;
            VHost vHost = (VHost)object;
            String string = this.name();
            String string2 = vHost.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Object> option = this.tracing();
            Option<Object> option2 = vHost.tracing();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!vHost.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VHost;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "VHost";
        }

        public Object productElement(int n) {
            Option<Object> option;
            int n2 = n;
            if (0 == n2) {
                option = this._1();
            } else if (1 == n2) {
                option = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "name";
            } else if (1 == n2) {
                string = "tracing";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public Option<Object> tracing() {
            return this.tracing;
        }

        public VHost copy(String name, Option<Object> tracing) {
            return new VHost(name, tracing);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Option<Object> copy$default$2() {
            return this.tracing();
        }

        public String _1() {
            return this.name();
        }

        public Option<Object> _2() {
            return this.tracing();
        }
    }

    public static class VHostLimit
    implements Product,
    Serializable {
        private final String vhost;
        private final String name;
        private final int value;

        public static VHostLimit apply(String string, String string2, int n) {
            return RabbitMQContainer$VHostLimit$.MODULE$.apply(string, string2, n);
        }

        public static VHostLimit fromProduct(Product product) {
            return RabbitMQContainer$VHostLimit$.MODULE$.fromProduct(product);
        }

        public static VHostLimit unapply(VHostLimit vHostLimit) {
            return RabbitMQContainer$VHostLimit$.MODULE$.unapply(vHostLimit);
        }

        public VHostLimit(String vhost, String name, int value) {
            this.vhost = vhost;
            this.name = name;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.vhost()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof VHostLimit)) return false;
            VHostLimit vHostLimit = (VHostLimit)object;
            if (this.value() != vHostLimit.value()) return false;
            String string = this.vhost();
            String string2 = vHostLimit.vhost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = vHostLimit.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!vHostLimit.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof VHostLimit;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "VHostLimit";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "vhost";
                    break;
                }
                case 1: {
                    string = "name";
                    break;
                }
                case 2: {
                    string = "value";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String vhost() {
            return this.vhost;
        }

        public String name() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        public VHostLimit copy(String vhost, String name, int value) {
            return new VHostLimit(vhost, name, value);
        }

        public String copy$default$1() {
            return this.vhost();
        }

        public String copy$default$2() {
            return this.name();
        }

        public int copy$default$3() {
            return this.value();
        }

        public String _1() {
            return this.vhost();
        }

        public String _2() {
            return this.name();
        }

        public int _3() {
            return this.value();
        }
    }
}

