/*
 * Decompiled with CFR 0.152.
 */
package dx.util.protocols;

import dx.util.AddressableFileSource;
import dx.util.FileSource;
import dx.util.protocols.S3FileAccessProtocol;
import dx.util.protocols.S3FileSource;
import dx.util.protocols.S3FolderSource$;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.S3Object;

@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001\u0002\u0014(\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t%\u0013\u0005\t%\u0002\u0011\t\u0012)A\u0005\u0015\"A1\u000b\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005U\u0001\tE\t\u0015!\u0003K\u0011!)\u0006A!f\u0001\n\u0003I\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u0011]\u0003!\u0011!Q\u0001\naCQ\u0001\u0018\u0001\u0005\u0002uC\u0001\u0002\u001a\u0001\t\u0006\u0004%I!\u001a\u0005\u0006a\u0002!\t%\u0013\u0005\u0006c\u0002!\t%\u0013\u0005\be\u0002\u0011\r\u0011\"\u0011t\u0011\u00199\b\u0001)A\u0005i\")\u0001\u0010\u0001C\u0005s\"1\u00111\u0004\u0001\u0005BMDq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005=\u0002\u0001\"\u0015\u00022!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"a\u0019\u0001#\u0003%\t!!\u0014\t\u0013\u0005\u0015\u0004!%A\u0005\u0002\u00055\u0003\"CA4\u0001\u0005\u0005I\u0011IA5\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003;\u0003\u0011\u0011!C\u0001\u0003?C\u0011\"a)\u0001\u0003\u0003%\t%!*\t\u0013\u0005%\u0006!!A\u0005B\u0005-\u0006\"CAW\u0001\u0005\u0005I\u0011IAX\u000f%\t\u0019lJA\u0001\u0012\u0003\t)L\u0002\u0005'O\u0005\u0005\t\u0012AA\\\u0011\u0019a\u0006\u0005\"\u0001\u0002D\"I\u0011Q\u0019\u0011\u0002\u0002\u0013\u0015\u0013q\u0019\u0005\n\u0003\u0013\u0004\u0013\u0011!CA\u0003\u0017D\u0011\"a6!\u0003\u0003%\t)!7\t\u0013\u0005\u001d\b%!A\u0005\n\u0005%(AD*4\r>dG-\u001a:T_V\u00148-\u001a\u0006\u0003Q%\n\u0011\u0002\u001d:pi>\u001cw\u000e\\:\u000b\u0005)Z\u0013\u0001B;uS2T\u0011\u0001L\u0001\u0003Ib\u001c\u0001aE\u0003\u0001_UJD\b\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003m]j\u0011!K\u0005\u0003q%\u0012Q#\u00113ee\u0016\u001c8/\u00192mK\u001aKG.Z*pkJ\u001cW\r\u0005\u00021u%\u00111(\r\u0002\b!J|G-^2u!\tiTI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)L\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!\u0001R\u0019\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\tF\nq!\u00193ee\u0016\u001c8/F\u0001K!\tYuJ\u0004\u0002M\u001bB\u0011q(M\u0005\u0003\u001dF\na\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011a*M\u0001\tC\u0012$'/Z:tA\u0005Q!-^2lKRt\u0015-\\3\u0002\u0017\t,8m[3u\u001d\u0006lW\rI\u0001\u0007aJ,g-\u001b=\u0002\u000fA\u0014XMZ5yA\u0005A\u0001O]8u_\u000e|G\u000e\u0005\u0002Z56\tq%\u0003\u0002\\O\t!2k\r$jY\u0016\f5mY3tgB\u0013x\u000e^8d_2\fa\u0001P5oSRtD\u0003\u00020bE\u000e$\"a\u00181\u0011\u0005e\u0003\u0001\"B,\t\u0001\u0004A\u0006\"\u0002%\t\u0001\u0004Q\u0005\"B*\t\u0001\u0004Q\u0005\"B+\t\u0001\u0004Q\u0015A\u00039sK\u001aL\u0007\u0010U1uQV\ta\r\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006!a-\u001b7f\u0015\tYG.A\u0002oS>T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pQ\n!\u0001+\u0019;i\u0003\u0011q\u0017-\\3\u0002\r\u0019|G\u000eZ3s\u0003-I7\u000fR5sK\u000e$xN]=\u0016\u0003Q\u0004\"\u0001M;\n\u0005Y\f$a\u0002\"p_2,\u0017M\\\u0001\rSN$\u0015N]3di>\u0014\u0018\u0010I\u0001\u000bY&\u001cH\u000f\u0015:fM&DX#\u0001>\u0011\u0007uZX0\u0003\u0002}\u000f\n1a+Z2u_J\u00042A`A\f\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tQ!\\8eK2TA!!\u0002\u0002\b\u0005\u00111o\r\u0006\u0005\u0003\u0013\tY!\u0001\u0005tKJ4\u0018nY3t\u0015\u0011\ti!a\u0004\u0002\r\u0005<8o\u001d3l\u0015\u0011\t\t\"a\u0005\u0002\r\u0005l\u0017M_8o\u0015\t\t)\"\u0001\u0005t_\u001a$x/\u0019:f\u0013\r\tIb \u0002\t'Nz%M[3di\u00061Q\r_5tiN\f\u0011bZ3u!\u0006\u0014XM\u001c;\u0016\u0005\u0005\u0005\u0002\u0003\u0002\u0019\u0002$}K1!!\n2\u0005\u0019y\u0005\u000f^5p]\u00069!/Z:pYZ,GcA\u001b\u0002,!1\u0011QF\tA\u0002)\u000bA\u0001]1uQ\u0006QAn\\2bY&TX\rV8\u0015\t\u0005M\u0012\u0011\b\t\u0004a\u0005U\u0012bAA\u001cc\t!QK\\5u\u0011\u0019\tYD\u0005a\u0001M\u0006\u0019A-\u001b:\u0002\t\r|\u0007/\u001f\u000b\t\u0003\u0003\n)%a\u0012\u0002JQ\u0019q,a\u0011\t\u000b]\u001b\u0002\u0019\u0001-\t\u000f!\u001b\u0002\u0013!a\u0001\u0015\"91k\u0005I\u0001\u0002\u0004Q\u0005bB+\u0014!\u0003\u0005\rAS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyEK\u0002K\u0003#Z#!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\n\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011MA,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA6!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9Y\u0006!A.\u00198h\u0013\r\u0001\u0016qN\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003s\u00022\u0001MA>\u0013\r\ti(\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0007\u000bI\tE\u00021\u0003\u000bK1!a\"2\u0005\r\te.\u001f\u0005\n\u0003\u0017K\u0012\u0011!a\u0001\u0003s\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAI!\u0019\t\u0019*!'\u0002\u00046\u0011\u0011Q\u0013\u0006\u0004\u0003/\u000b\u0014AC2pY2,7\r^5p]&!\u00111TAK\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Q\f\t\u000bC\u0005\u0002\fn\t\t\u00111\u0001\u0002\u0004\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY'a*\t\u0013\u0005-E$!AA\u0002\u0005e\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0014AB3rk\u0006d7\u000fF\u0002u\u0003cC\u0011\"a#\u001f\u0003\u0003\u0005\r!a!\u0002\u001dM\u001bdi\u001c7eKJ\u001cv.\u001e:dKB\u0011\u0011\fI\n\u0005A=\nI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\ty\f\\\u0001\u0003S>L1ARA_)\t\t),\u0001\u0005u_N#(/\u001b8h)\t\tY'A\u0003baBd\u0017\u0010\u0006\u0005\u0002N\u0006E\u00171[Ak)\ry\u0016q\u001a\u0005\u0006/\u000e\u0002\r\u0001\u0017\u0005\u0006\u0011\u000e\u0002\rA\u0013\u0005\u0006'\u000e\u0002\rA\u0013\u0005\u0006+\u000e\u0002\rAS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY.a9\u0011\u000bA\n\u0019#!8\u0011\rA\nyN\u0013&K\u0013\r\t\t/\r\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005\u0015H%!AA\u0002}\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u000f\u0005\u0003\u0002n\u00055\u0018\u0002BAx\u0003_\u0012aa\u00142kK\u000e$\b")
public class S3FolderSource
implements AddressableFileSource,
Product,
Serializable {
    private Path prefixPath;
    private final String address;
    private final String bucketName;
    private final String prefix;
    private final S3FileAccessProtocol protocol;
    private final boolean isDirectory;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<String, String, String>> unapply(S3FolderSource s3FolderSource) {
        return S3FolderSource$.MODULE$.unapply(s3FolderSource);
    }

    public static S3FolderSource apply(String string, String string2, String string3, S3FileAccessProtocol s3FileAccessProtocol) {
        return S3FolderSource$.MODULE$.apply(string, string2, string3, s3FileAccessProtocol);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public URI uri() {
        return AddressableFileSource.uri$((AddressableFileSource)this);
    }

    public String toString() {
        return AddressableFileSource.toString$((AddressableFileSource)this);
    }

    public Path localize(Path path, boolean overwrite) {
        return FileSource.localize$((FileSource)this, (Path)path, (boolean)overwrite);
    }

    public boolean localize$default$2() {
        return FileSource.localize$default$2$((FileSource)this);
    }

    public Path localizeToDir(Path dir, boolean overwrite) {
        return FileSource.localizeToDir$((FileSource)this, (Path)dir, (boolean)overwrite);
    }

    public boolean localizeToDir$default$2() {
        return FileSource.localizeToDir$default$2$((FileSource)this);
    }

    public String address() {
        return this.address;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String prefix() {
        return this.prefix;
    }

    private Path prefixPath$lzycompute() {
        S3FolderSource s3FolderSource = this;
        synchronized (s3FolderSource) {
            if (!this.bitmap$0) {
                this.prefixPath = Paths.get(this.prefix(), new String[0]);
                this.bitmap$0 = true;
            }
        }
        return this.prefixPath;
    }

    private Path prefixPath() {
        return !this.bitmap$0 ? this.prefixPath$lzycompute() : this.prefixPath;
    }

    public String name() {
        return ((Object)this.prefixPath().getFileName()).toString();
    }

    public String folder() {
        Path path = this.prefixPath().getParent();
        String string = path == null ? "" : ((Object)path).toString();
        return string;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private Vector<S3Object> listPrefix() {
        ListObjectsV2Request listRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName()).prefix(this.prefix()).delimiter("/").build();
        ListObjectsV2Response response = this.protocol.getClient().listObjectsV2(listRequest);
        return CollectionConverters$.MODULE$.ListHasAsScala(response.contents()).asScala().toVector();
    }

    public boolean exists() {
        boolean bl;
        try {
            bl = this.listPrefix().nonEmpty();
        }
        catch (NoSuchBucketException noSuchBucketException) {
            bl = false;
        }
        return bl;
    }

    public Option<S3FolderSource> getParent() {
        None$ none$;
        String string = this.folder();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            none$ = None$.MODULE$;
        } else {
            String newUri = new StringBuilder(6).append("s3://").append(this.bucketName()).append("/").append(this.folder()).toString();
            none$ = new Some((Object)new S3FolderSource(newUri, this.bucketName(), this.folder(), this.protocol));
        }
        return none$;
    }

    public AddressableFileSource resolve(String path) {
        String objectKey = new StringBuilder(0).append(this.folder()).append(path).toString();
        String newUri = new StringBuilder(6).append("s3://").append(this.bucketName()).append("/").append(objectKey).toString();
        return path.endsWith("/") ? new S3FolderSource(newUri, this.bucketName(), objectKey, this.protocol) : new S3FileSource(newUri, this.bucketName(), objectKey, this.protocol);
    }

    public void localizeTo(Path dir) {
        Path sourcePath = Paths.get(this.prefix(), new String[0]);
        this.listPrefix().foreach((Function1 & Serializable)s3obj -> {
            String objectKey = s3obj.key();
            Path relativePath = sourcePath.relativize(Paths.get(objectKey, new String[0]));
            Path destPath = dir.resolve(relativePath);
            GetObjectRequest downloadRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName()).key(objectKey).build();
            return (GetObjectResponse)$this.protocol.getClient().getObject(downloadRequest, ResponseTransformer.toFile((Path)destPath));
        });
    }

    public S3FolderSource copy(String address, String bucketName, String prefix, S3FileAccessProtocol protocol) {
        return new S3FolderSource(address, bucketName, prefix, protocol);
    }

    public String copy$default$1() {
        return this.address();
    }

    public String copy$default$2() {
        return this.bucketName();
    }

    public String copy$default$3() {
        return this.prefix();
    }

    public String productPrefix() {
        return "S3FolderSource";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.address();
                break;
            }
            case 1: {
                object = this.bucketName();
                break;
            }
            case 2: {
                object = this.prefix();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof S3FolderSource;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "address";
                break;
            }
            case 1: {
                string = "bucketName";
                break;
            }
            case 2: {
                string = "prefix";
                break;
            }
            case 3: {
                string = "protocol";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof S3FolderSource)) return false;
        boolean bl = true;
        if (!bl) return false;
        S3FolderSource s3FolderSource = (S3FolderSource)x$1;
        String string = this.address();
        String string2 = s3FolderSource.address();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.bucketName();
        String string4 = s3FolderSource.bucketName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.prefix();
        String string6 = s3FolderSource.prefix();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        if (!s3FolderSource.canEqual(this)) return false;
        return true;
    }

    public S3FolderSource(String address, String bucketName, String prefix, S3FileAccessProtocol protocol) {
        this.address = address;
        this.bucketName = bucketName;
        this.prefix = prefix;
        this.protocol = protocol;
        FileSource.$init$((FileSource)this);
        AddressableFileSource.$init$((AddressableFileSource)this);
        Product.$init$((Product)this);
        this.isDirectory = true;
    }
}

