package com.dooapp.gaedo.finders;

import java.lang.reflect.Field;

import com.dooapp.gaedo.AbstractCrudService;

/**
 * Crud service making use of the finder design pattern
 * 
 * @author ndx
 * 
 * @param <DataType>
 */
public interface FinderCrudService<DataType, InformerType extends Informer<DataType>>
		extends AbstractCrudService<DataType> {
	/**
	 * Creates a finder for the given datatype. This finder is the delegate that
	 * will perform the various queries kind
	 * 
	 * @return
	 */
	public Finder<DataType, InformerType> find();

	/**
	 * Get contained objects base class
	 * 
	 * @return the class declared as DataTyope in this type generics arguments
	 */
	public Class<DataType> getContainedClass();

	/**
	 * Get the informer associated to this data type
	 * 
	 * @return an object implementing the interface defined by InformerType.
	 */
	public InformerType getInformer();

	/**
	 * Shortcut method allowing to return all instances of DataType.
	 * Implementors are left free to implement or not this method. But, were it
	 * not to be implemented, I (riduidel) suggest one throws an
	 * {@link UnsupportedOperationException}
	 * 
	 * @return an iterable allowing one to brows the whole stored objects. This
	 *         {@link Iterable} is NOT meant to be modifiable. As a consequence,
	 *         Iterator generated by this {@link Iterable} is left free to not
	 *         support the remove operation.
	 */
	public Iterable<DataType> findAll();
}
