package com.doopp.common;


public class CodeException extends RuntimeException {

    private final String code;

    public CodeException(String errorMessage) {
        super(errorMessage);
        this.code = "50000";
    }

    public CodeException(Exception e) {
        super(e.getMessage());
        this.code = "50000";
    }

    public CodeException(CodeMessage codeMessage) {
        super(codeMessage.getMessage());
        this.code = codeMessage.getCode();
    }

    public CodeException(String errorCode, String errorMessage) {
        super(errorMessage);
        this.code = errorCode;
    }

    public String getCode() {
        return this.code;
    }
}
