package com.doopp.common;

import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.io.Serializable;
import java.util.function.Supplier;

public class Result<T> implements Serializable {

    private static final Logger logger = LoggerFactory.getLogger(Result.class);

    private String code;

    private String msg;

    private T data;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Result(T data) {
        this.data = data;
    }

    public static <D> Result<D> ok(D data) {
        return new Result<>(data);
    }

    public static <D> Result<D> tryOk(Supplier<D> supplier) {
        try {
            return new Result<>(supplier.get());
        }
        catch (CodeException e) {
            logger.info("Result catch CodeException", e);
            return err(e.getCode(), e.getMessage());
        }
        catch (Throwable e) {
            logger.info("Result catch Exception", e);
            return err("50000", e.getMessage());
        }
    }

    public static <D> Result<D> tryAgainOk(Supplier<D> supplier) {
        try {
            return new Result<>(supplier.get());
        }
        catch (CodeException e) {
            logger.info("Result catch CodeException", e);
            return err(e.getCode(), e.getMessage());
        }
        catch (Throwable e) {
            logger.info("Result catch Exception", e);
            return err("50000", "Error, please try again later");
        }
    }

    public static <D> Result<D> err(String code, String message) {
        Result<D> mr = new Result<>(null);
        mr.setCode(code);
        mr.setMsg(message);
        mr.setData(null);
        return mr;
    }

    public static <D> Result<D> err(CodeException e) {
        Result<D> mr = new Result<>(null);
        mr.setCode(e.getCode());
        mr.setMsg(e.getMessage());
        mr.setData(null);
        return mr;
    }

    public static <D> Result<D> err(CodeMessage codeMessage) {
        Result<D> mr = new Result<>(null);
        mr.setCode(codeMessage.getCode());
        mr.setMsg(codeMessage.getMessage());
        mr.setData(null);
        return mr;
    }
}
