package com.doopp.common.mybatis;

import com.doopp.common.util.AESUtil;
import com.doopp.common.util.ApplicationContextUtil;
import com.doopp.common.util.CommonUtil;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@MappedJdbcTypes(JdbcType.VARCHAR)
@MappedTypes({String.class})
public class EncryptTypeHandler extends BaseTypeHandler<String> {

    private static final AESUtil fieldEncrypt = ApplicationContextUtil.getBean("fieldEncrypt", AESUtil.class);

    private static final Logger logger = LoggerFactory.getLogger(EncryptTypeHandler.class);

    @Override
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, String parameter, JdbcType jdbcType) {
        try {
            if (CommonUtil.isEmpty(fieldEncrypt) || CommonUtil.isEmpty(parameter)) {
                preparedStatement.setString(i, null);
            }
            String encrypt = fieldEncrypt.cbcEncrypt(parameter);
            preparedStatement.setString(i, encrypt);
        }
        catch (Exception e) {
            logger.error("FieldEncryptTypeHandler encrypt failed ：" + e);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return getNullableResult(rs.getString(columnName));
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return getNullableResult(rs.getString(columnIndex));
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return getNullableResult(cs.getString(columnIndex));
    }

    private String getNullableResult(String col) {
        if (CommonUtil.isEmpty(fieldEncrypt) || CommonUtil.isEmpty(col)) {
            return "";
        }
        try {
            return fieldEncrypt.cbcDecrypt(col);
        }
        catch (Exception e) {
            logger.error("FieldEncryptTypeHandler decrypt failed ：" + e);
        }
        return "";
    }
}
