package com.doopp.common.mybatis;

import com.doopp.common.util.ApplicationContextUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@MappedJdbcTypes(JdbcType.VARCHAR)
@MappedTypes({String.class})
public class JsonTypeHandler<T> extends BaseTypeHandler<T> {

    private final Class<T> type;

    public JsonTypeHandler(Class<T> type) {
        this.type = type;
    }

    private T valueOf(String json) {
        // if null
        if(json==null || json.length()<2) {
            return null;
        }
        // json to object
        try {
            return ApplicationContextUtil.getBean(ObjectMapper.class).readValue(json, this.type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String toJson(Object obj) {
        try {
            return ApplicationContextUtil.getBean(ObjectMapper.class).writeValueAsString(obj);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return (T) valueOf(rs.getString(columnName));
    }

    @Override
    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return (T) valueOf(rs.getString(columnIndex));
    }

    @Override
    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (T) valueOf(cs.getString(columnIndex));
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int columnIndex, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(columnIndex, toJson(parameter));
    }
}
