package com.doopp.common.util;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;

public class AESUtil {

    private static final String CBC_ALGORITHM = "AES/CBC/PKCS5Padding";

    private static final String ECB_ALGORITHM = "AES/ECB/PKCS5Padding";

    private static final String ALGORITHM = "AES";

    private final String Key;

    private final String Offset;

    public AESUtil(String key) {
        this.Key = key;
        this.Offset = null;
    }

    public AESUtil(String key, String offset) {
        this.Key = key;
        this.Offset = offset;
    }

    public String cbcEncrypt(String content) {
        return cbcEncrypt(content, this.Key, this.Offset);
    }

    public String cbcDecrypt(String encryptContent) {
        return cbcDecrypt(encryptContent, this.Key, this.Offset);
    }

    public String ecbEncrypt(String content) {
        return ecbEncrypt(content, this.Key);
    }

    public String ecbDecrypt(String encryptContent) {
        return ecbDecrypt(encryptContent, this.Key);
    }

    public static String cbcEncrypt(String content, String key, String offset) {
        try {
            Cipher cipher = Cipher.getInstance(CBC_ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(offset.getBytes(StandardCharsets.UTF_8));
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec, ivParameterSpec);
            return Base64.encodeBase64String(
                    cipher.doFinal(content.getBytes(StandardCharsets.UTF_8))
            );
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String cbcDecrypt(String encryptContent, String key, String offset) {
        try {
            Cipher cipher = Cipher.getInstance(CBC_ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(offset.getBytes(StandardCharsets.UTF_8));
            cipher.init(Cipher.DECRYPT_MODE, secretKeySpec, ivParameterSpec);
            byte[] decryptBytes = cipher.doFinal(Base64.decodeBase64(encryptContent));
            return new String(decryptBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String ecbEncrypt(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance(ECB_ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);
            return Base64.encodeBase64String(
                    cipher.doFinal(content.getBytes(StandardCharsets.UTF_8))
            );
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String ecbDecrypt(String encryptContent, String key) {
        try {
            Cipher cipher = Cipher.getInstance(ECB_ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
            byte[] decryptBytes = cipher.doFinal(Base64.decodeBase64(encryptContent));
            return new String(decryptBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
