package com.doopp.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class CommonUtil {

    private final static Logger logger = LoggerFactory.getLogger(CommonUtil.class);

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        } else if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        } else if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        } else if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        } else if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        } else {
            return obj instanceof Map ? ((Map)obj).isEmpty() : false;
        }
    }

    public static void print(Exception e) {
        StringBuilder exceptionTrace = new StringBuilder();
        exceptionTrace.append("\n    ").append(e.getClass());
        for (StackTraceElement traceElement : e.getStackTrace()) {
            exceptionTrace.append("\n    ").append(traceElement.toString());
        }
        logger.info("Exception.getStackTrace start\n >>> {}\n >>> {}", (Object) e, exceptionTrace);
    }
}
