package com.doopp.common.util;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {

    public static String getCookie(String cookieName) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (CommonUtil.isEmpty(requestAttributes)) {
            return null;
        }
        HttpServletRequest servletRequest = ((ServletRequestAttributes) requestAttributes).getRequest();
        if (!CommonUtil.isEmpty(servletRequest.getCookies())) {
            for (Cookie cookie : servletRequest.getCookies()) {
                if (cookieName.equals(cookie.getName())) {
                    return cookie.getValue();
                }
            }
        }
        return null;
    }

    public static void setCookie(String cookieName, String cookieValue) {
        setCookie(cookieName, cookieValue, "/", 0);
    }

    public static void setCookie(String cookieName, String cookieValue, String path, Integer maxAge) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (CommonUtil.isEmpty(requestAttributes)) {
            return;
        }
        HttpServletResponse servletResponse = ((ServletRequestAttributes) requestAttributes).getResponse();
        if (CommonUtil.isEmpty(servletResponse)) {
            return;
        }
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(true);
        servletResponse.addCookie(cookie);
    }

    public static void delCookie(String cookieName) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (CommonUtil.isEmpty(requestAttributes)) {
            return;
        }
        HttpServletResponse servletResponse = ((ServletRequestAttributes) requestAttributes).getResponse();
        if (CommonUtil.isEmpty(servletResponse)) {
            return;
        }
        Cookie cookie = new Cookie(cookieName, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        cookie.setHttpOnly(true);
        cookie.setComment("delete");
        servletResponse.addCookie(cookie);
    }
}
