package com.doopp.common.util;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DatetimeUtil {

    private DatetimeUtil() {
    }

    public static LocalDateTime zoneToUtcDatetime(LocalDateTime fromZoneDateTime, String fromZoneId) {
        return DatetimeUtil.zoneToZoneDatetime(
                fromZoneDateTime, fromZoneId, "+0"
        );
    }

    public static LocalDateTime utcToZoneDatetime(LocalDateTime fromLocalDateTime, String toZoneId) {
        return DatetimeUtil.zoneToZoneDatetime(
                fromLocalDateTime, "+0", toZoneId
        );
    }

    public static LocalDateTime zoneToZoneDatetime(LocalDateTime fromLocalDateTime, String fromZoneId, String toZoneId) {
        return ZonedDateTime
                .of(fromLocalDateTime, ZoneId.of(fromZoneId))
                .withZoneSameInstant(ZoneId.of(toZoneId))
                .toLocalDateTime();
    }
}
