package com.doopp.common.util;

import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class EncryptProperties extends Properties {

    public EncryptProperties() {
        try {
            this.load(new FileReader(
                    System.getProperty("applicationProperties")
            ));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        parseEnc();
    }

    private void parseEnc() {
        for (String key : this.stringPropertyNames()) {
            String value = this.getProperty(key);
            if (value.startsWith("DEC(") && value.endsWith(")")) {
                String encValue = value.substring(4, value.length() - 1);
                this.setProperty(key, JniUtil.dpDec(encValue));
            }
        }
    }

    public Resource resource(String key) {
        return new FileSystemResource(this.getProperty(key));
    }

    public Long longValue(String key) {
        return Long.parseLong(this.getProperty(key));
    }

    public String strValue(String key) {
        return this.getProperty(key);
    }

    public int intValue(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public boolean boolValue(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }
}
