package com.doopp.common.util;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

public class RequestUtil {

    public static Map<String, String> buildQueryMap(HttpServletRequest request) {
        Map<String, String> queryCondition = new HashMap<>();
        for (String key : request.getParameterMap().keySet()) {
            if (key.equals("page") || key.equals("limit") || key.equals("pageSize")) {
                continue;
            }
            String[] value = request.getParameterMap().get(key);
            if (value.length>0 && !value[0].isEmpty()) {
                queryCondition.put(key, value[0]);
            }
        }
        return queryCondition;
    }

    public static String clientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}
