package com.doopp.common.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.doopp.common.Paging;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.*;

public class StructUtil {

    private StructUtil() {}

    public static <D extends Serializable> Paging<D> copy(IPage<?> iPage, Class<D> clazz) {
        List<D> listData = StructUtil.copyList(iPage.getRecords(), clazz);
        return new Paging<>(iPage.getTotal(), listData);
    }

    public static <T> T copy (Object from, Class<T> clazz) {
        if (CommonUtil.isEmpty(from)) {
            return null;
        }
        T t = StructUtil.instance(clazz);
        BeanUtils.copyProperties(from, t);
        return t;
    }

    public static <T> List<T> copyList (List<?> from, Class<T> clazz) {
        if (CommonUtil.isEmpty(from)) {
            return new ArrayList<>();
        }
        List<T> toList = new ArrayList<>();
        for (Object fromObject : from) {
            toList.add(StructUtil.copy(fromObject, clazz));
        }
        return toList;
    }

    public static Map<String, Object> objectToMap(Object... objs) {
        Map<String, Object> map = new HashMap<>();
        for (Object obj : objs) {
            if (CommonUtil.isEmpty(obj)) {
                continue;
            }
            for (Field field : obj.getClass().getDeclaredFields()) {
                ReflectionUtils.makeAccessible(field);
                try {
                    map.put(field.getName(), field.get(obj));
                }
                catch (Exception ignore) {
                }
            }
        }
        return map;
    }

    public static <T> T instance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor().newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot reflectively create %s objects", clazz.getName()));
        }
    }

    @SafeVarargs
    public static <T> List<T> listOf(T... values) {
        return new ArrayList<>(
                Arrays.asList(values)
        );
    }
}
