/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.inputConsole;

import dorkbox.inputConsole.Terminal;
import dorkbox.inputConsole.posix.UnixTerminal;
import dorkbox.inputConsole.unsupported.UnsupportedTerminal;
import dorkbox.inputConsole.windows.WindowsTerminal;
import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import dorkbox.util.OS;
import dorkbox.util.bytes.ByteBuffer2;
import dorkbox.util.bytes.ByteBuffer2Poolable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConsole {
    private static final Logger logger = LoggerFactory.getLogger(InputConsole.class);
    private static final InputConsole consoleProxyReader = new InputConsole();
    private static final char[] emptyLine = new char[0];
    private static InputStream wrappedInputStream;
    private final Object inputLock = new Object();
    private final Object inputLockSingle = new Object();
    private final Object inputLockLine = new Object();
    private final ObjectPool<ByteBuffer2> pool;
    private ThreadLocal<ByteBuffer2> readBuff = new ThreadLocal();
    private List<ByteBuffer2> readBuffers = new CopyOnWriteArrayList<ByteBuffer2>();
    private ThreadLocal<Integer> threadBufferCounter = new ThreadLocal();
    private ThreadLocal<ByteBuffer2> readLineBuff = new ThreadLocal();
    private List<ByteBuffer2> readLineBuffers = new CopyOnWriteArrayList<ByteBuffer2>();
    private final Terminal terminal;
    private final Boolean enableBackspace;

    public static void init() {
        if (logger.isDebugEnabled()) {
            logger.debug("Created Terminal: {} ({}w x {}h)", new Object[]{InputConsole.consoleProxyReader.terminal.getClass().getSimpleName(), InputConsole.consoleProxyReader.terminal.getWidth(), InputConsole.consoleProxyReader.terminal.getHeight()});
        }
    }

    public static String getVersion() {
        return "2.5";
    }

    public static String readLine() {
        char[] line = consoleProxyReader.readLine0();
        return new String(line);
    }

    public static int read() {
        return consoleProxyReader.read0();
    }

    public static char[] readLinePassword() {
        return consoleProxyReader.readLinePassword0();
    }

    public static InputStream getInputStream() {
        return wrappedInputStream;
    }

    public static void echo(boolean enableEcho) {
        consoleProxyReader.echo0(enableEcho);
    }

    public static boolean echo() {
        return consoleProxyReader.echo0();
    }

    private InputConsole() {
        Class t;
        Logger logger = InputConsole.logger;
        String readers = System.getProperty("input.terminal.readers");
        int readers2 = 32;
        if (readers != null) {
            try {
                readers2 = Integer.parseInt(readers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pool = ObjectPool.Blocking((PoolableObject)new ByteBuffer2Poolable(), (int)readers2);
        String type = System.getProperty("input.terminal", "auto").toLowerCase();
        if ("dumb".equals(System.getenv("TERM"))) {
            type = "none";
            if (logger.isTraceEnabled()) {
                logger.trace("System environment 'TERM'=dumb, creating type=" + type);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("Creating terminal, type=" + type);
        }
        try {
            if (type.equals("unix")) {
                t = UnixTerminal.class;
            } else if (type.equals("win") || type.equals("windows")) {
                t = WindowsTerminal.class;
            } else if (type.equals("none") || type.equals("off") || type.equals("false")) {
                t = UnsupportedTerminal.class;
            } else if (this.isIDEAutoDetect()) {
                logger.debug("Terminal is in UNSUPPORTED (best guess). Unable to support single key input. Only line input available.");
                t = UnsupportedTerminal.class;
            } else {
                t = OS.isWindows() ? WindowsTerminal.class : UnixTerminal.class;
            }
        }
        catch (Exception e) {
            logger.error("Failed to construct terminal, falling back to unsupported.", (Throwable)e);
            t = UnsupportedTerminal.class;
        }
        Terminal terminal = null;
        try {
            terminal = (Terminal)t.newInstance();
            terminal.init();
        }
        catch (Throwable e) {
            logger.error("Terminal initialization failed for {}, falling back to unsupported.", (Object)t.getSimpleName(), (Object)e);
            t = UnsupportedTerminal.class;
            try {
                terminal = (Terminal)t.newInstance();
                terminal.init();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (terminal != null) {
            terminal.setEchoEnabled(true);
        }
        this.terminal = terminal;
        this.enableBackspace = Boolean.parseBoolean(System.getProperty("input.enableBackspace", "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown0() {
        Object object = this.inputLockSingle;
        synchronized (object) {
            this.inputLockSingle.notifyAll();
        }
        object = this.inputLockLine;
        synchronized (object) {
            this.inputLockLine.notifyAll();
        }
        try {
            InputConsole inputConsole = this;
            inputConsole.terminal.restore();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
    }

    private void echo0(boolean enableEcho) {
        this.terminal.setEchoEnabled(enableEcho);
    }

    private boolean echo0() {
        return this.terminal.isEchoEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() {
        Integer bufferCounter = this.threadBufferCounter.get();
        ByteBuffer2 buffer = this.readBuff.get();
        if (buffer == null) {
            bufferCounter = 0;
            this.threadBufferCounter.set(bufferCounter);
            try {
                buffer = (ByteBuffer2)this.pool.takeInterruptibly();
                buffer.clear();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while receiving buffer from pool.");
                buffer = (ByteBuffer2)this.pool.newInstance();
            }
            this.readBuff.set(buffer);
            this.readBuffers.add(buffer);
        }
        if (bufferCounter.intValue() == buffer.position()) {
            Object e = this.inputLockSingle;
            synchronized (e) {
                buffer.setPosition(0);
                this.threadBufferCounter.set(0);
                try {
                    this.inputLockSingle.wait();
                }
                catch (InterruptedException e2) {
                    return -1;
                }
            }
        }
        bufferCounter = this.threadBufferCounter.get();
        char c = buffer.readChar(bufferCounter.intValue());
        bufferCounter = bufferCounter + 2;
        this.threadBufferCounter.set(bufferCounter);
        return c;
    }

    private char[] readLinePassword0() {
        boolean echoEnabled = this.terminal.isEchoEnabled();
        this.terminal.setEchoEnabled(false);
        char[] readLine0 = this.readLine0();
        this.terminal.setEchoEnabled(echoEnabled);
        return readLine0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] readLine0() {
        Object object = this.inputLock;
        synchronized (object) {
            if (this.readLineBuff.get() == null) {
                ByteBuffer2 buffer;
                try {
                    buffer = (ByteBuffer2)this.pool.takeInterruptibly();
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while receiving buffer from pool.");
                    buffer = (ByteBuffer2)this.pool.newInstance();
                }
                this.readLineBuff.set(buffer);
                this.readLineBuffers.add(buffer);
            } else {
                this.readLineBuff.get().clear();
            }
        }
        object = this.inputLockLine;
        synchronized (object) {
            try {
                this.inputLockLine.wait();
            }
            catch (InterruptedException e) {
                return emptyLine;
            }
        }
        ByteBuffer2 buffer = this.readLineBuff.get();
        int len = buffer.position();
        if (len == 0) {
            return emptyLine;
        }
        buffer.rewind();
        char[] readChars = buffer.readChars(len / 2);
        buffer.clearSecure();
        this.readLineBuffers.remove(buffer);
        this.pool.put((Object)buffer);
        this.readLineBuff.set(null);
        return readChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release0() {
        Object object = this.inputLockSingle;
        synchronized (object) {
            this.inputLockSingle.notifyAll();
        }
        object = this.inputLockLine;
        synchronized (object) {
            this.inputLockLine.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        int typedChar;
        Logger logger2 = logger;
        boolean ansiEnabled = Ansi.isEnabled();
        Ansi ansi = Ansi.ansi();
        PrintStream out = AnsiConsole.out;
        while ((typedChar = this.terminal.read()) != -1) {
            Object object = this.inputLock;
            synchronized (object) {
                char asChar = (char)typedChar;
                if (logger2.isTraceEnabled()) {
                    logger2.trace("READ: {} ({})", (Object)Character.valueOf(asChar), (Object)typedChar);
                }
                Object object2 = this.inputLockSingle;
                synchronized (object2) {
                    for (ByteBuffer2 buffer : this.readBuffers) {
                        buffer.writeChar(asChar);
                    }
                    this.inputLockSingle.notifyAll();
                }
                if (this.enableBackspace.booleanValue() && asChar == '\b') {
                    int position = 0;
                    if (ansiEnabled) {
                        for (ByteBuffer2 buffer : this.readLineBuffers) {
                            int length = buffer.position();
                            int amtToOverwrite = 4;
                            if (length > 1) {
                                char charAt = buffer.readChar(length - 2);
                                amtToOverwrite += InputConsole.getPrintableCharacters(charAt);
                                buffer.setPosition(length -= 2);
                                for (int i = 0; i < length; i += 2) {
                                    charAt = buffer.readChar(i);
                                    position += InputConsole.getPrintableCharacters(charAt);
                                }
                                ++position;
                            }
                            char[] overwrite = new char[amtToOverwrite];
                            int c = 32;
                            for (int i = 0; i < amtToOverwrite; ++i) {
                                overwrite[i] = c;
                            }
                            out.print(ansi.cursorToColumn(position));
                            out.print(overwrite);
                            out.print(ansi.cursorToColumn(position));
                            out.flush();
                        }
                    }
                } else if (asChar == '\n') {
                    Object position = this.inputLockLine;
                    synchronized (position) {
                        this.inputLockLine.notifyAll();
                    }
                } else {
                    for (ByteBuffer2 buffer : this.readLineBuffers) {
                        buffer.writeChar(asChar);
                    }
                }
            }
        }
    }

    private boolean isIDEAutoDetect() {
        try {
            ProtectionDomain pDomain = this.getClass().getProtectionDomain();
            CodeSource cSource = pDomain.getCodeSource();
            URL loc = cSource.getLocation();
            File locFile = new File(loc.getFile());
            return locFile.isDirectory();
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static int getPrintableCharacters(int ch) {
        if (ch >= 32) {
            if (ch < 127) {
                return 1;
            }
            if (ch == 127) {
                return 2;
            }
            int count = 2;
            count = ch >= 160 ? (ch < 255 ? ++count : (count += 2)) : (count += 2);
            return count;
        }
        return 2;
    }

    static {
        AnsiConsole.systemInstall();
        Thread consoleThread = new Thread(new Runnable(){

            @Override
            public void run() {
                consoleProxyReader.run();
            }
        });
        consoleThread.setDaemon(true);
        consoleThread.setName("Console Input Reader");
        consoleThread.start();
        Thread shutdownThread = new Thread(){

            @Override
            public void run() {
                AnsiConsole.systemUninstall();
                consoleProxyReader.shutdown0();
            }
        };
        shutdownThread.setName("Console Input Shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        wrappedInputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return consoleProxyReader.read0();
            }

            @Override
            public void close() throws IOException {
                consoleProxyReader.release0();
            }
        };
    }
}

