/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.inputConsole.posix;

import com.sun.jna.Native;
import dorkbox.inputConsole.Encoding;
import dorkbox.inputConsole.Terminal;
import dorkbox.inputConsole.posix.InputStreamReader;
import dorkbox.inputConsole.posix.PosixTerminalControl;
import dorkbox.inputConsole.posix.TermiosStruct;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;

public class UnixTerminal
extends Terminal {
    private volatile TermiosStruct termInfoDefault = new TermiosStruct();
    private volatile TermiosStruct termInfo = new TermiosStruct();
    private final Reader reader;
    private final PosixTerminalControl term;
    private ByteBuffer windowSizeBuffer = ByteBuffer.allocate(8);

    public UnixTerminal() throws Exception {
        String encoding = Encoding.get();
        this.reader = new InputStreamReader(System.in, encoding);
        this.term = (PosixTerminalControl)Native.loadLibrary((String)"c", PosixTerminalControl.class);
        if (this.term.tcgetattr(0, this.termInfoDefault) != 0) {
            throw new IOException("Failed to get terminal info");
        }
    }

    @Override
    public void init() throws IOException {
        if (this.term.tcgetattr(0, this.termInfo) != 0) {
            throw new IOException("Failed to get terminal info");
        }
        this.termInfo.c_iflag &= 0xFFFFFBFF;
        this.termInfo.c_lflag &= 0xFFFFFFFD;
        this.termInfo.c_cc[6] = 1;
        this.termInfo.c_cc[5] = 0;
        this.termInfo.c_cc[10] = 0;
        this.termInfo.c_cc[4] = 0;
        this.termInfo.c_cc[11] = 0;
        if (this.term.tcsetattr(0, 0, this.termInfo) != 0) {
            throw new IOException("Can not set terminal flags");
        }
    }

    @Override
    public final void restore() throws IOException {
        if (this.term.tcsetattr(0, 0, this.termInfoDefault) != 0) {
            throw new IOException("Can not reset terminal to defaults");
        }
    }

    @Override
    public final int getWidth() {
        if (this.term.ioctl(0, PosixTerminalControl.TIOCGWINSZ, this.windowSizeBuffer) != 0) {
            return 80;
        }
        return (short)(0xFF & this.windowSizeBuffer.get(2) + (0xFF & this.windowSizeBuffer.get(3)) * 256);
    }

    @Override
    public final int getHeight() {
        if (this.term.ioctl(0, PosixTerminalControl.TIOCGWINSZ, this.windowSizeBuffer) != 0) {
            return 24;
        }
        return (short)(0xFF & this.windowSizeBuffer.get(0) + (0xFF & this.windowSizeBuffer.get(1)) * 256);
    }

    @Override
    public final synchronized void setEchoEnabled(boolean enabled) {
        if (this.term.tcgetattr(0, this.termInfo) != 0) {
            this.logger.error("Failed to get terminal info");
        }
        this.termInfo.c_lflag = enabled ? (this.termInfo.c_lflag |= 8) : (this.termInfo.c_lflag &= 0xFFFFFFF7);
        if (this.term.tcsetattr(0, 0, this.termInfo) != 0) {
            this.logger.error("Can not set terminal flags");
        }
        super.setEchoEnabled(enabled);
    }

    @Override
    public final int read() {
        try {
            return this.reader.read();
        }
        catch (IOException ignored) {
            return -1;
        }
    }
}

