/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.inputConsole.windows;

import dorkbox.inputConsole.Terminal;
import dorkbox.inputConsole.windows.ConsoleMode;
import java.io.IOException;
import java.io.PrintStream;
import org.fusesource.jansi.internal.WindowsSupport;

public class WindowsTerminal
extends Terminal {
    private volatile int originalMode;
    private final PrintStream out = System.out;

    @Override
    public final void init() throws IOException {
        this.originalMode = WindowsSupport.getConsoleMode();
        WindowsSupport.setConsoleMode((int)(this.originalMode | ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_PROCESSED_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code));
    }

    @Override
    public final void restore() throws IOException {
        WindowsSupport.setConsoleMode((int)this.originalMode);
    }

    @Override
    public final int getWidth() {
        int w = WindowsSupport.getWindowsTerminalWidth();
        return w < 1 ? 80 : w;
    }

    @Override
    public final int getHeight() {
        int h = WindowsSupport.getWindowsTerminalHeight();
        return h < 1 ? 24 : h;
    }

    @Override
    public final int read() {
        int input = this.readInput();
        if (this.isEchoEnabled()) {
            char asChar = (char)input;
            if (asChar == '\n') {
                this.out.println();
            } else {
                this.out.print(asChar);
            }
            this.out.flush();
        }
        return input;
    }

    /*
     * Unable to fully structure code
     */
    private int readInput() {
        try {
            block2: while (true) {
                if ((events = WindowsSupport.readConsoleInput((int)1)) == null) {
                    continue;
                }
                i = 0;
                while (true) {
                    if (i < events.length) ** break;
                    continue block2;
                    keyEvent = events[i].keyEvent;
                    if (keyEvent.keyDown && keyEvent.uchar > '\u0000') {
                        uchar = keyEvent.uchar;
                        if (uchar == '\r') {
                            return 10;
                        }
                        return uchar;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.error("Windows console input error: ", (Throwable)e);
            return -1;
        }
    }
}

