/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.netUtil;

import dorkbox.executor.Executor;
import dorkbox.netUtil.Common;
import dorkbox.netUtil.Dns;
import dorkbox.netUtil.dnsUtils.DefaultHostsFileResolver;
import dorkbox.netUtil.dnsUtils.ResolvedAddressTypes;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR-\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldorkbox/netUtil/Dns;", "", "()V", "DEFAULT_SEARCH_DOMAIN", "", "defaultNameServers", "", "Ljava/net/InetSocketAddress;", "getDefaultNameServers", "()Ljava/util/List;", "defaultNameServers$delegate", "Lkotlin/Lazy;", "nameServers", "", "getNameServers", "()Ljava/util/Map;", "nameServers$delegate", "numberDots", "", "getNumberDots", "()I", "numberDots$delegate", "version", "resolveFromHosts", "Ljava/net/InetAddress;", "inetHost", "resolvedAddressTypes", "Ldorkbox/netUtil/dnsUtils/ResolvedAddressTypes;", "setDNSServers", "", "dnsServersString", "NetworkUtils"})
public final class Dns {
    @NotNull
    public static final Dns INSTANCE = new Dns();
    @NotNull
    public static final String version = "2.16";
    @NotNull
    public static final String DEFAULT_SEARCH_DOMAIN = "";
    @NotNull
    private static final Lazy nameServers$delegate = LazyKt.lazy((Function0)nameServers.2.INSTANCE);
    @NotNull
    private static final Lazy defaultNameServers$delegate = LazyKt.lazy((Function0)defaultNameServers.2.INSTANCE);
    @NotNull
    private static final Lazy numberDots$delegate = LazyKt.lazy((Function0)numberDots.2.INSTANCE);

    private Dns() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDNSServers(@NotNull String dnsServersString) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)dnsServersString, (String)"dnsServersString");
        if (Common.INSTANCE.getOS_LINUX()) {
            String[] stringArray2 = new String[]{","};
            List dnsServers = StringsKt.split$default((CharSequence)dnsServersString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            File dnsFile = new File("/etc/resolvconf/resolv.conf.d/head");
            if (!dnsFile.canRead()) {
                throw new IOException("Unable to initialize dns server file. Something is SERIOUSLY wrong");
            }
            stringArray = (String[])new BufferedWriter(new FileWriter(dnsFile));
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)stringArray;
                boolean bl = false;
                it.write("# File location: /etc/resolvconf/resolv.conf.d/head\n");
                it.write("# Dynamic resolv.conf(5) file for glibc resolver(3) generated by resolvconf(8)\n");
                Iterable $this$forEach$iv = dnsServers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String dns = (String)element$iv;
                    boolean bl2 = false;
                    it.write("nameserver " + dns + '\n');
                }
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)stringArray, (Throwable)throwable);
            }
        } else {
            throw new RuntimeException("NOT IMPL.");
        }
        stringArray = new String[]{"resolvconf", "-u"};
        Executor.startBlocking$default((Executor)new Executor().command(stringArray), (long)0L, null, (int)3, null);
    }

    @Nullable
    public final InetAddress resolveFromHosts(@NotNull String inetHost, @NotNull ResolvedAddressTypes resolvedAddressTypes) {
        Intrinsics.checkNotNullParameter((Object)inetHost, (String)"inetHost");
        Intrinsics.checkNotNullParameter((Object)((Object)resolvedAddressTypes), (String)"resolvedAddressTypes");
        return DefaultHostsFileResolver.INSTANCE.address(inetHost, resolvedAddressTypes);
    }

    public static /* synthetic */ InetAddress resolveFromHosts$default(Dns dns, String string, ResolvedAddressTypes resolvedAddressTypes, int n, Object object) {
        if ((n & 2) != 0) {
            resolvedAddressTypes = ResolvedAddressTypes.IPV4_PREFERRED;
        }
        return dns.resolveFromHosts(string, resolvedAddressTypes);
    }

    @NotNull
    public final Map<String, List<InetSocketAddress>> getNameServers() {
        Lazy lazy = nameServers$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final List<InetSocketAddress> getDefaultNameServers() {
        Lazy lazy = defaultNameServers$delegate;
        return (List)lazy.getValue();
    }

    public final int getNumberDots() {
        Lazy lazy = numberDots$delegate;
        return ((Number)lazy.getValue()).intValue();
    }
}

