/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.AppAccessor;
import dorkbox.notify.AppMouseAdapter;
import dorkbox.notify.LAFUtil;
import dorkbox.notify.Notify;
import dorkbox.notify.NotifyType;
import dorkbox.notify.Position;
import dorkbox.notify.Theme;
import dorkbox.tweenEngine.Tween;
import dorkbox.tweenEngine.TweenAccessor;
import dorkbox.tweenEngine.TweenEquations;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 U2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001UB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010?\u001a\u00020@H\u0016J \u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0016J\u0010\u0010F\u001a\u00020@2\u0006\u0010G\u001a\u00020HH\u0002J\u0016\u0010I\u001a\u00020@2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007J\u0010\u0010L\u001a\u00020@2\u0006\u0010G\u001a\u00020HH\u0016J\b\u0010M\u001a\u00020@H\u0016J\u0018\u0010N\u001a\u00020@2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0016J\u0016\u0010O\u001a\u00020@2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007J\u0010\u0010P\u001a\u00020@2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020@H\u0016J\u0010\u0010T\u001a\u00020@2\u0006\u0010K\u001a\u00020DH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\t\"\u0004\b#\u0010\u000bR\u001a\u0010$\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\t\"\u0004\b&\u0010\u000bR\"\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\t\"\u0004\b0\u0010\u000bR\u000e\u00101\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\t\"\u0004\b5\u0010\u000bR\"\u00106\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0018\"\u0004\b8\u0010\u001aR\u001a\u00109\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\t\"\u0004\b;\u0010\u000bR\u001a\u0010<\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\t\"\u0004\b>\u0010\u000b\u00a8\u0006V"}, d2={"Ldorkbox/notify/AppNotify;", "Ljava/awt/Canvas;", "Ldorkbox/notify/NotifyType;", "notification", "Ldorkbox/notify/Notify;", "(Ldorkbox/notify/Notify;)V", "anchorX", "", "getAnchorX", "()I", "setAnchorX", "(I)V", "anchorY", "getAnchorY", "setAnchorY", "cachedClose", "Ljava/awt/image/BufferedImage;", "cachedCloseEnabled", "cachedImage", "glassPane", "Ljavax/swing/JPanel;", "hideTween", "Ldorkbox/tweenEngine/Tween;", "getHideTween", "()Ldorkbox/tweenEngine/Tween;", "setHideTween", "(Ldorkbox/tweenEngine/Tween;)V", "idAndPosition", "", "getIdAndPosition", "()Ljava/lang/String;", "setIdAndPosition", "(Ljava/lang/String;)V", "mouseX", "getMouseX", "setMouseX", "mouseY", "getMouseY", "setMouseY", "moveTween", "getMoveTween", "setMoveTween", "getNotification", "()Ldorkbox/notify/Notify;", "parent", "Ljavax/swing/JFrame;", "popupIndex", "getPopupIndex", "setPopupIndex", "prevProgress", "value", "progress", "getProgress", "setProgress", "shakeTween", "getShakeTween", "setShakeTween", "shakeX", "getShakeX", "setShakeX", "shakeY", "getShakeY", "setShakeY", "close", "", "doShake", "count", "targetX", "", "targetY", "draw", "g", "Ljava/awt/Graphics;", "onClick", "x", "y", "paint", "refresh", "setLocationInternal", "setLocationShake", "setVisible", "visible", "", "setupHide", "setupMove", "Companion", "Notify"})
public final class AppNotify
extends Canvas
implements NotifyType<AppNotify> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Notify notification;
    private BufferedImage cachedImage;
    private BufferedImage cachedClose;
    private BufferedImage cachedCloseEnabled;
    private int prevProgress;
    private int progress;
    @Nullable
    private Tween<AppNotify> shakeTween;
    @Nullable
    private Tween<AppNotify> moveTween;
    @Nullable
    private Tween<AppNotify> hideTween;
    @NotNull
    private String idAndPosition;
    private int popupIndex;
    private int anchorX;
    private int anchorY;
    private int shakeX;
    private int shakeY;
    private volatile int mouseY;
    private volatile int mouseX;
    @NotNull
    private final JFrame parent;
    @NotNull
    private JPanel glassPane;
    @NotNull
    private static final String glassPanePrefix = "dorkbox.notify";
    @NotNull
    private static final Map<JFrame, Pair<String, Boolean>> previousStates = new LinkedHashMap();
    @NotNull
    private static final AppAccessor tweenAccessor = new AppAccessor();
    @NotNull
    private static final MouseAdapter mouseListener = new AppMouseAdapter();

    public AppNotify(@NotNull Notify notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.notification = notification;
        this.idAndPosition = "";
        JFrame jFrame = this.getNotification().getAttachedFrame();
        Intrinsics.checkNotNull((Object)jFrame);
        this.parent = jFrame;
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        Dimension actualSize = new Dimension(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT());
        this.setPreferredSize(actualSize);
        this.setMaximumSize(actualSize);
        this.setMinimumSize(actualSize);
        this.setSize(actualSize);
        this.setFocusable(true);
        this.setBackground(this.getNotification().getTheme().getPanel_BG());
        this.setIdAndPosition(this.parent.getName() + ':' + (Object)((Object)this.getNotification().getPosition()));
        Position position = this.getNotification().getPosition();
        Rectangle rectangle = this.parent.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"parent.bounds");
        this.setAnchorX(AppNotify.Companion.getAnchorX(position, rectangle));
        Position position2 = this.getNotification().getPosition();
        Rectangle rectangle2 = this.parent.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"parent.bounds");
        this.setAnchorY(AppNotify.Companion.getAnchorY(position2, rectangle2));
        Component pane = this.parent.getGlassPane();
        if (pane instanceof JPanel) {
            this.glassPane = (JPanel)pane;
            String name = this.glassPane.getName();
            if (!Intrinsics.areEqual((Object)name, (Object)glassPanePrefix)) {
                this.glassPane.setLayout(null);
                this.glassPane.setName(glassPanePrefix);
                previousStates.put(this.parent, (Pair<String, Boolean>)new Pair((Object)name, (Object)this.glassPane.isVisible()));
                if (!this.glassPane.isVisible()) {
                    this.glassPane.setVisible(true);
                }
            }
        } else {
            throw new RuntimeException("Not able to add the notification to the window glassPane");
        }
        this.glassPane.add(this);
        this.refresh();
    }

    @Override
    @NotNull
    public Notify getNotification() {
        return this.notification;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int value) {
        this.prevProgress = this.progress;
        this.progress = value;
    }

    @Override
    @Nullable
    public Tween<AppNotify> getShakeTween() {
        return this.shakeTween;
    }

    @Override
    public void setShakeTween(@Nullable Tween<AppNotify> tween2) {
        this.shakeTween = tween2;
    }

    @Override
    @Nullable
    public Tween<AppNotify> getMoveTween() {
        return this.moveTween;
    }

    @Override
    public void setMoveTween(@Nullable Tween<AppNotify> tween2) {
        this.moveTween = tween2;
    }

    @Override
    @Nullable
    public Tween<AppNotify> getHideTween() {
        return this.hideTween;
    }

    @Override
    public void setHideTween(@Nullable Tween<AppNotify> tween2) {
        this.hideTween = tween2;
    }

    @Override
    @NotNull
    public String getIdAndPosition() {
        return this.idAndPosition;
    }

    @Override
    public void setIdAndPosition(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.idAndPosition = string;
    }

    @Override
    public int getPopupIndex() {
        return this.popupIndex;
    }

    @Override
    public void setPopupIndex(int n) {
        this.popupIndex = n;
    }

    @Override
    public int getAnchorX() {
        return this.anchorX;
    }

    @Override
    public void setAnchorX(int n) {
        this.anchorX = n;
    }

    @Override
    public int getAnchorY() {
        return this.anchorY;
    }

    @Override
    public void setAnchorY(int n) {
        this.anchorY = n;
    }

    public final int getShakeX() {
        return this.shakeX;
    }

    public final void setShakeX(int n) {
        this.shakeX = n;
    }

    public final int getShakeY() {
        return this.shakeY;
    }

    public final void setShakeY(int n) {
        this.shakeY = n;
    }

    public final int getMouseY() {
        return this.mouseY;
    }

    public final void setMouseY(int n) {
        this.mouseY = n;
    }

    public final int getMouseX() {
        return this.mouseX;
    }

    public final void setMouseX(int n) {
        this.mouseX = n;
    }

    @Override
    public void refresh() {
        this.cachedImage = this.renderBackgroundInfo(this.getNotification().getTitle(), this.getNotification().getText(), this.getNotification().getTheme(), this.getNotification().getImage());
        this.cachedClose = this.renderCloseButton(this.getNotification().getTheme(), false);
        this.cachedCloseEnabled = this.renderCloseButton(this.getNotification().getTheme(), true);
        this.setIdAndPosition(this.parent.getName() + ':' + (Object)((Object)this.getNotification().getPosition()));
        Position position = this.getNotification().getPosition();
        Rectangle rectangle = this.parent.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"parent.bounds");
        this.setAnchorX(AppNotify.Companion.getAnchorX(position, rectangle));
        Position position2 = this.getNotification().getPosition();
        Rectangle rectangle2 = this.parent.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"parent.bounds");
        this.setAnchorY(AppNotify.Companion.getAnchorY(position2, rectangle2));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        try {
            this.draw(g);
        }
        catch (Exception ignored) {
            this.refresh();
            try {
                this.draw(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getProgress() > 0 && this.prevProgress != this.getProgress()) {
            g.setColor(this.getNotification().getTheme().getProgress_FG());
            g.fillRect(0, Notify.Companion.getHEIGHT() - 2, this.getProgress(), 2);
        }
    }

    private final void draw(Graphics g) {
        BufferedImage bufferedImage = this.cachedImage;
        if (bufferedImage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedImage");
            bufferedImage = null;
        }
        g.drawImage(bufferedImage, 0, 0, null);
        if (!this.getNotification().getHideCloseButton()) {
            if (this.mouseX >= 280 && this.mouseY <= 20) {
                BufferedImage bufferedImage2 = this.cachedCloseEnabled;
                if (bufferedImage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCloseEnabled");
                    bufferedImage2 = null;
                }
                g.drawImage(bufferedImage2, 0, 0, null);
            } else {
                BufferedImage bufferedImage3 = this.cachedClose;
                if (bufferedImage3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedClose");
                    bufferedImage3 = null;
                }
                g.drawImage(bufferedImage3, 0, 0, null);
            }
        }
    }

    public final void onClick(int x, int y) {
        boolean isClickOnCloseButton;
        boolean bl = isClickOnCloseButton = !this.getNotification().getHideCloseButton() && x >= 280 && y <= 20;
        if (isClickOnCloseButton) {
            this.getNotification().onClose$Notify();
        } else {
            this.getNotification().onClickAction$Notify();
        }
    }

    @Override
    public void setupHide() {
        if (this.getHideTween() == null && this.getNotification().getHideAfterDurationInMillis() > 0) {
            Tween tween2 = LAFUtil.INSTANCE.getTweenEngine().to((Object)this, 4, (TweenAccessor)tweenAccessor, (float)this.getNotification().getHideAfterDurationInMillis() / 1000.0f).value((float)Notify.Companion.getWIDTH()).ease(TweenEquations.Linear).addCallback(8, (Function1)new Function1<Tween<AppNotify>, Unit>(this){
                final /* synthetic */ AppNotify this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Tween<AppNotify> $this$addCallback) {
                    Intrinsics.checkNotNullParameter($this$addCallback, (String)"$this$addCallback");
                    this.this$0.getNotification().onClose$Notify();
                }
            });
            this.setHideTween((Tween<AppNotify>)tween2);
            tween2.start();
        }
    }

    @Override
    public void setupMove(float y) {
        if (this.getMoveTween() != null) {
            Tween<AppNotify> tween2 = this.getMoveTween();
            Intrinsics.checkNotNull(tween2);
            tween2.value(y);
        } else {
            Tween tween3 = LAFUtil.INSTANCE.getTweenEngine().to((Object)this, 1, (TweenAccessor)tweenAccessor, Notify.Companion.getMOVE_DURATION()).value(y).ease(TweenEquations.Linear).addCallback(8, (Function1)new Function1<Tween<AppNotify>, Unit>(this){
                final /* synthetic */ AppNotify this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Tween<AppNotify> $this$addCallback) {
                    Intrinsics.checkNotNullParameter($this$addCallback, (String)"$this$addCallback");
                    this.this$0.setMoveTween((Tween<AppNotify>)null);
                }
            });
            this.setMoveTween((Tween<AppNotify>)tween3);
            tween3.start();
        }
    }

    @Override
    public void doShake(int count, float targetX, float targetY) {
        if (this.getShakeTween() != null) {
            Tween<AppNotify> tween2 = this.getShakeTween();
            Intrinsics.checkNotNull(tween2);
            tween2.valueRelative(targetX, targetY).repeatAutoReverse(count, 0.0f);
        } else {
            Tween tween3 = LAFUtil.INSTANCE.getTweenEngine().to((Object)this, 3, (TweenAccessor)tweenAccessor, 0.05f).valueRelative(targetX, targetY).repeatAutoReverse(count, 0.0f).ease(TweenEquations.Linear);
            this.setShakeTween((Tween<AppNotify>)tween3);
            tween3.start();
        }
    }

    public final void setLocationShake(int x, int y) {
        int x1 = this.getX() - this.shakeX;
        int y1 = this.getY() - this.shakeY;
        this.shakeX = x;
        this.shakeY = y;
        this.setLocationInternal(x1 + x, y1 + y);
    }

    @Override
    public void setLocationInternal(int x, int y) {
        this.setLocation(x, y);
    }

    @Override
    public void setVisible(boolean visible) {
        this.updatePositionsPre((Component)this, this, visible);
        this.updatePositionsPost((Component)this, this, visible);
    }

    @Override
    public void close() {
        this.cancelMove();
        this.cancelHide();
        this.cancelShake();
        this.glassPane.remove(this);
        this.removeMouseMotionListener(mouseListener);
        this.removeMouseListener(mouseListener);
        this.updatePositionsPre((Component)this, this, false);
        boolean found = false;
        Pair<String, Boolean> components = this.glassPane.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)components, (String)"components");
        for (Component component : components) {
            if (!(component instanceof AppNotify)) continue;
            found = true;
            break;
        }
        if (!found) {
            Pair<String, Boolean> pair = previousStates.remove(this.parent);
            Intrinsics.checkNotNull(pair);
            Pair<String, Boolean> pair2 = pair;
            String name = (String)pair2.component1();
            boolean visibility = (Boolean)pair2.component2();
            this.glassPane.setName(name);
            this.glassPane.setVisible(visibility);
        }
    }

    @Override
    @NotNull
    public BufferedImage renderBackgroundInfo(@NotNull String title, @NotNull String textBody, @NotNull Theme theme, @Nullable ImageIcon imageIcon) {
        return NotifyType.DefaultImpls.renderBackgroundInfo(this, title, textBody, theme, imageIcon);
    }

    @Override
    @NotNull
    public BufferedImage renderCloseButton(@NotNull Theme theme, boolean enabled) {
        return NotifyType.DefaultImpls.renderCloseButton(this, theme, enabled);
    }

    @Override
    public void updatePositionsPre(@NotNull Component component, @NotNull NotifyType<AppNotify> notify, boolean visible) {
        NotifyType.DefaultImpls.updatePositionsPre(this, component, notify, visible);
    }

    @Override
    public void updatePositionsPost(@NotNull Component component, @NotNull NotifyType<AppNotify> notify, boolean visible) {
        NotifyType.DefaultImpls.updatePositionsPost(this, component, notify, visible);
    }

    @Override
    public void shake(int durationInMillis, int amplitude) {
        NotifyType.DefaultImpls.shake(this, durationInMillis, amplitude);
    }

    @Override
    public void cancelShake() {
        NotifyType.DefaultImpls.cancelShake(this);
    }

    @Override
    public void cancelHide() {
        NotifyType.DefaultImpls.cancelHide(this);
    }

    @Override
    public void cancelMove() {
        NotifyType.DefaultImpls.cancelMove(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldorkbox/notify/AppNotify$Companion;", "", "()V", "glassPanePrefix", "", "mouseListener", "Ljava/awt/event/MouseAdapter;", "previousStates", "", "Ljavax/swing/JFrame;", "Lkotlin/Pair;", "", "tweenAccessor", "Ldorkbox/notify/AppAccessor;", "getAnchorX", "", "position", "Ldorkbox/notify/Position;", "bounds", "Ljava/awt/Rectangle;", "getAnchorY", "Notify"})
    public static final class Companion {
        private Companion() {
        }

        private final int getAnchorX(Position position, Rectangle bounds) {
            int n;
            int startX = 0;
            int screenWidth = (int)bounds.getWidth();
            switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                case 1: 
                case 2: {
                    n = Notify.Companion.getMARGIN() + startX;
                    break;
                }
                case 3: {
                    n = startX + screenWidth / 2 - Notify.Companion.getWIDTH() / 2 - Notify.Companion.getMARGIN() / 2;
                    break;
                }
                case 4: 
                case 5: {
                    n = startX + screenWidth - Notify.Companion.getWIDTH() - Notify.Companion.getMARGIN();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final int getAnchorY(Position position, Rectangle bounds) {
            int n;
            int startY = 0;
            int screenHeight = (int)bounds.getHeight();
            switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                case 1: 
                case 4: {
                    n = startY + Notify.Companion.getMARGIN();
                    break;
                }
                case 3: {
                    n = startY + screenHeight / 2 - Notify.Companion.getHEIGHT() / 2 - Notify.Companion.getMARGIN() / 2 - Notify.Companion.getSPACER();
                    break;
                }
                case 2: 
                case 5: {
                    n = screenHeight - Notify.Companion.getHEIGHT() - Notify.Companion.getMARGIN() - Notify.Companion.getSPACER() * 2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Position.values().length];
                try {
                    nArray[Position.TOP_LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.BOTTOM_LEFT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.CENTER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.TOP_RIGHT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.BOTTOM_RIGHT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

