/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.DesktopAccessor;
import dorkbox.notify.DesktopMouseAdapter;
import dorkbox.notify.DesktopWindowCloseAdapter;
import dorkbox.notify.LAFUtil;
import dorkbox.notify.Notify;
import dorkbox.notify.NotifyType;
import dorkbox.notify.Position;
import dorkbox.notify.Theme;
import dorkbox.tweenEngine.Tween;
import dorkbox.tweenEngine.TweenAccessor;
import dorkbox.tweenEngine.TweenEquations;
import dorkbox.util.ScreenUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 Q2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001QB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u00020=H\u0016J \u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0016J\u0010\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020EH\u0002J\u0006\u0010F\u001a\u00020=J\u0010\u0010G\u001a\u00020=2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010H\u001a\u00020=H\u0016J\u0018\u0010I\u001a\u00020=2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0016J\u0016\u0010L\u001a\u00020=2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007J\u0010\u0010M\u001a\u00020=2\u0006\u0010N\u001a\u000209H\u0016J\b\u0010O\u001a\u00020=H\u0016J\u0010\u0010P\u001a\u00020=2\u0006\u0010K\u001a\u00020AH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000bR\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\t\"\u0004\b-\u0010\u000bR\"\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0018\"\u0004\b0\u0010\u001aR\u001a\u00101\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\t\"\u0004\b3\u0010\u000bR\u001a\u00104\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\t\"\u0004\b6\u0010\u000b\u00a8\u0006R"}, d2={"Ldorkbox/notify/DesktopNotify;", "Ljavax/swing/JWindow;", "Ldorkbox/notify/NotifyType;", "notification", "Ldorkbox/notify/Notify;", "(Ldorkbox/notify/Notify;)V", "anchorX", "", "getAnchorX", "()I", "setAnchorX", "(I)V", "anchorY", "getAnchorY", "setAnchorY", "cachedClose", "Ljava/awt/image/BufferedImage;", "cachedCloseEnabled", "cachedImage", "closeButton", "Ljava/awt/Rectangle;", "hideTween", "Ldorkbox/tweenEngine/Tween;", "getHideTween", "()Ldorkbox/tweenEngine/Tween;", "setHideTween", "(Ldorkbox/tweenEngine/Tween;)V", "idAndPosition", "", "getIdAndPosition", "()Ljava/lang/String;", "setIdAndPosition", "(Ljava/lang/String;)V", "moveTween", "getMoveTween", "setMoveTween", "getNotification", "()Ldorkbox/notify/Notify;", "popupIndex", "getPopupIndex", "setPopupIndex", "prevProgress", "value", "progress", "getProgress", "setProgress", "shakeTween", "getShakeTween", "setShakeTween", "shakeX", "getShakeX", "setShakeX", "shakeY", "getShakeY", "setShakeY", "calculateOffset", "showFromTop", "", "point", "Ljava/awt/Point;", "close", "", "doShake", "count", "targetX", "", "targetY", "draw", "g", "Ljava/awt/Graphics;", "onClick", "paint", "refresh", "setLocationInternal", "x", "y", "setLocationShake", "setVisible", "visible", "setupHide", "setupMove", "Companion", "Notify"})
public final class DesktopNotify
extends JWindow
implements NotifyType<DesktopNotify> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Notify notification;
    private BufferedImage cachedImage;
    private BufferedImage cachedClose;
    private BufferedImage cachedCloseEnabled;
    private int prevProgress;
    private int progress;
    @NotNull
    private final Rectangle closeButton;
    @Nullable
    private Tween<DesktopNotify> shakeTween;
    @Nullable
    private Tween<DesktopNotify> moveTween;
    @Nullable
    private Tween<DesktopNotify> hideTween;
    @NotNull
    private String idAndPosition;
    private int popupIndex;
    private int anchorX;
    private int anchorY;
    private int shakeX;
    private int shakeY;
    @NotNull
    private static final DesktopAccessor tweenAccessor = new DesktopAccessor();
    @NotNull
    private static final DesktopWindowCloseAdapter windowCloseListener = new DesktopWindowCloseAdapter();
    @NotNull
    private static final DesktopMouseAdapter mouseListener = new DesktopMouseAdapter();

    public DesktopNotify(@NotNull Notify notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        this.notification = notification;
        this.idAndPosition = "";
        this.addWindowListener(windowCloseListener);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.setAlwaysOnTop(true);
        this.setPreferredSize(new Dimension(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT()));
        this.setMaximumSize(new Dimension(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT()));
        this.setMinimumSize(new Dimension(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT()));
        this.setSize(new Dimension(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT()));
        this.setLocation(Short.MIN_VALUE, Short.MIN_VALUE);
        this.closeButton = new Rectangle(282, 2, 18, 18);
        this.setBackground(this.getNotification().getTheme().getPanel_BG());
        this.refresh();
    }

    @Override
    @NotNull
    public Notify getNotification() {
        return this.notification;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int value) {
        this.prevProgress = this.progress;
        this.progress = value;
    }

    @Override
    @Nullable
    public Tween<DesktopNotify> getShakeTween() {
        return this.shakeTween;
    }

    @Override
    public void setShakeTween(@Nullable Tween<DesktopNotify> tween2) {
        this.shakeTween = tween2;
    }

    @Override
    @Nullable
    public Tween<DesktopNotify> getMoveTween() {
        return this.moveTween;
    }

    @Override
    public void setMoveTween(@Nullable Tween<DesktopNotify> tween2) {
        this.moveTween = tween2;
    }

    @Override
    @Nullable
    public Tween<DesktopNotify> getHideTween() {
        return this.hideTween;
    }

    @Override
    public void setHideTween(@Nullable Tween<DesktopNotify> tween2) {
        this.hideTween = tween2;
    }

    @Override
    @NotNull
    public String getIdAndPosition() {
        return this.idAndPosition;
    }

    @Override
    public void setIdAndPosition(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.idAndPosition = string;
    }

    @Override
    public int getPopupIndex() {
        return this.popupIndex;
    }

    @Override
    public void setPopupIndex(int n) {
        this.popupIndex = n;
    }

    @Override
    public int getAnchorX() {
        return this.anchorX;
    }

    @Override
    public void setAnchorX(int n) {
        this.anchorX = n;
    }

    @Override
    public int getAnchorY() {
        return this.anchorY;
    }

    @Override
    public void setAnchorY(int n) {
        this.anchorY = n;
    }

    public final int getShakeX() {
        return this.shakeX;
    }

    public final void setShakeX(int n) {
        this.shakeX = n;
    }

    public final int getShakeY() {
        return this.shakeY;
    }

    public final void setShakeY(int n) {
        this.shakeY = n;
    }

    @Override
    public void refresh() {
        this.cachedImage = this.renderBackgroundInfo(this.getNotification().getTitle(), this.getNotification().getText(), this.getNotification().getTheme(), this.getNotification().getImage());
        this.cachedClose = this.renderCloseButton(this.getNotification().getTheme(), false);
        this.cachedCloseEnabled = this.renderCloseButton(this.getNotification().getTheme(), true);
        Rectangle bounds = LAFUtil.INSTANCE.getGraphics(this.getNotification().getScreen());
        Point point = new Point((int)bounds.getX(), (int)bounds.getY());
        this.setIdAndPosition("" + ScreenUtil.INSTANCE.getMonitorNumberAtLocation(point) + ':' + (Object)((Object)this.getNotification().getPosition()));
        boolean growDown = LAFUtil.INSTANCE.growDown(this);
        this.setAnchorX(DesktopNotify.Companion.getAnchorX(this.getNotification().getPosition(), bounds));
        this.setAnchorY(DesktopNotify.Companion.getAnchorY(this.getNotification().getPosition(), bounds) + this.calculateOffset(growDown, point));
    }

    private final int calculateOffset(boolean showFromTop, Point point) {
        GraphicsDevice graphicsDevice = ScreenUtil.INSTANCE.getMonitorAtLocation(point);
        GraphicsConfiguration graphicsConfiguration = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        if (graphicsConfiguration == null) {
            return 0;
        }
        GraphicsConfiguration gc = graphicsConfiguration;
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        if (showFromTop) {
            if (screenInsets.top > 0) {
                return screenInsets.top - Notify.Companion.getMARGIN();
            }
        } else if (screenInsets.bottom > 0) {
            return screenInsets.bottom + Notify.Companion.getMARGIN();
        }
        return 0;
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        try {
            this.draw(g);
        }
        catch (Exception ignored) {
            this.refresh();
            try {
                this.draw(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getProgress() > 0 && this.prevProgress != this.getProgress()) {
            g.setColor(this.getNotification().getTheme().getProgress_FG());
            g.fillRect(0, Notify.Companion.getHEIGHT() - 2, this.getProgress(), 2);
        }
    }

    private final void draw(Graphics g) {
        BufferedImage bufferedImage = this.cachedImage;
        if (bufferedImage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedImage");
            bufferedImage = null;
        }
        g.drawImage(bufferedImage, 0, 0, null);
        if (!this.getNotification().getHideCloseButton()) {
            if (this.closeButton.contains(MouseInfo.getPointerInfo().getLocation())) {
                BufferedImage bufferedImage2 = this.cachedCloseEnabled;
                if (bufferedImage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedCloseEnabled");
                    bufferedImage2 = null;
                }
                g.drawImage(bufferedImage2, 0, 0, null);
            } else {
                BufferedImage bufferedImage3 = this.cachedClose;
                if (bufferedImage3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedClose");
                    bufferedImage3 = null;
                }
                g.drawImage(bufferedImage3, 0, 0, null);
            }
        }
    }

    public final void onClick() {
        boolean isClickOnCloseButton;
        boolean bl = isClickOnCloseButton = !this.getNotification().getHideCloseButton() && this.closeButton.contains(MouseInfo.getPointerInfo().getLocation());
        if (isClickOnCloseButton) {
            this.getNotification().onClose$Notify();
        } else {
            this.getNotification().onClickAction$Notify();
        }
    }

    @Override
    public void setupHide() {
        if (this.getHideTween() != null) {
            Tween<DesktopNotify> tween2 = this.getHideTween();
            Intrinsics.checkNotNull(tween2);
            tween2.value((float)Notify.Companion.getWIDTH());
        } else if (this.getNotification().getHideAfterDurationInMillis() > 0) {
            Tween tween3 = LAFUtil.INSTANCE.getTweenEngine().to((Object)this, 4, (TweenAccessor)tweenAccessor, (float)this.getNotification().getHideAfterDurationInMillis() / 1000.0f).value((float)Notify.Companion.getWIDTH()).ease(TweenEquations.Linear).addCallback(8, (Function1)new Function1<Tween<DesktopNotify>, Unit>(this){
                final /* synthetic */ DesktopNotify this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Tween<DesktopNotify> $this$addCallback) {
                    Intrinsics.checkNotNullParameter($this$addCallback, (String)"$this$addCallback");
                    this.this$0.getNotification().onClose$Notify();
                }
            });
            this.setHideTween((Tween<DesktopNotify>)tween3);
            tween3.start();
        }
    }

    @Override
    public void setupMove(float y) {
        if (this.getMoveTween() != null) {
            Tween<DesktopNotify> tween2 = this.getMoveTween();
            Intrinsics.checkNotNull(tween2);
            tween2.value(y);
        } else {
            Tween tween3 = LAFUtil.INSTANCE.getTweenEngine().to((Object)this, 1, (TweenAccessor)tweenAccessor, Notify.Companion.getMOVE_DURATION()).value(y).ease(TweenEquations.Linear).addCallback(8, (Function1)new Function1<Tween<DesktopNotify>, Unit>(this){
                final /* synthetic */ DesktopNotify this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Tween<DesktopNotify> $this$addCallback) {
                    Intrinsics.checkNotNullParameter($this$addCallback, (String)"$this$addCallback");
                    this.this$0.setMoveTween((Tween<DesktopNotify>)null);
                }
            });
            this.setMoveTween((Tween<DesktopNotify>)tween3);
            tween3.start();
        }
    }

    @Override
    public void doShake(int count, float targetX, float targetY) {
        if (this.getShakeTween() != null) {
            Tween<DesktopNotify> tween2 = this.getShakeTween();
            Intrinsics.checkNotNull(tween2);
            tween2.value(targetX, targetY).repeatAutoReverse(count, 0.0f);
        } else {
            Tween tween3 = LAFUtil.INSTANCE.getTweenEngine().to((Object)this, 3, (TweenAccessor)tweenAccessor, 0.05f).value(targetX, targetY).repeatAutoReverse(count, 0.0f).ease(TweenEquations.Linear);
            this.setShakeTween((Tween<DesktopNotify>)tween3);
            tween3.start();
        }
    }

    public final void setLocationShake(int x, int y) {
        int x1 = this.getX() - this.shakeX;
        int y1 = this.getY() - this.shakeY;
        this.shakeX = x;
        this.shakeY = y;
        this.setLocationInternal(x1 + x, y1 + y);
    }

    @Override
    public void setLocationInternal(int x, int y) {
        this.setLocation(x, y);
        this.closeButton.setLocation(x + 287, y);
    }

    @Override
    public void setVisible(boolean visible) {
        this.updatePositionsPre((Component)this, this, visible);
        super.setVisible(visible);
        this.updatePositionsPost((Component)this, this, visible);
        if (visible) {
            this.toFront();
        }
    }

    @Override
    public void close() {
        this.cancelMove();
        this.cancelHide();
        this.cancelShake();
        this.removeWindowListener(windowCloseListener);
        this.removeMouseMotionListener(mouseListener);
        this.removeMouseListener(mouseListener);
        this.updatePositionsPre((Component)this, this, false);
        super.setVisible(false);
        this.removeAll();
        this.dispose();
    }

    @Override
    @NotNull
    public BufferedImage renderBackgroundInfo(@NotNull String title, @NotNull String textBody, @NotNull Theme theme, @Nullable ImageIcon imageIcon) {
        return NotifyType.DefaultImpls.renderBackgroundInfo(this, title, textBody, theme, imageIcon);
    }

    @Override
    @NotNull
    public BufferedImage renderCloseButton(@NotNull Theme theme, boolean enabled) {
        return NotifyType.DefaultImpls.renderCloseButton(this, theme, enabled);
    }

    @Override
    public void updatePositionsPre(@NotNull Component component, @NotNull NotifyType<DesktopNotify> notify, boolean visible) {
        NotifyType.DefaultImpls.updatePositionsPre(this, component, notify, visible);
    }

    @Override
    public void updatePositionsPost(@NotNull Component component, @NotNull NotifyType<DesktopNotify> notify, boolean visible) {
        NotifyType.DefaultImpls.updatePositionsPost(this, component, notify, visible);
    }

    @Override
    public void shake(int durationInMillis, int amplitude) {
        NotifyType.DefaultImpls.shake(this, durationInMillis, amplitude);
    }

    @Override
    public void cancelShake() {
        NotifyType.DefaultImpls.cancelShake(this);
    }

    @Override
    public void cancelHide() {
        NotifyType.DefaultImpls.cancelHide(this);
    }

    @Override
    public void cancelMove() {
        NotifyType.DefaultImpls.cancelMove(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/notify/DesktopNotify$Companion;", "", "()V", "mouseListener", "Ldorkbox/notify/DesktopMouseAdapter;", "tweenAccessor", "Ldorkbox/notify/DesktopAccessor;", "windowCloseListener", "Ldorkbox/notify/DesktopWindowCloseAdapter;", "getAnchorX", "", "position", "Ldorkbox/notify/Position;", "bounds", "Ljava/awt/Rectangle;", "getAnchorY", "Notify"})
    public static final class Companion {
        private Companion() {
        }

        private final int getAnchorX(Position position, Rectangle bounds) {
            int n;
            int startX = (int)bounds.getX();
            int screenWidth = (int)bounds.getWidth();
            switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                case 1: 
                case 2: {
                    n = Notify.Companion.getMARGIN() + startX;
                    break;
                }
                case 3: {
                    n = startX + screenWidth / 2 - Notify.Companion.getWIDTH() / 2 - Notify.Companion.getMARGIN() / 2;
                    break;
                }
                case 4: 
                case 5: {
                    n = startX + screenWidth - Notify.Companion.getWIDTH() - Notify.Companion.getMARGIN();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final int getAnchorY(Position position, Rectangle bounds) {
            int n;
            int startY = (int)bounds.getY();
            int screenHeight = (int)bounds.getHeight();
            switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                case 1: 
                case 4: {
                    n = startY + Notify.Companion.getMARGIN();
                    break;
                }
                case 3: {
                    n = startY + screenHeight / 2 - Notify.Companion.getHEIGHT() / 2 - Notify.Companion.getMARGIN() / 2;
                    break;
                }
                case 2: 
                case 5: {
                    n = startY + screenHeight - Notify.Companion.getHEIGHT() - Notify.Companion.getMARGIN();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Position.values().length];
                try {
                    nArray[Position.TOP_LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.BOTTOM_LEFT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.CENTER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.TOP_RIGHT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Position.BOTTOM_RIGHT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

