/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.AppNotify;
import dorkbox.notify.DesktopNotify;
import dorkbox.notify.Notify;
import dorkbox.notify.NotifyType;
import dorkbox.notify.Position;
import dorkbox.notify.Theme;
import dorkbox.propertyLoader.Property;
import dorkbox.updates.Updates;
import dorkbox.util.ImageUtil;
import dorkbox.util.LocationResolver;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ]2\u00020\u0001:\u0001]B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010K\u001a\u00020\u00002\b\u0010L\u001a\u0004\u0018\u00010\u0004J\u0006\u0010M\u001a\u00020$J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020PJ\r\u0010\"\u001a\u00020$H\u0000\u00a2\u0006\u0002\bQJ\u001f\u0010\"\u001a\u00020\u00002\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%J\r\u0010S\u001a\u00020$H\u0000\u00a2\u0006\u0002\bTJ\u001f\u0010*\u001a\u00020\u00002\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u000e\u00105\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\nJ\u001a\u0010V\u001a\u00020\u00002\b\b\u0002\u0010O\u001a\u00020\n2\b\b\u0002\u0010W\u001a\u00020\nJ\u0006\u0010X\u001a\u00020$J\u0006\u0010Y\u001a\u00020$J\u0006\u0010Z\u001a\u00020$J\u0006\u0010[\u001a\u00020$J\u0006\u0010\\\u001a\u00020$J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010=\u001a\u00020<J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010C\u001a\u00020BJ\u000e\u0010H\u001a\u00020\u00002\u0006\u0010H\u001a\u00020<R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R+\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R+\u0010*\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\f\"\u0004\b5\u0010\u000eR\u001a\u00106\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\f\"\u0004\b8\u0010\u000eR\u001a\u00109\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\f\"\u0004\b;\u0010\u000eR$\u0010=\u001a\u00020<2\u0006\u0010\u000f\u001a\u00020<@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR$\u0010C\u001a\u00020B2\u0006\u0010\u000f\u001a\u00020B@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010H\u001a\u00020<2\u0006\u0010\u000f\u001a\u00020<@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010?\"\u0004\bJ\u0010A\u00a8\u0006^"}, d2={"Ldorkbox/notify/Notify;", "", "()V", "attachedFrame", "Ljavax/swing/JFrame;", "getAttachedFrame", "()Ljavax/swing/JFrame;", "setAttachedFrame", "(Ljavax/swing/JFrame;)V", "hideAfterDurationInMillis", "", "getHideAfterDurationInMillis", "()I", "setHideAfterDurationInMillis", "(I)V", "value", "", "hideCloseButton", "getHideCloseButton", "()Z", "setHideCloseButton", "(Z)V", "Ljavax/swing/ImageIcon;", "image", "getImage", "()Ljavax/swing/ImageIcon;", "setImage", "(Ljavax/swing/ImageIcon;)V", "notifyPopup", "Ldorkbox/notify/NotifyType;", "getNotifyPopup$Notify", "()Ldorkbox/notify/NotifyType;", "setNotifyPopup$Notify", "(Ldorkbox/notify/NotifyType;)V", "onClickAction", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "getOnClickAction", "()Lkotlin/jvm/functions/Function1;", "setOnClickAction", "(Lkotlin/jvm/functions/Function1;)V", "onCloseAction", "getOnCloseAction", "setOnCloseAction", "position", "Ldorkbox/notify/Position;", "getPosition", "()Ldorkbox/notify/Position;", "setPosition", "(Ldorkbox/notify/Position;)V", "screen", "getScreen", "setScreen", "shakeAmplitude", "getShakeAmplitude", "setShakeAmplitude", "shakeDurationInMillis", "getShakeDurationInMillis", "setShakeDurationInMillis", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "Ldorkbox/notify/Theme;", "theme", "getTheme", "()Ldorkbox/notify/Theme;", "setTheme", "(Ldorkbox/notify/Theme;)V", "title", "getTitle", "setTitle", "attach", "frame", "close", "hideAfter", "durationInMillis", "Ljava/awt/Image;", "onClickAction$Notify", "onAction", "onClose", "onClose$Notify", "screenNumber", "shake", "amplitude", "show", "showConfirm", "showError", "showInformation", "showWarning", "Companion", "Notify"})
public final class Notify {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile NotifyType<?> notifyPopup;
    @NotNull
    private volatile String title = "Notification";
    @NotNull
    private volatile String text = "Lorem ipsum";
    @NotNull
    private volatile Theme theme = Theme.Companion.getDefaultLight();
    @NotNull
    private volatile Position position = Position.BOTTOM_RIGHT;
    private volatile int hideAfterDurationInMillis;
    private volatile boolean hideCloseButton;
    private volatile int screen = Short.MIN_VALUE;
    @Nullable
    private volatile ImageIcon image;
    @NotNull
    private volatile Function1<? super Notify, Unit> onCloseAction = onCloseAction.1.INSTANCE;
    @NotNull
    private volatile Function1<? super Notify, Unit> onClickAction = onClickAction.1.INSTANCE;
    private volatile int shakeDurationInMillis;
    private volatile int shakeAmplitude;
    @Nullable
    private volatile JFrame attachedFrame;
    @NotNull
    public static final String DIALOG_CONFIRM = "dialog-confirm.png";
    @NotNull
    public static final String DIALOG_INFORMATION = "dialog-information.png";
    @NotNull
    public static final String DIALOG_WARNING = "dialog-warning.png";
    @NotNull
    public static final String DIALOG_ERROR = "dialog-error.png";
    @Property
    private static int WIDTH = 300;
    @Property
    private static int HEIGHT = 87;
    @Property
    private static int SPACER = 10;
    @Property
    private static int MARGIN = 20;
    @Property
    @NotNull
    private static String TITLE_TEXT_FONT = "Source Code Pro BOLD 16";
    @Property
    @NotNull
    private static String MAIN_TEXT_FONT = "Source Code Pro BOLD 12";
    @Property
    private static float MOVE_DURATION = 1.0f;
    @Property
    @NotNull
    private static String IMAGE_PATH = "resources";
    @NotNull
    private static final Map<String, SoftReference<ImageIcon>> imageCache = new LinkedHashMap();
    @NotNull
    public static final String version = "4.2";

    private Notify() {
    }

    @Nullable
    public final NotifyType<?> getNotifyPopup$Notify() {
        return this.notifyPopup;
    }

    public final void setNotifyPopup$Notify(@Nullable NotifyType<?> notifyType) {
        this.notifyPopup = notifyType;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.title = value;
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.text = value;
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
    }

    @NotNull
    public final Theme getTheme() {
        return this.theme;
    }

    public final void setTheme(@NotNull Theme value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.theme = value;
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"<set-?>");
        this.position = position;
    }

    public final int getHideAfterDurationInMillis() {
        return this.hideAfterDurationInMillis;
    }

    public final void setHideAfterDurationInMillis(int n) {
        this.hideAfterDurationInMillis = n;
    }

    public final boolean getHideCloseButton() {
        return this.hideCloseButton;
    }

    public final void setHideCloseButton(boolean value) {
        block0: {
            this.hideCloseButton = value;
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
    }

    public final int getScreen() {
        return this.screen;
    }

    public final void setScreen(int n) {
        this.screen = n;
    }

    @Nullable
    public final ImageIcon getImage() {
        return this.image;
    }

    public final void setImage(@Nullable ImageIcon value) {
        block0: {
            this.image = value;
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
    }

    @NotNull
    public final Function1<Notify, Unit> getOnCloseAction() {
        return this.onCloseAction;
    }

    public final void setOnCloseAction(@NotNull Function1<? super Notify, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onCloseAction = function1;
    }

    @NotNull
    public final Function1<Notify, Unit> getOnClickAction() {
        return this.onClickAction;
    }

    public final void setOnClickAction(@NotNull Function1<? super Notify, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onClickAction = function1;
    }

    public final int getShakeDurationInMillis() {
        return this.shakeDurationInMillis;
    }

    public final void setShakeDurationInMillis(int n) {
        this.shakeDurationInMillis = n;
    }

    public final int getShakeAmplitude() {
        return this.shakeAmplitude;
    }

    public final void setShakeAmplitude(int n) {
        this.shakeAmplitude = n;
    }

    @Nullable
    public final JFrame getAttachedFrame() {
        return this.attachedFrame;
    }

    public final void setAttachedFrame(@Nullable JFrame jFrame) {
        this.attachedFrame = jFrame;
    }

    @NotNull
    public final Notify text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setText(text);
        return this;
    }

    @NotNull
    public final Notify title(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.setTitle(title);
        return this;
    }

    @NotNull
    public final Notify image(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = ImageUtil.getBufferedImage((Image)image);
        bufferedImage = width > height ? ImageUtil.resizeImage((BufferedImage)bufferedImage, (int)48, (int)-1) : ImageUtil.resizeImage((BufferedImage)bufferedImage, (int)-1, (int)48);
        bufferedImage = ImageUtil.clampMaxImageSize((BufferedImage)bufferedImage, (int)48);
        bufferedImage = ImageUtil.getSquareBufferedImage((Image)bufferedImage);
        this.setImage(new ImageIcon(bufferedImage));
        return this;
    }

    @NotNull
    public final Notify position(@NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        this.position = position;
        return this;
    }

    @NotNull
    public final Notify hideAfter(int durationInMillis) {
        this.hideAfterDurationInMillis = durationInMillis < 0 ? 0 : durationInMillis;
        return this;
    }

    @NotNull
    public final Notify onCloseAction(@NotNull Function1<? super Notify, Unit> onAction) {
        Intrinsics.checkNotNullParameter(onAction, (String)"onAction");
        this.onCloseAction = onAction;
        return this;
    }

    @NotNull
    public final Notify onClickAction(@NotNull Function1<? super Notify, Unit> onAction) {
        Intrinsics.checkNotNullParameter(onAction, (String)"onAction");
        this.onClickAction = onAction;
        return this;
    }

    @NotNull
    public final Notify theme(@NotNull Theme theme) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            this.setTheme(theme);
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
        return this;
    }

    @NotNull
    public final Notify hideCloseButton() {
        block0: {
            this.setHideCloseButton(true);
            NotifyType<?> notifyType = this.notifyPopup;
            if (notifyType == null) break block0;
            notifyType.refresh();
        }
        return this;
    }

    public final void showWarning() {
        this.setImage(Notify.Companion.getImage(DIALOG_WARNING));
        this.show();
    }

    public final void showInformation() {
        this.setImage(Notify.Companion.getImage(DIALOG_INFORMATION));
        this.show();
    }

    public final void showError() {
        this.setImage(Notify.Companion.getImage(DIALOG_ERROR));
        this.show();
    }

    public final void showConfirm() {
        this.setImage(Notify.Companion.getImage(DIALOG_CONFIRM));
        this.show();
    }

    public final void show() {
        Notify notify = this;
        SwingUtil.INSTANCE.invokeAndWaitQuietly(() -> Notify.show$lambda$0(notify));
    }

    @NotNull
    public final Notify shake(int durationInMillis, int amplitude) {
        this.shakeDurationInMillis = durationInMillis;
        this.shakeAmplitude = amplitude;
        NotifyType<?> popup = this.notifyPopup;
        if (popup != null) {
            SwingUtil.INSTANCE.invokeLater(() -> Notify.shake$lambda$1(popup, durationInMillis, amplitude));
        }
        return this;
    }

    public static /* synthetic */ Notify shake$default(Notify notify, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 2000;
        }
        if ((n3 & 2) != 0) {
            n2 = 4;
        }
        return notify.shake(n, n2);
    }

    public final void close() {
        NotifyType<?> popup = this.notifyPopup;
        if (popup != null) {
            SwingUtil.INSTANCE.invokeLater(() -> Notify.close$lambda$2(popup));
        }
    }

    @NotNull
    public final Notify setScreen(int screenNumber) {
        this.screen = screenNumber;
        return this;
    }

    @NotNull
    public final Notify attach(@Nullable JFrame frame) {
        this.attachedFrame = frame;
        return this;
    }

    public final void onClose$Notify() {
        if (this.notifyPopup != null) {
            NotifyType<?> notifyType = this.notifyPopup;
            Intrinsics.checkNotNull(notifyType);
            notifyType.close();
            SwingUtil.INSTANCE.invokeLater(() -> Notify.onClose$lambda$3(this));
        }
        this.notifyPopup = null;
    }

    public final void onClickAction$Notify() {
        SwingUtil.INSTANCE.invokeLater(() -> Notify.onClickAction$lambda$4(this));
    }

    private static final void show$lambda$0(Notify $notify) {
        Intrinsics.checkNotNullParameter((Object)$notify, (String)"$notify");
        if ($notify.notifyPopup != null) {
            return;
        }
        JFrame window = $notify.attachedFrame;
        int shakeDuration = $notify.shakeDurationInMillis;
        int shakeAmp = $notify.shakeAmplitude;
        Component notifyPopup = window == null ? new DesktopNotify($notify) : new AppNotify($notify);
        ((NotifyType)((Object)notifyPopup)).setVisible(true);
        if (shakeDuration > 0) {
            ((NotifyType)((Object)notifyPopup)).shake(shakeDuration, shakeAmp);
        }
        $notify.notifyPopup = notifyPopup;
    }

    private static final void shake$lambda$1(NotifyType $popup, int $durationInMillis, int $amplitude) {
        $popup.shake($durationInMillis, $amplitude);
    }

    private static final void close$lambda$2(NotifyType $popup) {
        $popup.close();
    }

    private static final void onClose$lambda$3(Notify this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onCloseAction.invoke((Object)this$0);
    }

    private static final void onClickAction$lambda$4(Notify this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onClickAction.invoke((Object)this$0);
    }

    public /* synthetic */ Notify(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Updates.INSTANCE.add(Notify.class, "8916aaf704e6457ba139cdd501e41797", version);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010/\u001a\u000200J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u0004H\u0002J\u0016\u00103\u001a\u0002042\u0006\u00102\u001a\u00020\u00042\u0006\u00105\u001a\u000206R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001e\u0010\u0019\u001a\u00020\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000b\"\u0004\b!\u0010\rR\u001e\u0010\"\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u001e\u0010%\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\rR \u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000bR\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ldorkbox/notify/Notify$Companion;", "", "()V", "DIALOG_CONFIRM", "", "DIALOG_ERROR", "DIALOG_INFORMATION", "DIALOG_WARNING", "HEIGHT", "", "getHEIGHT", "()I", "setHEIGHT", "(I)V", "IMAGE_PATH", "getIMAGE_PATH", "()Ljava/lang/String;", "setIMAGE_PATH", "(Ljava/lang/String;)V", "MAIN_TEXT_FONT", "getMAIN_TEXT_FONT", "setMAIN_TEXT_FONT", "MARGIN", "getMARGIN", "setMARGIN", "MOVE_DURATION", "", "getMOVE_DURATION", "()F", "setMOVE_DURATION", "(F)V", "SPACER", "getSPACER", "setSPACER", "TITLE_TEXT_FONT", "getTITLE_TEXT_FONT", "setTITLE_TEXT_FONT", "WIDTH", "getWIDTH", "setWIDTH", "imageCache", "", "Ljava/lang/ref/SoftReference;", "Ljavax/swing/ImageIcon;", "imageSize", "getImageSize", "version", "create", "Ldorkbox/notify/Notify;", "getImage", "imageName", "overrideDefaultImage", "", "image", "Ljava/awt/image/BufferedImage;", "Notify"})
    public static final class Companion {
        private Companion() {
        }

        public final int getWIDTH() {
            return WIDTH;
        }

        public final void setWIDTH(int n) {
            WIDTH = n;
        }

        public final int getHEIGHT() {
            return HEIGHT;
        }

        public final void setHEIGHT(int n) {
            HEIGHT = n;
        }

        public final int getSPACER() {
            return SPACER;
        }

        public final void setSPACER(int n) {
            SPACER = n;
        }

        public final int getMARGIN() {
            return MARGIN;
        }

        public final void setMARGIN(int n) {
            MARGIN = n;
        }

        @NotNull
        public final String getTITLE_TEXT_FONT() {
            return TITLE_TEXT_FONT;
        }

        public final void setTITLE_TEXT_FONT(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            TITLE_TEXT_FONT = string;
        }

        @NotNull
        public final String getMAIN_TEXT_FONT() {
            return MAIN_TEXT_FONT;
        }

        public final void setMAIN_TEXT_FONT(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            MAIN_TEXT_FONT = string;
        }

        public final float getMOVE_DURATION() {
            return MOVE_DURATION;
        }

        public final void setMOVE_DURATION(float f) {
            MOVE_DURATION = f;
        }

        @NotNull
        public final String getIMAGE_PATH() {
            return IMAGE_PATH;
        }

        public final void setIMAGE_PATH(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            IMAGE_PATH = string;
        }

        @NotNull
        public final Notify create() {
            return new Notify(null);
        }

        public final int getImageSize() {
            return 48;
        }

        public final void overrideDefaultImage(@NotNull String imageName, @NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            if (imageCache.containsKey(imageName)) {
                throw new RuntimeException("Unable to set an image that already has been set. This action must be done as soon as possible.");
            }
            ImageUtil.waitForImageLoad((Image)image);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            BufferedImage bufferedImage = width > height ? ImageUtil.resizeImage((BufferedImage)image, (int)this.getImageSize(), (int)-1) : ImageUtil.resizeImage((BufferedImage)image, (int)-1, (int)this.getImageSize());
            imageCache.put(imageName, new SoftReference<ImageIcon>(new ImageIcon(bufferedImage)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ImageIcon getImage(String imageName) {
            InputStream resourceAsStream = null;
            SoftReference softReference = (SoftReference)imageCache.get(imageName);
            ImageIcon image = softReference != null ? (ImageIcon)softReference.get() : null;
            try {
                if (image == null) {
                    resourceAsStream = LocationResolver.Companion.getResourceAsStream(imageName);
                    image = new ImageIcon(ImageIO.read(resourceAsStream));
                    imageCache.put(imageName, new SoftReference<ImageIcon>(image));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                InputStream inputStream = resourceAsStream;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            ImageIcon imageIcon = image;
            Intrinsics.checkNotNull((Object)imageIcon);
            return imageIcon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

