/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.LAFUtil;
import dorkbox.notify.Notify;
import dorkbox.notify.Theme;
import dorkbox.swingActiveRender.SwingActiveRender;
import dorkbox.tweenEngine.Tween;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u0000 M*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001MJ\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020)H\u0016J\b\u0010,\u001a\u00020)H&J \u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H&J\b\u00102\u001a\u00020)H&J*\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0018\u0010;\u001a\u0002042\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004H&J\u0010\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020=H&J\b\u0010C\u001a\u00020)H&J\u0010\u0010D\u001a\u00020)2\u0006\u0010@\u001a\u000200H&J\u0018\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0004H\u0016J&\u0010H\u001a\u00020)2\u0006\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010B\u001a\u00020=H\u0016J&\u0010L\u001a\u00020)2\u0006\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010B\u001a\u00020=H\u0016R\u0018\u0010\u0003\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0006\"\u0004\b!\u0010\bR\u0018\u0010\"\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u0006\"\u0004\b$\u0010\bR \u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u000f\"\u0004\b'\u0010\u0011\u00a8\u0006N"}, d2={"Ldorkbox/notify/NotifyType;", "T", "", "anchorX", "", "getAnchorX", "()I", "setAnchorX", "(I)V", "anchorY", "getAnchorY", "setAnchorY", "hideTween", "Ldorkbox/tweenEngine/Tween;", "getHideTween", "()Ldorkbox/tweenEngine/Tween;", "setHideTween", "(Ldorkbox/tweenEngine/Tween;)V", "idAndPosition", "", "getIdAndPosition", "()Ljava/lang/String;", "setIdAndPosition", "(Ljava/lang/String;)V", "moveTween", "getMoveTween", "setMoveTween", "notification", "Ldorkbox/notify/Notify;", "getNotification", "()Ldorkbox/notify/Notify;", "popupIndex", "getPopupIndex", "setPopupIndex", "progress", "getProgress", "setProgress", "shakeTween", "getShakeTween", "setShakeTween", "cancelHide", "", "cancelMove", "cancelShake", "close", "doShake", "count", "targetX", "", "targetY", "refresh", "renderBackgroundInfo", "Ljava/awt/image/BufferedImage;", "title", "textBody", "theme", "Ldorkbox/notify/Theme;", "imageIcon", "Ljavax/swing/ImageIcon;", "renderCloseButton", "enabled", "", "setLocationInternal", "x", "y", "setVisible", "visible", "setupHide", "setupMove", "shake", "durationInMillis", "amplitude", "updatePositionsPost", "component", "Ljava/awt/Component;", "notify", "updatePositionsPre", "Companion", "Notify"})
public interface NotifyType<T> {
    @NotNull
    public static final Companion Companion = dorkbox.notify.NotifyType$Companion.$$INSTANCE;
    public static final int closeX = 282;
    public static final int closeY = 2;
    public static final int Y_1 = 7;
    public static final int X_1 = 287;
    public static final int Y_2 = 13;
    public static final int X_2 = 293;

    @NotNull
    public Notify getNotification();

    @Nullable
    public Tween<T> getShakeTween();

    public void setShakeTween(@Nullable Tween<T> var1);

    @Nullable
    public Tween<T> getMoveTween();

    public void setMoveTween(@Nullable Tween<T> var1);

    @Nullable
    public Tween<T> getHideTween();

    public void setHideTween(@Nullable Tween<T> var1);

    @NotNull
    public String getIdAndPosition();

    public void setIdAndPosition(@NotNull String var1);

    public int getPopupIndex();

    public void setPopupIndex(int var1);

    public int getAnchorX();

    public void setAnchorX(int var1);

    public int getAnchorY();

    public void setAnchorY(int var1);

    public int getProgress();

    public void setProgress(int var1);

    @NotNull
    public BufferedImage renderBackgroundInfo(@NotNull String var1, @NotNull String var2, @NotNull Theme var3, @Nullable ImageIcon var4);

    @NotNull
    public BufferedImage renderCloseButton(@NotNull Theme var1, boolean var2);

    public void updatePositionsPre(@NotNull Component var1, @NotNull NotifyType<T> var2, boolean var3);

    public void updatePositionsPost(@NotNull Component var1, @NotNull NotifyType<T> var2, boolean var3);

    public void doShake(int var1, float var2, float var3);

    public void shake(int var1, int var2);

    public void cancelShake();

    public void close();

    public void setVisible(boolean var1);

    public void setLocationInternal(int var1, int var2);

    public void refresh();

    public void setupHide();

    public void cancelHide();

    public void setupMove(float var1);

    public void cancelMove();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldorkbox/notify/NotifyType$Companion;", "", "()V", "X_1", "", "X_2", "Y_1", "Y_2", "closeX", "closeY", "stroke", "Ljava/awt/Stroke;", "Notify"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Stroke stroke;
        public static final int closeX = 282;
        public static final int closeY = 2;
        public static final int Y_1 = 7;
        public static final int X_1 = 287;
        public static final int Y_2 = 13;
        public static final int X_2 = 293;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            stroke = new BasicStroke(2.0f);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public static <T> BufferedImage renderBackgroundInfo(@NotNull NotifyType<T> $this, @NotNull String title, @NotNull String textBody, @NotNull Theme theme, @Nullable ImageIcon imageIcon) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)textBody, (String)"textBody");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            BufferedImage image = new BufferedImage(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            try {
                g2.setColor(theme.getPanel_BG());
                g2.fillRect(0, 0, Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT());
                g2.setColor(theme.getTitleText_FG());
                g2.setFont(theme.getTitleTextFont());
                g2.drawString(title, 5, 20);
                int posX = 10;
                int posY = -8;
                int textLengthLimit = 108;
                if (imageIcon != null) {
                    textLengthLimit = 88;
                    posX = 60;
                    imageIcon.paintIcon(null, g2, 5, 30);
                }
                int length = textBody.length();
                StringBuilder text = new StringBuilder(length);
                if (length >= 13 && StringsKt.regionMatches((String)textBody, (int)(length - 7), (String)"</html>", (int)0, (int)7, (boolean)true)) {
                    text.append(textBody);
                    text.delete(text.length() - 7, text.length());
                    length -= 7;
                } else {
                    text.append("<html>");
                    text.append(textBody);
                }
                if (length > textLengthLimit) {
                    text.delete(6 + textLengthLimit, text.length());
                    text.append("...");
                }
                text.append("</html>");
                JLabel mainTextLabel = new JLabel();
                mainTextLabel.setForeground(theme.getMainText_FG());
                mainTextLabel.setFont(theme.getMainTextFont());
                mainTextLabel.setText(text.toString());
                mainTextLabel.setBounds(0, 0, Notify.Companion.getWIDTH() - posX - 2, Notify.Companion.getHEIGHT());
                g2.translate(posX, posY);
                mainTextLabel.paint(g2);
                g2.translate(-posX, -posY);
            }
            finally {
                g2.dispose();
            }
            return image;
        }

        @NotNull
        public static <T> BufferedImage renderCloseButton(@NotNull NotifyType<T> $this, @NotNull Theme theme, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            BufferedImage image = new BufferedImage(Notify.Companion.getWIDTH(), Notify.Companion.getHEIGHT(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(theme.getPanel_BG());
            g2.setStroke(dorkbox.notify.NotifyType$Companion.stroke);
            if (enabled) {
                g2.setColor(Color.RED);
            } else {
                g2.setColor(theme.getCloseX_FG());
            }
            g2.drawLine(287, 7, 293, 13);
            g2.drawLine(293, 7, 287, 13);
            return image;
        }

        public static <T> void updatePositionsPre(@NotNull NotifyType<T> $this, @NotNull Component component, @NotNull NotifyType<T> notify, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(notify, (String)"notify");
            if (!visible) {
                LAFUtil.INSTANCE.removePopupFromMap(notify);
                SwingActiveRender.INSTANCE.remove(component);
            }
        }

        public static <T> void updatePositionsPost(@NotNull NotifyType<T> $this, @NotNull Component component, @NotNull NotifyType<T> notify, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(notify, (String)"notify");
            if (visible) {
                SwingActiveRender.INSTANCE.add(component);
                LAFUtil.INSTANCE.addPopupToMap(notify);
            }
        }

        public static <T> void shake(@NotNull NotifyType<T> $this, int durationInMillis, int amplitude) {
            int i1 = LAFUtil.INSTANCE.getRANDOM().nextInt((amplitude << 2) + 1) - amplitude;
            int i2 = LAFUtil.INSTANCE.getRANDOM().nextInt((amplitude << 2) + 1) - amplitude;
            i2 >>= 2;
            i1 = (i1 >>= 2) < 0 ? (i1 -= amplitude >> 2) : (i1 += amplitude >> 2);
            i2 = i2 < 0 ? (i2 -= amplitude >> 2) : (i2 += amplitude >> 2);
            int count = durationInMillis / 50;
            if ((count & 1) == 0) {
                ++count;
            }
            $this.doShake(count, i1, i2);
        }

        public static <T> void cancelShake(@NotNull NotifyType<T> $this) {
            if ($this.getShakeTween() != null) {
                Tween<T> tween2 = $this.getShakeTween();
                Intrinsics.checkNotNull(tween2);
                tween2.cancel();
                $this.setShakeTween(null);
            }
        }

        public static <T> void cancelHide(@NotNull NotifyType<T> $this) {
            if ($this.getHideTween() != null) {
                Tween<T> tween2 = $this.getHideTween();
                Intrinsics.checkNotNull(tween2);
                tween2.cancel();
                $this.setHideTween(null);
            }
        }

        public static <T> void cancelMove(@NotNull NotifyType<T> $this) {
            if ($this.getMoveTween() != null) {
                Tween<T> tween2 = $this.getMoveTween();
                Intrinsics.checkNotNull(tween2);
                tween2.cancel();
                $this.setMoveTween(null);
            }
        }
    }
}

