/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.tweenengine;

import dorkbox.tweenengine.TweenCallback;
import dorkbox.tweenengine.TweenManager;
import dorkbox.tweenengine.UpdateAction;
import java.util.Arrays;

public abstract class BaseTween<T> {
    private static volatile long lightSyncObject = System.nanoTime();
    protected static final int INVALID = 0;
    protected static final int START = 1;
    protected static final int RUN = 2;
    protected static final int FINISHED = 3;
    public static final UpdateAction<?> NULL_ACTION = new UpdateAction<Object>(){

        @Override
        public void onEvent(Object tween) {
        }
    };
    protected int state = 0;
    protected int repeatCountOrig;
    private int repeatCount;
    protected boolean canAutoReverse;
    private boolean isPaused;
    protected boolean isCanceled;
    protected boolean isInitialized;
    private float startDelay;
    private float repeatDelay;
    protected float duration;
    protected float currentTime;
    private static final boolean START_VALUES = true;
    private static final boolean TARGET_VALUES = false;
    private static final boolean FORWARDS = true;
    private static final boolean REVERSE = false;
    private boolean direction = true;
    private boolean canTriggerBeginEvent;
    protected boolean isInAutoReverse;
    protected boolean isDuringUpdate;
    private Object userData;
    protected boolean isAutoRemoveEnabled;
    protected boolean isAutoStartEnabled;
    private UpdateAction startEventCallback = NULL_ACTION;
    private UpdateAction endEventCallback = NULL_ACTION;
    private static final TweenCallback[] TEMP_EMPTY = new TweenCallback[0];
    private TweenCallback[] forwards_Begin = new TweenCallback[0];
    private TweenCallback[] forwards_Start = new TweenCallback[0];
    private TweenCallback[] forwards_End = new TweenCallback[0];
    private TweenCallback[] forwards_Complete = new TweenCallback[0];
    private TweenCallback[] reverse_Begin = new TweenCallback[0];
    private TweenCallback[] reverse_Start = new TweenCallback[0];
    private TweenCallback[] reverse_End = new TweenCallback[0];
    private TweenCallback[] reverse_Complete = new TweenCallback[0];

    static long flushRead() {
        return lightSyncObject;
    }

    static void flushWrite() {
        lightSyncObject = System.nanoTime();
    }

    protected void reset() {
        this.state = 1;
        this.direction = true;
        this.canTriggerBeginEvent = true;
        this.currentTime = -this.startDelay;
        this.isInAutoReverse = false;
        this.repeatCount = this.repeatCountOrig;
    }

    protected void destroy() {
        this.repeatCountOrig = 0;
        this.repeatCount = 0;
        this.state = 0;
        this.currentTime = 0.0f;
        this.repeatDelay = 0.0f;
        this.startDelay = 0.0f;
        this.duration = 0.0f;
        this.isInitialized = false;
        this.isDuringUpdate = false;
        this.isInAutoReverse = false;
        this.isCanceled = false;
        this.isPaused = false;
        this.canTriggerBeginEvent = true;
        this.clearCallbacks_();
        this.userData = null;
        this.endEventCallback = this.startEventCallback = NULL_ACTION;
        this.isAutoStartEnabled = true;
        this.isAutoRemoveEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T clearCallbacks() {
        TweenCallback[] tweenCallbackArray = TEMP_EMPTY;
        synchronized (TEMP_EMPTY) {
            this.clearCallbacks_();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (T)this;
        }
    }

    private void clearCallbacks_() {
        this.forwards_Begin = new TweenCallback[0];
        this.forwards_Start = new TweenCallback[0];
        this.forwards_End = new TweenCallback[0];
        this.forwards_Complete = new TweenCallback[0];
        this.reverse_Begin = new TweenCallback[0];
        this.reverse_Start = new TweenCallback[0];
        this.reverse_End = new TweenCallback[0];
        this.reverse_Complete = new TweenCallback[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T addCallback(TweenCallback callback) {
        int triggers = callback.triggers;
        TweenCallback[] tweenCallbackArray = TEMP_EMPTY;
        synchronized (TEMP_EMPTY) {
            TweenCallback[] newEvents;
            int currentLength;
            if ((triggers & 1) == 1) {
                currentLength = this.forwards_Begin.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.forwards_Begin, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.forwards_Begin = newEvents;
            }
            if ((triggers & 2) == 2) {
                currentLength = this.forwards_Start.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.forwards_Start, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.forwards_Start = newEvents;
            }
            if ((triggers & 4) == 4) {
                currentLength = this.forwards_End.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.forwards_End, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.forwards_End = newEvents;
            }
            if ((triggers & 8) == 8) {
                currentLength = this.forwards_Complete.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.forwards_Complete, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.forwards_Complete = newEvents;
            }
            if ((triggers & 0x10) == 16) {
                currentLength = this.reverse_Begin.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.reverse_Begin, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.reverse_Begin = newEvents;
            }
            if ((triggers & 0x20) == 32) {
                currentLength = this.reverse_Start.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.reverse_Start, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.reverse_Start = newEvents;
            }
            if ((triggers & 0x40) == 64) {
                currentLength = this.reverse_End.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.reverse_End, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.reverse_End = newEvents;
            }
            if ((triggers & 0x80) == 128) {
                currentLength = this.reverse_Complete.length;
                newEvents = (TweenCallback[])Arrays.copyOf(this.reverse_Complete, currentLength + 1, TweenCallback[].class);
                newEvents[currentLength] = callback;
                this.reverse_Complete = newEvents;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (T)this;
        }
    }

    public T delay(float delay) {
        BaseTween.flushRead();
        this.startDelay += delay;
        this.currentTime -= delay;
        BaseTween.flushWrite();
        return (T)this;
    }

    public void cancel() {
        this.isCanceled = true;
        BaseTween.flushWrite();
    }

    public void free() {
    }

    public void pause() {
        this.isPaused = true;
        BaseTween.flushWrite();
    }

    public void resume() {
        this.isPaused = false;
        BaseTween.flushWrite();
    }

    public T repeat(int count, float delay) {
        if (count < -1) {
            throw new RuntimeException("Count " + count + " is an invalid option. It must be -1 (Tween.INFINITY) for infinite or > 0 for " + "finite.");
        }
        this.repeatCountOrig = count;
        this.repeatCount = count;
        this.repeatDelay = delay;
        this.canAutoReverse = false;
        BaseTween.flushWrite();
        return (T)this;
    }

    public T repeatAutoReverse(int count, float delay) {
        this.repeat(count, delay);
        this.canAutoReverse = true;
        BaseTween.flushWrite();
        return (T)this;
    }

    public final T setStartCallback(UpdateAction<T> startCallback) {
        if (startCallback == null) {
            throw new RuntimeException("Callback cannot be null! Use BaseTween.NULL_ACTION if you wish to 'unset' the callback");
        }
        this.startEventCallback = startCallback;
        BaseTween.flushWrite();
        return (T)this;
    }

    public final T setEndCallback(UpdateAction<T> endCallback) {
        if (endCallback == null) {
            throw new RuntimeException("Callback cannot be null! Use BaseTween.NULL_ACTION if you wish to 'unset' the callback");
        }
        this.endEventCallback = endCallback;
        BaseTween.flushWrite();
        return (T)this;
    }

    protected void setup() {
        this.canTriggerBeginEvent = true;
        this.state = 1;
    }

    public T start() {
        this.setup();
        BaseTween.flushWrite();
        return (T)this;
    }

    public T start(TweenManager manager) {
        manager.add(this);
        BaseTween.flushWrite();
        return (T)this;
    }

    public final float getCurrentTime() {
        BaseTween.flushRead();
        return this.currentTime;
    }

    public final float getStartDelay() {
        BaseTween.flushRead();
        return this.startDelay;
    }

    public float getDuration() {
        BaseTween.flushRead();
        return this.duration;
    }

    public float getFullDuration() {
        BaseTween.flushRead();
        return this.getFullDuration__();
    }

    final float getFullDuration__() {
        if (this.repeatCountOrig < 0) {
            return -1.0f;
        }
        return this.startDelay + this.duration + (this.repeatDelay + this.duration) * (float)this.repeatCountOrig;
    }

    public final int getRepeatCount() {
        BaseTween.flushRead();
        return this.repeatCountOrig;
    }

    public final float getRepeatDelay() {
        BaseTween.flushRead();
        return this.repeatDelay;
    }

    public final boolean getDirection() {
        BaseTween.flushRead();
        return this.direction;
    }

    public final boolean isInDelay() {
        BaseTween.flushRead();
        return this.state == 1;
    }

    public final boolean isInAutoReverse() {
        BaseTween.flushRead();
        return this.isInAutoReverse;
    }

    public boolean isInitialized() {
        BaseTween.flushRead();
        return this.isInitialized;
    }

    public boolean isFinished() {
        BaseTween.flushRead();
        return this.isFinished__();
    }

    final boolean isFinished__() {
        return this.state == 3 || this.isCanceled;
    }

    public boolean canAutoReverse() {
        BaseTween.flushRead();
        return this.canAutoReverse;
    }

    public boolean isPaused() {
        BaseTween.flushRead();
        return this.isPaused;
    }

    public T setUserData(Object data) {
        this.userData = data;
        BaseTween.flushWrite();
        return (T)this;
    }

    public T getUserData() {
        BaseTween.flushRead();
        return (T)this.userData;
    }

    protected abstract boolean containsTarget(Object var1);

    protected abstract boolean containsTarget(Object var1, int var2);

    protected abstract void update(boolean var1, float var2);

    protected abstract void setValues(boolean var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(float percentage, boolean direction) {
        if (percentage < -0.0f || percentage > 1.0f) {
            throw new RuntimeException("Cannot set the progress <0 or >1");
        }
        TweenCallback[] tweenCallbackArray = TEMP_EMPTY;
        synchronized (TEMP_EMPTY) {
            float adjustmentTime;
            boolean goesReverse;
            this.reset();
            float duration = this.duration;
            float percentageValue = duration * percentage;
            boolean bl = goesReverse = !direction && this.canAutoReverse;
            if (goesReverse) {
                float timeSpentToGetToEnd = duration + this.startDelay;
                float timeSpentInReverseFromEnd = duration - percentageValue;
                adjustmentTime = timeSpentToGetToEnd + timeSpentInReverseFromEnd;
            } else {
                adjustmentTime = percentageValue + this.startDelay;
            }
            TweenCallback[] forwards_Begin_saved = this.forwards_Begin;
            TweenCallback[] forwards_Start_saved = this.forwards_Start;
            TweenCallback[] forwards_End_saved = this.forwards_End;
            TweenCallback[] forwards_Complete_saved = this.forwards_Complete;
            TweenCallback[] reverse_Begin_saved = this.reverse_Begin;
            TweenCallback[] reverse_Start_saved = this.reverse_Start;
            TweenCallback[] reverse_End_saved = this.reverse_End;
            TweenCallback[] reverse_Complete_saved = this.reverse_Complete;
            this.forwards_Begin = TEMP_EMPTY;
            this.forwards_Start = TEMP_EMPTY;
            this.forwards_End = TEMP_EMPTY;
            this.forwards_Complete = TEMP_EMPTY;
            this.reverse_Begin = TEMP_EMPTY;
            this.reverse_Start = TEMP_EMPTY;
            this.reverse_End = TEMP_EMPTY;
            this.reverse_Complete = TEMP_EMPTY;
            this.update__(adjustmentTime);
            this.forwards_Begin = forwards_Begin_saved;
            this.forwards_Start = forwards_Start_saved;
            this.forwards_End = forwards_End_saved;
            this.forwards_Complete = forwards_Complete_saved;
            this.reverse_Begin = reverse_Begin_saved;
            this.reverse_Start = reverse_Start_saved;
            this.reverse_End = reverse_End_saved;
            this.reverse_Complete = reverse_Complete_saved;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void initializeValues() {
    }

    protected boolean killTarget(Object target) {
        if (this.containsTarget(target)) {
            this.cancel();
            return true;
        }
        return false;
    }

    protected boolean killTarget(Object target, int tweenType) {
        if (this.containsTarget(target, tweenType)) {
            this.cancel();
            return true;
        }
        return false;
    }

    protected void adjustForRepeat_AutoReverse(boolean newDirection) {
        this.state = 1;
        this.currentTime = newDirection ? 0.0f : this.duration;
    }

    protected void adjustForRepeat_Linear(boolean newDirection) {
        this.state = 1;
        this.currentTime = newDirection ? 0.0f : this.duration;
    }

    public final float update(float delta) {
        BaseTween.flushRead();
        float v = this.update__(delta);
        BaseTween.flushWrite();
        return v;
    }

    protected final float update__(float delta) {
        boolean direction;
        this.isDuringUpdate = true;
        if (this.isPaused || this.isCanceled) {
            return delta;
        }
        if (this.isInAutoReverse) {
            delta = -delta;
        }
        this.direction = direction = delta >= 0.0f;
        float duration = this.duration;
        this.startEventCallback.onEvent(this);
        block10: while (true) {
            TweenCallback[] callbacks;
            int i;
            int n;
            int n2;
            int repeatCountStack;
            float newTime = this.currentTime + delta;
            if (direction) {
                switch (this.state) {
                    case 1: {
                        int i2;
                        int n3;
                        TweenCallback[] callbacks2;
                        if (newTime <= 0.0f) {
                            this.currentTime = newTime;
                            this.isDuringUpdate = false;
                            this.endEventCallback.onEvent(this);
                            return 0.0f;
                        }
                        this.currentTime = 0.0f;
                        if (this.canTriggerBeginEvent) {
                            this.canTriggerBeginEvent = false;
                            if (!this.isInitialized) {
                                this.isInitialized = true;
                                this.initializeValues();
                            }
                            callbacks2 = this.forwards_Begin;
                            n3 = callbacks2.length;
                            for (i2 = 0; i2 < n3; ++i2) {
                                callbacks2[i2].onEvent(1, this);
                            }
                        }
                        callbacks2 = this.forwards_Start;
                        n3 = callbacks2.length;
                        for (i2 = 0; i2 < n3; ++i2) {
                            callbacks2[i2].onEvent(2, this);
                        }
                        this.state = 2;
                        this.setValues(false, true);
                        delta = newTime;
                    }
                    case 2: {
                        int i3;
                        if (newTime <= duration) {
                            this.currentTime = newTime;
                            this.update(true, delta);
                            this.isDuringUpdate = false;
                            this.endEventCallback.onEvent(this);
                            return 0.0f;
                        }
                        this.state = 3;
                        this.currentTime = duration;
                        if ((repeatCountStack = this.repeatCount--) == 0) {
                            this.setValues(false, false);
                            TweenCallback[] callbacks3 = this.forwards_End;
                            n2 = callbacks3.length;
                            for (i3 = 0; i3 < n2; ++i3) {
                                callbacks3[i3].onEvent(4, this);
                            }
                            TweenCallback[] callbacks2 = this.forwards_Complete;
                            n = callbacks2.length;
                            for (i = 0; i < n; ++i) {
                                callbacks2[i].onEvent(8, this);
                            }
                            this.canTriggerBeginEvent = true;
                            this.isInAutoReverse = false;
                            this.repeatCount = this.repeatCountOrig;
                            this.isDuringUpdate = false;
                            this.endEventCallback.onEvent(this);
                            return newTime - duration;
                        }
                        this.update(true, delta);
                        if (repeatCountStack > 0) {
                            // empty if block
                        }
                        callbacks = this.forwards_End;
                        n2 = callbacks.length;
                        for (i3 = 0; i3 < n2; ++i3) {
                            callbacks[i3].onEvent(4, this);
                        }
                        if (this.canAutoReverse) {
                            TweenCallback[] callbacks2 = this.forwards_Complete;
                            n = callbacks2.length;
                            for (i = 0; i < n; ++i) {
                                callbacks2[i].onEvent(8, this);
                            }
                            this.canTriggerBeginEvent = true;
                            this.isInAutoReverse = !this.isInAutoReverse;
                            direction = false;
                            this.adjustForRepeat_AutoReverse(false);
                            this.currentTime += this.repeatDelay;
                            delta = -newTime + duration;
                            continue block10;
                        }
                        this.isInAutoReverse = false;
                        this.adjustForRepeat_Linear(true);
                        delta = newTime - duration;
                        this.currentTime = -this.repeatDelay + delta;
                        continue block10;
                    }
                    case 3: {
                        if (newTime <= 0.0f || newTime > duration) {
                            this.currentTime = newTime;
                            this.isDuringUpdate = false;
                            this.endEventCallback.onEvent(this);
                            return 0.0f;
                        }
                        this.state = 1;
                        this.update(true, delta);
                        continue block10;
                    }
                }
                throw new RuntimeException("Unexpected state!! '" + this.state + "'");
            }
            switch (this.state) {
                case 1: {
                    if (newTime >= duration) {
                        this.currentTime = newTime;
                        this.isDuringUpdate = false;
                        this.endEventCallback.onEvent(this);
                        return 0.0f;
                    }
                    this.currentTime = duration;
                    if (this.canTriggerBeginEvent) {
                        this.canTriggerBeginEvent = false;
                        if (!this.isInitialized) {
                            this.isInitialized = true;
                            this.initializeValues();
                        }
                        TweenCallback[] callbacks4 = this.reverse_Begin;
                        int n4 = callbacks4.length;
                        for (int i4 = 0; i4 < n4; ++i4) {
                            callbacks4[i4].onEvent(16, this);
                        }
                    }
                    TweenCallback[] callbacks5 = this.reverse_Start;
                    int n5 = callbacks5.length;
                    for (int i5 = 0; i5 < n5; ++i5) {
                        callbacks5[i5].onEvent(32, this);
                    }
                    this.state = 2;
                    this.setValues(true, false);
                    delta = -(duration - newTime);
                }
                case 2: {
                    if (newTime >= 0.0f) {
                        this.currentTime = newTime;
                        this.update(false, delta);
                        this.isDuringUpdate = false;
                        this.endEventCallback.onEvent(this);
                        return 0.0f;
                    }
                    this.state = 3;
                    this.currentTime = 0.0f;
                    if ((repeatCountStack = this.repeatCount--) == 0) {
                        if (duration <= 1.0E-6f) {
                            this.setValues(true, false);
                        } else {
                            this.setValues(true, true);
                        }
                        TweenCallback[] callbacks6 = this.reverse_End;
                        n2 = callbacks6.length;
                        for (int i6 = 0; i6 < n2; ++i6) {
                            callbacks6[i6].onEvent(64, this);
                        }
                        TweenCallback[] callbacks2 = this.reverse_Complete;
                        n = callbacks2.length;
                        for (i = 0; i < n; ++i) {
                            callbacks2[i].onEvent(128, this);
                        }
                        this.canTriggerBeginEvent = true;
                        this.isInAutoReverse = false;
                        this.repeatCount = this.repeatCountOrig;
                        this.isDuringUpdate = false;
                        this.endEventCallback.onEvent(this);
                        return newTime;
                    }
                    this.update(false, delta);
                    if (repeatCountStack > 0) {
                        // empty if block
                    }
                    callbacks = this.reverse_End;
                    n2 = callbacks.length;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        callbacks[i7].onEvent(64, this);
                    }
                    if (this.canAutoReverse) {
                        TweenCallback[] callbacks2 = this.reverse_Complete;
                        n = callbacks2.length;
                        for (i = 0; i < n; ++i) {
                            callbacks2[i].onEvent(128, this);
                        }
                        this.canTriggerBeginEvent = true;
                        this.isInAutoReverse = !this.isInAutoReverse;
                        direction = true;
                        this.adjustForRepeat_AutoReverse(true);
                        this.currentTime -= this.repeatDelay;
                        delta = -newTime;
                        continue block10;
                    }
                    this.isInAutoReverse = false;
                    this.adjustForRepeat_Linear(false);
                    this.currentTime = this.repeatDelay + newTime;
                    continue block10;
                }
                case 3: {
                    if (newTime < 0.0f || newTime >= duration) {
                        this.currentTime = newTime;
                        this.isDuringUpdate = false;
                        this.endEventCallback.onEvent(this);
                        return 0.0f;
                    }
                    this.state = 1;
                    this.update(false, delta);
                    continue block10;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected state!! '" + this.state + "'");
    }
}

