/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.tweenengine;

import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import dorkbox.tweenengine.BaseTween;
import dorkbox.tweenengine.TweenAccessor;
import dorkbox.tweenengine.TweenCallback;
import dorkbox.tweenengine.TweenEquation;
import dorkbox.tweenengine.TweenEquations;
import dorkbox.tweenengine.TweenPath;
import dorkbox.tweenengine.TweenPaths;
import dorkbox.util.Version;
import java.util.HashMap;
import java.util.Map;

public final class Tween
extends BaseTween<Tween> {
    public static final int INFINITY = -1;
    private static int combinedAttrsLimit = 3;
    private static int waypointsLimit = 0;
    private static final PoolableObject<Tween> poolableObject = new PoolableObject<Tween>(){

        public void onTake(Tween object) {
            object.destroy();
        }

        public Tween create() {
            return new Tween();
        }
    };
    private static final ObjectPool<Tween> pool = ObjectPool.NonBlockingSoftReference(poolableObject);
    private static final Map<Class<?>, TweenAccessor<?>> registeredAccessors = new HashMap();
    private Object target;
    private Class<?> targetClass;
    private TweenAccessor accessor;
    private int type;
    private TweenEquation equation;
    private TweenPath path;
    private boolean isFrom;
    private boolean isRelative;
    private int combinedAttrsCnt;
    private int waypointsCount;
    private final float[] startValues = new float[combinedAttrsLimit];
    private final float[] targetValues = new float[combinedAttrsLimit];
    private final float[] waypoints = new float[waypointsLimit * combinedAttrsLimit];
    private final float[] accessorBuffer = new float[combinedAttrsLimit];
    private final float[] pathBuffer = new float[(2 + waypointsLimit) * combinedAttrsLimit];

    public static Version getVersion() {
        return new Version("7.15");
    }

    public static void setCombinedAttributesLimit(int limit) {
        combinedAttrsLimit = limit;
        Tween.flushWrite();
    }

    public static void setWaypointsLimit(int limit) {
        waypointsLimit = limit;
        Tween.flushWrite();
    }

    public static void registerAccessor(Class<?> someClass, TweenAccessor<?> defaultAccessor) {
        registeredAccessors.put(someClass, defaultAccessor);
        Tween.flushWrite();
    }

    public static TweenAccessor<?> getRegisteredAccessor(Class<?> someClass) {
        Tween.flushRead();
        return registeredAccessors.get(someClass);
    }

    public static Tween to(Object target, int tweenType, float duration) {
        return Tween.to(target, tweenType, null, duration);
    }

    public static <T> Tween to(T target, int tweenType, TweenAccessor<T> targetAccessor, float duration) {
        Tween tween = (Tween)pool.take();
        Tween.flushRead();
        tween.setup(target, tweenType, targetAccessor, duration);
        tween.ease(TweenEquations.Quad_InOut);
        tween.path(TweenPaths.CatmullRom);
        Tween.flushWrite();
        return tween;
    }

    public static <T> Tween from(T target, int tweenType, float duration) {
        return Tween.from(target, tweenType, null, duration);
    }

    public static <T> Tween from(T target, int tweenType, TweenAccessor<T> targetAccessor, float duration) {
        Tween tween = (Tween)pool.take();
        Tween.flushRead();
        tween.setup(target, tweenType, targetAccessor, duration);
        tween.ease(TweenEquations.Quad_InOut);
        tween.path(TweenPaths.CatmullRom);
        tween.isFrom = true;
        Tween.flushWrite();
        return tween;
    }

    public static <T> Tween set(T target, int tweenType) {
        return Tween.set(target, tweenType, null);
    }

    public static <T> Tween set(T target, int tweenType, TweenAccessor<T> targetAccessor) {
        Tween tween = (Tween)pool.take();
        Tween.flushRead();
        tween.setup(target, tweenType, targetAccessor, 0.0f);
        tween.ease(TweenEquations.Quad_In);
        Tween.flushWrite();
        return tween;
    }

    public static Tween call(TweenCallback callback) {
        Tween tween = (Tween)pool.take();
        Tween.flushRead();
        tween.setup(null, -1, null, 0.0f);
        callback.triggers = 2;
        tween.addCallback(callback);
        Tween.flushWrite();
        return tween;
    }

    public static Tween mark() {
        Tween tween = (Tween)pool.take();
        Tween.flushRead();
        tween.setup(null, -1, null, 0.0f);
        Tween.flushWrite();
        return tween;
    }

    Tween() {
        this.destroy();
    }

    @Override
    protected void destroy() {
        int i;
        super.destroy();
        this.target = null;
        this.targetClass = null;
        this.accessor = null;
        this.type = -1;
        this.equation = null;
        this.path = null;
        this.isRelative = false;
        this.isFrom = false;
        this.waypointsCount = 0;
        this.combinedAttrsCnt = 0;
        int n = this.startValues.length;
        for (i = 0; i < n; ++i) {
            this.startValues[i] = 0.0f;
        }
        n = this.targetValues.length;
        for (i = 0; i < n; ++i) {
            this.targetValues[i] = 0.0f;
        }
        n = this.waypoints.length;
        for (i = 0; i < n; ++i) {
            this.waypoints[i] = 0.0f;
        }
        n = this.accessorBuffer.length;
        for (i = 0; i < n; ++i) {
            this.accessorBuffer[i] = 0.0f;
        }
        n = this.pathBuffer.length;
        for (i = 0; i < n; ++i) {
            this.pathBuffer[i] = 0.0f;
        }
    }

    private void setup(Object target, int tweenType, TweenAccessor targetAccessor, float duration) {
        if (duration < 0.0f) {
            throw new RuntimeException("Duration can not be negative");
        }
        this.target = target;
        if (targetAccessor != null) {
            this.accessor = targetAccessor;
        } else {
            this.targetClass = target != null ? this.findTargetClass() : null;
        }
        this.type = tweenType;
        this.duration = duration;
        this.setup();
    }

    private Class<?> findTargetClass() {
        Class<?> parentClass;
        Object target = this.target;
        if (target instanceof TweenAccessor) {
            return target.getClass();
        }
        if (registeredAccessors.containsKey(target.getClass())) {
            return target.getClass();
        }
        for (parentClass = target.getClass().getSuperclass(); parentClass != null && !registeredAccessors.containsKey(parentClass); parentClass = parentClass.getSuperclass()) {
        }
        return parentClass;
    }

    public Tween ease(TweenEquation easeEquation) {
        this.equation = easeEquation;
        Tween.flushWrite();
        return this;
    }

    public Tween ease(TweenEquations easeEquation) {
        this.equation = easeEquation.getEquation();
        Tween.flushWrite();
        return this;
    }

    public Tween cast(Class<?> targetClass) {
        Tween.flushRead();
        if (this.isInitialized) {
            throw new RuntimeException("You can't cast the target of a tween once it has been initialized");
        }
        this.targetClass = targetClass;
        Tween.flushWrite();
        return this;
    }

    public Tween target(float targetValue) {
        this.targetValues[0] = targetValue;
        Tween.flushWrite();
        return this;
    }

    public Tween target(float targetValue1, float targetValue2) {
        this.targetValues[0] = targetValue1;
        this.targetValues[1] = targetValue2;
        Tween.flushWrite();
        return this;
    }

    public Tween target(float targetValue1, float targetValue2, float targetValue3) {
        this.targetValues[0] = targetValue1;
        this.targetValues[1] = targetValue2;
        this.targetValues[2] = targetValue3;
        Tween.flushWrite();
        return this;
    }

    public Tween target(float ... targetValues) {
        Tween.flushRead();
        int length = targetValues.length;
        Tween.verifyCombinedAttrs(length);
        System.arraycopy(targetValues, 0, this.targetValues, 0, length);
        Tween.flushWrite();
        return this;
    }

    public Tween targetRelative(float targetValue) {
        Tween.flushRead();
        this.isRelative = true;
        this.targetValues[0] = this.isInitialized ? targetValue + this.startValues[0] : targetValue;
        Tween.flushWrite();
        return this;
    }

    public Tween targetRelative(float targetValue1, float targetValue2) {
        Tween.flushRead();
        this.isRelative = true;
        boolean initialized = this.isInitialized;
        this.targetValues[0] = initialized ? targetValue1 + this.startValues[0] : targetValue1;
        this.targetValues[1] = initialized ? targetValue2 + this.startValues[1] : targetValue2;
        Tween.flushWrite();
        return this;
    }

    public Tween targetRelative(float targetValue1, float targetValue2, float targetValue3) {
        Tween.flushRead();
        this.isRelative = true;
        boolean initialized = this.isInitialized;
        float[] startValues = this.startValues;
        this.targetValues[0] = initialized ? targetValue1 + startValues[0] : targetValue1;
        this.targetValues[1] = initialized ? targetValue2 + startValues[1] : targetValue2;
        this.targetValues[2] = initialized ? targetValue3 + startValues[2] : targetValue3;
        Tween.flushWrite();
        return this;
    }

    public Tween targetRelative(float ... targetValues) {
        Tween.flushRead();
        int length = targetValues.length;
        Tween.verifyCombinedAttrs(length);
        boolean initialized = this.isInitialized;
        float[] startValues = this.startValues;
        for (int i = 0; i < length; ++i) {
            this.targetValues[i] = initialized ? targetValues[i] + startValues[i] : targetValues[i];
        }
        this.isRelative = true;
        Tween.flushWrite();
        return this;
    }

    public Tween waypoint(float targetValue) {
        Tween.flushRead();
        int waypointsCount = this.waypointsCount++;
        Tween.verifyWaypoints(waypointsCount);
        this.waypoints[waypointsCount] = targetValue;
        Tween.flushWrite();
        return this;
    }

    public Tween waypoint(float targetValue1, float targetValue2) {
        Tween.flushRead();
        int waypointsCount = this.waypointsCount++;
        Tween.verifyWaypoints(waypointsCount);
        int count = waypointsCount << 1;
        float[] waypoints = this.waypoints;
        waypoints[count] = targetValue1;
        waypoints[count + 1] = targetValue2;
        Tween.flushWrite();
        return this;
    }

    public Tween waypoint(float targetValue1, float targetValue2, float targetValue3) {
        Tween.flushRead();
        int waypointsCount = this.waypointsCount++;
        Tween.verifyWaypoints(waypointsCount);
        int count = waypointsCount * 3;
        float[] waypoints = this.waypoints;
        waypoints[count] = targetValue1;
        waypoints[count + 1] = targetValue2;
        waypoints[count + 2] = targetValue3;
        Tween.flushWrite();
        return this;
    }

    public Tween waypoint(float ... targetValues) {
        Tween.flushRead();
        int waypointsCount = this.waypointsCount++;
        Tween.verifyWaypoints(waypointsCount);
        System.arraycopy(targetValues, 0, this.waypoints, waypointsCount * targetValues.length, targetValues.length);
        Tween.flushWrite();
        return this;
    }

    public Tween path(TweenPaths path) {
        this.path = path.path();
        Tween.flushWrite();
        return this;
    }

    public Tween path(TweenPath path) {
        this.path = path;
        Tween.flushWrite();
        return this;
    }

    public Object getTarget() {
        Tween.flushRead();
        return this.target;
    }

    public int getType() {
        Tween.flushRead();
        return this.type;
    }

    public TweenEquation getEasing() {
        Tween.flushRead();
        return this.equation;
    }

    public float[] getTargetValues() {
        Tween.flushRead();
        return this.targetValues;
    }

    public int getCombinedAttributesCount() {
        Tween.flushRead();
        return this.combinedAttrsCnt;
    }

    public TweenAccessor<?> getAccessor() {
        Tween.flushRead();
        return this.accessor;
    }

    public Class<?> getTargetClass() {
        Tween.flushRead();
        return this.targetClass;
    }

    @Override
    public Tween start() {
        Tween.flushRead();
        super.start();
        Object target = this.target;
        if (target == null) {
            return this;
        }
        if (this.accessor == null) {
            this.accessor = target instanceof TweenAccessor ? (TweenAccessor)target : registeredAccessors.get(this.targetClass);
        }
        if (this.accessor == null) {
            throw new RuntimeException("No TweenAccessor was found for the target");
        }
        this.combinedAttrsCnt = this.accessor.getValues(target, this.type, this.accessorBuffer);
        Tween.verifyCombinedAttrs(this.combinedAttrsCnt);
        Tween.flushWrite();
        return this;
    }

    @Override
    public void free() {
        pool.put((Object)this);
    }

    @Override
    protected void setValues(boolean updateDirection, boolean updateValue) {
        if (this.target == null || !this.isInitialized || this.isCanceled) {
            return;
        }
        if (updateValue) {
            this.accessor.setValues(this.target, this.type, this.startValues);
        } else if (this.canAutoReverse && (this.repeatCountOrig & 1) != 0) {
            this.accessor.setValues(this.target, this.type, this.startValues);
        } else {
            this.accessor.setValues(this.target, this.type, this.targetValues);
        }
    }

    @Override
    protected void initializeValues() {
        block9: {
            int combinedAttrsCnt;
            float[] targetValues;
            float[] startValues;
            block8: {
                Object target = this.target;
                if (target == null || this.isCanceled) {
                    return;
                }
                startValues = this.startValues;
                targetValues = this.targetValues;
                combinedAttrsCnt = this.combinedAttrsCnt;
                this.accessor.getValues(target, this.type, startValues);
                if (!this.isRelative) break block8;
                int waypointsCount = this.waypointsCount;
                float[] waypoints = this.waypoints;
                if (this.isFrom) {
                    for (int i = 0; i < combinedAttrsCnt; ++i) {
                        int n = i;
                        targetValues[n] = targetValues[n] + startValues[i];
                        for (int ii = 0; ii < waypointsCount; ++ii) {
                            int n2 = ii * combinedAttrsCnt + i;
                            waypoints[n2] = waypoints[n2] + startValues[i];
                        }
                        float tmp = startValues[i];
                        startValues[i] = targetValues[i];
                        targetValues[i] = tmp;
                    }
                } else {
                    for (int i = 0; i < combinedAttrsCnt; ++i) {
                        int n = i;
                        targetValues[n] = targetValues[n] + startValues[i];
                        for (int ii = 0; ii < waypointsCount; ++ii) {
                            int n3 = ii * combinedAttrsCnt + i;
                            waypoints[n3] = waypoints[n3] + startValues[i];
                        }
                    }
                }
                break block9;
            }
            if (!this.isFrom) break block9;
            for (int i = 0; i < combinedAttrsCnt; ++i) {
                float tmp = startValues[i];
                startValues[i] = targetValues[i];
                targetValues[i] = tmp;
            }
        }
    }

    @Override
    protected void update(boolean updateDirection, float delta) {
        Object target = this.target;
        TweenEquation equation = this.equation;
        if (target == null || equation == null || !this.isInitialized || this.isCanceled) {
            return;
        }
        float duration = this.duration;
        float time = this.currentTime;
        float tweenValue = equation.compute(time / duration);
        float[] accessorBuffer = this.accessorBuffer;
        int combinedAttrsCnt = this.combinedAttrsCnt;
        int waypointsCnt = this.waypointsCount;
        TweenPath path = this.path;
        float[] startValues = this.startValues;
        float[] targetValues = this.targetValues;
        if (waypointsCnt == 0 || path == null) {
            for (int i = 0; i < combinedAttrsCnt; ++i) {
                accessorBuffer[i] = startValues[i] + tweenValue * (targetValues[i] - startValues[i]);
            }
        } else {
            float[] waypoints = this.waypoints;
            float[] pathBuffer = this.pathBuffer;
            for (int i = 0; i < combinedAttrsCnt; ++i) {
                pathBuffer[0] = startValues[i];
                pathBuffer[1 + waypointsCnt] = targetValues[i];
                for (int ii = 0; ii < waypointsCnt; ++ii) {
                    pathBuffer[ii + 1] = waypoints[ii * combinedAttrsCnt + i];
                }
                accessorBuffer[i] = path.compute(tweenValue, pathBuffer, waypointsCnt + 2);
            }
        }
        this.accessor.setValues(target, this.type, accessorBuffer);
    }

    @Override
    protected boolean containsTarget(Object target) {
        return this.target == target;
    }

    @Override
    protected boolean containsTarget(Object target, int tweenType) {
        return this.target == target && this.type == tweenType;
    }

    private static void verifyCombinedAttrs(int length) {
        if (length > combinedAttrsLimit) {
            String msg = "You cannot combine more than " + combinedAttrsLimit + " " + "attributes in a tween. You can raise this limit with " + "Tween.setCombinedAttributesLimit(), which should be called once in application initialization code.";
            throw new RuntimeException(msg);
        }
    }

    private static void verifyWaypoints(int waypointsCount) {
        if (waypointsCount == waypointsLimit) {
            String msg = "You cannot add more than " + waypointsLimit + " " + "waypoints to a tween. You can raise this limit with " + "Tween.setWaypointsLimit(), which should be called once in application initialization code.";
            throw new RuntimeException(msg);
        }
    }
}

