/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.tweenengine;

import dorkbox.tweenengine.BaseTween;
import dorkbox.tweenengine.Timeline;
import dorkbox.tweenengine.Tween;
import dorkbox.tweenengine.UpdateAction;
import dorkbox.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TweenManager {
    private static final BaseTween[] BASE_TWEENS = new BaseTween[0];
    private final ArrayList<BaseTween<?>> tweenArrayList = new ArrayList(20);
    private BaseTween<?>[] childrenArray = new BaseTween[0];
    private boolean isPaused = false;
    private UpdateAction startEventCallback = BaseTween.NULL_ACTION;
    private UpdateAction endEventCallback = BaseTween.NULL_ACTION;
    private long lastTime = 0L;

    public static void setAutoRemove(BaseTween<?> tween, boolean value) {
        tween.isAutoRemoveEnabled = value;
        BaseTween.flushWrite();
    }

    public static void setAutoStart(BaseTween<?> tween, boolean value) {
        tween.isAutoStartEnabled = value;
        BaseTween.flushWrite();
    }

    public static Version getVersion() {
        return new Version("7.15");
    }

    public TweenManager setStartCallback(UpdateAction<TweenManager> startCallback) {
        if (startCallback == null) {
            throw new RuntimeException("Callback cannot be null! Use BaseTween.NULL_ACTION if you wish to 'unset' the callback");
        }
        this.startEventCallback = startCallback;
        BaseTween.flushWrite();
        return this;
    }

    public TweenManager setEndCallback(UpdateAction<TweenManager> endCallback) {
        if (endCallback == null) {
            throw new RuntimeException("Callback cannot be null! Use BaseTween.NULL_ACTION if you wish to 'unset' the callback");
        }
        this.endEventCallback = endCallback;
        BaseTween.flushWrite();
        return this;
    }

    public TweenManager add(BaseTween<?> tween) {
        BaseTween.flushRead();
        if (!this.tweenArrayList.contains(tween)) {
            this.tweenArrayList.add(tween);
        }
        this.childrenArray = this.tweenArrayList.toArray(BASE_TWEENS);
        if (tween.isAutoStartEnabled) {
            tween.start();
        }
        BaseTween.flushWrite();
        return this;
    }

    public boolean containsTarget(Object target) {
        BaseTween.flushRead();
        for (BaseTween<?> tween : this.childrenArray) {
            if (!tween.containsTarget(target)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTarget(Object target, int tweenType) {
        BaseTween.flushRead();
        for (BaseTween<?> tween : this.childrenArray) {
            if (!tween.containsTarget(target, tweenType)) continue;
            return true;
        }
        return false;
    }

    public void killAll() {
        BaseTween.flushRead();
        boolean needsRefresh = false;
        Iterator<BaseTween<?>> iterator = this.tweenArrayList.iterator();
        while (iterator.hasNext()) {
            BaseTween<?> tween = iterator.next();
            tween.cancel();
            if (tween.isDuringUpdate) continue;
            needsRefresh = true;
            iterator.remove();
            tween.free();
        }
        if (needsRefresh) {
            this.childrenArray = this.tweenArrayList.toArray(BASE_TWEENS);
        }
        BaseTween.flushWrite();
    }

    public boolean killTarget(Object target) {
        BaseTween.flushRead();
        boolean needsRefresh = false;
        Iterator<BaseTween<?>> iterator = this.tweenArrayList.iterator();
        while (iterator.hasNext()) {
            BaseTween<?> tween = iterator.next();
            boolean killTarget = tween.killTarget(target);
            if (!killTarget || tween.isDuringUpdate || !tween.isFinished__()) continue;
            needsRefresh = true;
            iterator.remove();
            tween.free();
        }
        if (needsRefresh) {
            this.childrenArray = this.tweenArrayList.toArray(BASE_TWEENS);
            BaseTween.flushWrite();
            return true;
        }
        BaseTween.flushWrite();
        return false;
    }

    public boolean killTarget(Object target, int tweenType) {
        BaseTween.flushRead();
        boolean needsRefresh = false;
        Iterator<BaseTween<?>> iterator = this.tweenArrayList.iterator();
        while (iterator.hasNext()) {
            BaseTween<?> tween = iterator.next();
            boolean killTarget = tween.killTarget(target, tweenType);
            if (!killTarget || tween.isDuringUpdate || !tween.isFinished__()) continue;
            needsRefresh = true;
            iterator.remove();
            tween.free();
        }
        if (needsRefresh) {
            this.childrenArray = this.tweenArrayList.toArray(BASE_TWEENS);
            BaseTween.flushWrite();
            return true;
        }
        BaseTween.flushWrite();
        return false;
    }

    public void ensureCapacity(int minCapacity) {
        BaseTween.flushRead();
        this.tweenArrayList.ensureCapacity(minCapacity);
        BaseTween.flushWrite();
    }

    public void pause() {
        this.isPaused = true;
        BaseTween.flushWrite();
    }

    public void resume() {
        this.isPaused = false;
        BaseTween.flushWrite();
    }

    public void resetUpdateTime() {
        this.lastTime = System.nanoTime();
        BaseTween.flushWrite();
    }

    public void update() {
        BaseTween.flushRead();
        long newTime = System.nanoTime();
        float deltaTime = (float)(newTime - this.lastTime) / 1.0E9f;
        this.lastTime = newTime;
        this.update__(deltaTime);
        BaseTween.flushWrite();
    }

    public void update(long deltaTimeInNanos) {
        BaseTween.flushRead();
        float deltaTimeInSec = (float)deltaTimeInNanos / 1.0E9f;
        this.update__(deltaTimeInSec);
        BaseTween.flushWrite();
    }

    public final void update(float delta) {
        BaseTween.flushRead();
        this.update__(delta);
        BaseTween.flushWrite();
    }

    private void update__(float delta) {
        if (!this.isPaused) {
            this.startEventCallback.onEvent(this);
            for (BaseTween<?> tween : this.childrenArray) {
                tween.update__(delta);
            }
            boolean needsRefresh = false;
            for (int i = this.childrenArray.length - 1; i >= 0; --i) {
                BaseTween<?> tween;
                tween = this.childrenArray[i];
                if (!tween.isAutoRemoveEnabled || !tween.isFinished__()) continue;
                tween.setValues(true, false);
                needsRefresh = true;
                this.tweenArrayList.remove(i);
                tween.free();
            }
            if (needsRefresh) {
                this.childrenArray = this.tweenArrayList.toArray(BASE_TWEENS);
            }
            this.endEventCallback.onEvent(this);
        }
    }

    public int size() {
        BaseTween.flushRead();
        return this.childrenArray.length;
    }

    public int getRunningTweensCount() {
        BaseTween.flushRead();
        return TweenManager.getTweensCount(this.tweenArrayList);
    }

    public int getRunningTimelinesCount() {
        BaseTween.flushRead();
        return TweenManager.getTimelinesCount(this.tweenArrayList);
    }

    public List<BaseTween<?>> getObjects() {
        BaseTween.flushRead();
        return Collections.unmodifiableList(this.tweenArrayList);
    }

    private static int getTweensCount(List<BaseTween<?>> objs) {
        int count = 0;
        int n = objs.size();
        for (int i = 0; i < n; ++i) {
            BaseTween<?> obj = objs.get(i);
            if (obj instanceof Tween) {
                ++count;
                continue;
            }
            count += TweenManager.getTweensCount(((Timeline)obj).getChildren());
        }
        return count;
    }

    private static int getTimelinesCount(List<BaseTween<?>> objs) {
        int count = 0;
        int n = objs.size();
        for (int i = 0; i < n; ++i) {
            BaseTween<?> obj = objs.get(i);
            if (!(obj instanceof Timeline)) continue;
            count += 1 + TweenManager.getTimelinesCount(((Timeline)obj).getChildren());
        }
        return count;
    }
}

