/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import java.util.Locale;

public class Version
implements Comparable<Version> {
    private static final int[] PRIME = new int[]{2, 3, 5};
    protected String version;
    protected int[] internalVersion;
    protected boolean isBeta;
    protected String build;

    public Version(double version) {
        this(Double.toString(version), false, null);
    }

    public Version(String version) {
        this(Version.fromString(version));
    }

    public Version(Version version) {
        this.version = version.version;
        this.internalVersion = version.internalVersion;
        this.isBeta = version.isBeta;
        this.build = version.build;
    }

    public Version(String version, boolean isBeta, String build) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (!version.matches("[0-9]+(\\.[0-9]+){0,3}")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.build = build != null ? build.toLowerCase(Locale.US) : null;
        this.isBeta = isBeta;
        this.version = version;
        String[] parts = this.version.split("\\.");
        this.internalVersion = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            this.internalVersion[i] = Integer.parseInt(s);
        }
    }

    public Version(String ... version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        int length = version.length;
        if (length > 3) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.build = null;
        this.isBeta = false;
        StringBuilder builder = new StringBuilder(length + 3);
        this.internalVersion = new int[length];
        for (int i = 0; i < length; ++i) {
            String s = version[i];
            this.internalVersion[i] = Integer.parseInt(s);
            builder.append(s).append('.');
        }
        this.version = builder.toString();
    }

    public Version(int ... version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (version.length > 3) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.build = null;
        this.isBeta = false;
        StringBuilder builder = new StringBuilder(version.length + 3);
        this.internalVersion = new int[version.length];
        for (int i = 0; i < version.length; ++i) {
            this.internalVersion[i] = version[i];
            builder.append(i).append('.');
        }
        this.version = builder.toString();
    }

    public Version beta() {
        this.isBeta = true;
        return this;
    }

    public Version build(String build) {
        this.build = build;
        return this;
    }

    public int[] getVersion() {
        return this.internalVersion;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public String getBuild() {
        return this.build;
    }

    public boolean isGreater(Object that) {
        if (this == that) {
            return false;
        }
        if (that == null) {
            return true;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) > 0;
    }

    public boolean isGreaterOrEquals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return true;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) >= 0;
    }

    public boolean isLess(Object that) {
        if (this == that) {
            return false;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) < 0;
    }

    public boolean isLessOrEquals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) <= 0;
    }

    public boolean isEquals(Object that) {
        return this.equals(that);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        int[] thisParts = this.internalVersion;
        int[] thatParts = that.internalVersion;
        int maxLength = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? thisParts[i] : 0;
            if (thisPart < (thatPart = i < thatParts.length ? thatParts[i] : 0)) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        if (this.isBeta) {
            if (this.build != null) {
                if (that.isBeta) {
                    if (that.build != null) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            }
            if (that.isBeta) {
                if (that.build != null) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }
        if (this.build != null) {
            if (that.isBeta) {
                return 1;
            }
            if (that.build != null) {
                return 0;
            }
            return -1;
        }
        if (that.isBeta) {
            return 1;
        }
        if (that.build != null) {
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.internalVersion.length; ++i) {
            int part = this.internalVersion[i];
            if (part <= 0) continue;
            hashCode += PRIME[i] ^ part;
        }
        if (this.build != null) {
            hashCode += this.build.hashCode();
        }
        return hashCode;
    }

    public static Version fromString(String string) {
        int betaIndex = string.indexOf("-BETA");
        int buildIndex = string.indexOf("+");
        int lastIndex = string.length();
        boolean isBeta = betaIndex > 0;
        String build = null;
        if (buildIndex > 0) {
            build = string.substring(buildIndex + 1, lastIndex);
            lastIndex = buildIndex;
        }
        if (isBeta) {
            lastIndex = betaIndex;
        }
        String version = string.substring(0, lastIndex);
        return new Version(version, isBeta, build);
    }

    public String toString() {
        if (this.isBeta) {
            if (this.build != null) {
                return this.version + "-BETA+" + this.build;
            }
            return this.version + "-BETA";
        }
        if (this.build != null) {
            return this.version + "+" + this.build;
        }
        return this.version;
    }
}

