/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.reactor.push.api;

import com.easemob.push.model.EMPushHttpResponse;
import com.easemob.push.model.LabelRequest;
import com.easemob.push.model.LabelUserRequest;
import com.easemob.reactor.push.EMPushContext;
import com.easemob.reactor.push.utils.ByteBufUtil;
import com.easemob.reactor.push.utils.ResponseUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.QueryStringEncoder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class LabelApi {
    private final EMPushContext context;

    public LabelApi(EMPushContext context) {
        this.context = context;
    }

    public Mono<EMPushHttpResponse> create(LabelRequest labelRequest) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).post().uri("/push/label")).send((Publisher)Mono.just((Object)ByteBufUtil.encode(labelRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> get(String labelName) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.ResponseReceiver)httpClient.get().uri("/push/label/" + labelName)).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> get(String cursor, int limit) {
        QueryStringEncoder encoder = new QueryStringEncoder("/push/label");
        if (cursor != null && cursor.length() > 0) {
            encoder.addParam("cursor", cursor);
        }
        encoder.addParam("limit", String.valueOf(limit));
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.ResponseReceiver)httpClient.get().uri(encoder.toString())).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> delete(String labelName) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.delete().uri("/push/label/" + labelName)).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> getUser(String labelName, String cursor, int limit) {
        QueryStringEncoder encoder = new QueryStringEncoder(String.format("/push/label/%s/user", labelName));
        if (cursor != null && cursor.length() > 0) {
            encoder.addParam("cursor", cursor);
        }
        encoder.addParam("limit", String.valueOf(limit));
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.ResponseReceiver)httpClient.get().uri(encoder.toString())).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> getUser(String labelName, String labelUserName) {
        String format = String.format("/push/label/%s/user", labelName);
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.ResponseReceiver)httpClient.get().uri(format + "/" + labelUserName)).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> addUser(String labelName, LabelUserRequest labelUserRequest) {
        String format = String.format("/push/label/%s/user", labelName);
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).post().uri(format)).send((Publisher)Mono.just((Object)ByteBufUtil.encode(labelUserRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> deleteUser(String labelName, LabelUserRequest labelUserRequest) {
        String format = String.format("/push/label/%s/user", labelName);
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).delete().uri(format)).send((Publisher)Mono.just((Object)ByteBufUtil.encode(labelUserRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }
}

