/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.reactor.push.api;

import com.easemob.push.model.EMPushHttpResponse;
import com.easemob.push.model.PushRequest;
import com.easemob.push.model.SinglePushRequest;
import com.easemob.push.model.SyncPushRequest;
import com.easemob.reactor.push.EMPushContext;
import com.easemob.reactor.push.utils.ByteBufUtil;
import com.easemob.reactor.push.utils.ResponseUtil;
import io.netty.buffer.ByteBuf;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class PushApi {
    private final EMPushContext context;

    public PushApi(EMPushContext context) {
        this.context = context;
    }

    public Mono<EMPushHttpResponse> sync(SyncPushRequest pushRequest, String target) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).post().uri("/push/sync/" + target)).send((Publisher)Mono.just((Object)ByteBufUtil.encode(pushRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> single(SinglePushRequest pushRequest) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).post().uri("/push/single")).send((Publisher)Mono.just((Object)ByteBufUtil.encode(pushRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> list(PushRequest pushRequest) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).post().uri("/push/list")).send((Publisher)Mono.just((Object)ByteBufUtil.encode(pushRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }

    public Mono<EMPushHttpResponse> label(PushRequest pushRequest) {
        return this.context.getHttpClient().flatMap(httpClient -> ((HttpClient.RequestSender)httpClient.headers(header -> header.add("Content-Type", (Object)"application/json")).post().uri("/push/list/label")).send((Publisher)Mono.just((Object)ByteBufUtil.encode(pushRequest))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> ResponseUtil.of((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2())));
    }
}

