/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.reactor.push.service.impl;

import com.easemob.common.exception.EMException;
import com.easemob.common.model.DnsConfigResponse;
import com.easemob.common.model.Endpoint;
import com.easemob.reactor.push.EMPushProperties;
import com.easemob.reactor.push.service.DomainProvider;
import com.easemob.reactor.push.utils.ByteBufUtil;
import com.easemob.reactor.push.utils.EMPushHttpClientFactory;
import com.easemob.reactor.push.utils.HttpResponseChecker;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class EMDomainProvider
implements DomainProvider {
    private static final String DNS_HTTP_CLIENT_NAME = "DNS";
    private final SecureRandom secureRandom = new SecureRandom();
    private final EMPushProperties emPushProperties;
    private final HttpClient httpClient;
    private Mono<List<Endpoint>> endpoints;

    public EMDomainProvider(EMPushProperties emPushProperties) {
        this.emPushProperties = emPushProperties;
        this.httpClient = EMPushHttpClientFactory.create(emPushProperties, DNS_HTTP_CLIENT_NAME);
        this.endpoints = this.getDnsEndpoints().cache(cache -> Duration.ofSeconds(3600L), error -> Duration.ofSeconds(10L), () -> Duration.ofSeconds(10L));
    }

    private Mono<List<Endpoint>> getDnsEndpoints() {
        List<Endpoint> hosts = this.emPushProperties.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            return Mono.just(hosts);
        }
        QueryStringEncoder encoder = new QueryStringEncoder("http://rs.easemob.com/easemob/server.json");
        encoder.addParam("app_key", this.emPushProperties.getAppKey());
        return ((HttpClient.ResponseReceiver)this.httpClient.get().uri(encoder.toString())).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> {
            HttpResponseChecker.check((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2());
            return ByteBufUtil.decode((ByteBuf)tuple2.getT2(), DnsConfigResponse.class);
        }).map(DnsConfigResponse::endpoints).map(this::filterEndpoint);
    }

    @Override
    public Mono<Endpoint> getEndpoint() {
        return this.endpoints.map(list -> {
            if (list == null || list.isEmpty()) {
                throw new EMException("no endpoint for http/https");
            }
            return (Endpoint)list.get(this.secureRandom.nextInt(list.size()));
        });
    }

    private List<Endpoint> filterEndpoint(List<Endpoint> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().filter(endpoint -> this.emPushProperties.getProtocol().name().equalsIgnoreCase(endpoint.getProtocol())).collect(Collectors.toList());
    }
}

