/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.reactor.push.service.impl;

import com.easemob.common.model.AppTokenRequest;
import com.easemob.common.model.AppTokenResponse;
import com.easemob.common.model.EMAppToken;
import com.easemob.reactor.push.EMPushProperties;
import com.easemob.reactor.push.service.DomainProvider;
import com.easemob.reactor.push.service.TokenProvider;
import com.easemob.reactor.push.utils.ByteBufUtil;
import com.easemob.reactor.push.utils.EMPushHttpClientFactory;
import com.easemob.reactor.push.utils.HttpResponseChecker;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.time.Instant;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class EMTokenProvider
implements TokenProvider {
    private static final String TOKEN_HTTP_CLIENT_NAME = "TOKEN";
    private final EMPushProperties emPushProperties;
    private final AppTokenRequest appTokenRequest;
    private final DomainProvider emDomainProvider;
    private final HttpClient httpClient;
    private Mono<EMAppToken> appToken;

    public EMTokenProvider(EMPushProperties emPushProperties, DomainProvider emDomainProvider) {
        this.emPushProperties = emPushProperties;
        this.httpClient = EMPushHttpClientFactory.create(emPushProperties, TOKEN_HTTP_CLIENT_NAME);
        this.appTokenRequest = AppTokenRequest.of((String)this.emPushProperties.getCredentials().getId(), (String)this.emPushProperties.getCredentials().getSecret());
        this.emDomainProvider = emDomainProvider;
        this.appToken = this.getAppToken().cache(cache -> Duration.between(Instant.now(), Instant.ofEpochMilli(cache.getExpireTimestamp())).dividedBy(2L), error -> Duration.ofSeconds(10L), () -> Duration.ofSeconds(10L));
    }

    private Mono<EMAppToken> getAppToken() {
        return this.emDomainProvider.getEndpoint().flatMap(endpoint -> ((HttpClient.RequestSender)this.httpClient.baseUrl(endpoint.getUri()).post().uri(String.format("/%s/token", this.emPushProperties.getAppKeyUrlEncoded()))).send((Publisher)Mono.create(byteBufMonoSink -> byteBufMonoSink.success((Object)ByteBufUtil.encode(this.appTokenRequest)))).responseSingle((rsp, buf) -> Mono.zip((Mono)Mono.just((Object)rsp), (Mono)buf)).map(tuple2 -> {
            HttpResponseChecker.check((HttpClientResponse)tuple2.getT1(), (ByteBuf)tuple2.getT2());
            return ByteBufUtil.decode((ByteBuf)tuple2.getT2(), AppTokenResponse.class);
        }).map(AppTokenResponse::as));
    }

    @Override
    public Mono<String> getToken() {
        return this.appToken.map(EMAppToken::getAccessToken).map(this::bearer);
    }

    private String bearer(String token) {
        return "Bearer " + token;
    }
}

