/*
 * Decompiled with CFR 0.152.
 */
package com.easemob.reactor.push.utils;

import com.easemob.common.EMSDKVersion;
import com.easemob.reactor.push.EMPushProperties;
import com.easemob.reactor.push.EMPushProxy;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.logging.log4j.util.Strings;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.ProxyProvider;

public final class EMPushHttpClientFactory {
    private static final String CLIENT_NAME = "easemob-push-sdk";
    private static final String USER_AGENT = "User-Agent";
    private static final String USER_AGENT_FORMAT = "EasemobPushServerSDK/%s";

    public static HttpClient create(EMPushProperties properties) {
        return EMPushHttpClientFactory.create(properties, CLIENT_NAME);
    }

    public static HttpClient create(EMPushProperties properties, String name) {
        ConnectionProvider connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)name).maxConnections(properties.getHttpConnectionPoolSize().intValue())).maxLifeTime(Duration.ofMillis(properties.getHttpConnectionMaxLifeTime()))).maxIdleTime(Duration.ofMillis(properties.getHttpConnectionMaxIdleTime()))).evictInBackground(Duration.ofMillis(properties.getHttpConnectionEvictInBackground()))).pendingAcquireMaxCount(properties.getHttpConnectionPendingAcquireMaxCount().intValue())).pendingAcquireTimeout(Duration.ofMillis(properties.getHttpConnectionPendingAcquireTimeout()))).build();
        HttpClient httpClient = (HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).headers(headers -> headers.add(USER_AGENT, (Object)String.format(USER_AGENT_FORMAT, EMSDKVersion.getVersion()))).runOn((EventLoopGroup)new NioEventLoopGroup(properties.getHttpConnectionPoolSize() * 2 + 1));
        EMPushProxy proxyInfo = properties.getEmProxy();
        if (proxyInfo == null || proxyInfo.getIp() == null) {
            return httpClient;
        }
        String username = proxyInfo.getUsername();
        String password = proxyInfo.getPassword();
        String ip = proxyInfo.getIp();
        int port = proxyInfo.getPort();
        if (Strings.isNotBlank((String)username) && Strings.isNotBlank((String)password)) {
            return (HttpClient)httpClient.proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).address(new InetSocketAddress(ip, port)).username(username).password(p -> password));
        }
        return (HttpClient)httpClient.proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).address(new InetSocketAddress(ip, port)));
    }
}

