/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.LibraryLoader;
import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Locker;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8ResultUndefined;
import com.eclipsesource.v8.V8RuntimeException;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.V8Executor;
import com.eclipsesource.v8.utils.V8Map;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V8
extends V8Object {
    private static Object lock = new Object();
    private static volatile int runtimeCounter = 0;
    private static Runnable debugHandler = null;
    private static Thread debugThread = null;
    private final V8Locker locker;
    private int methodReferenceCounter = 0;
    private boolean debugEnabled = false;
    private long objectReferences = 0L;
    private long v8RuntimePtr = 0L;
    private List<Releasable> resources = null;
    private V8Map<V8Executor> executors = null;
    private boolean forceTerminateExecutors = false;
    private Map<Integer, MethodDescriptor> functions = new HashMap<Integer, MethodDescriptor>();
    private static boolean nativeLibraryLoaded = false;
    private static Error nativeLoadError = null;
    private static Exception nativeLoadException = null;
    private static V8Value undefined = new V8Object.Undefined();
    private static Object invalid = new Object();

    private static synchronized void load(String tmpDirectory) {
        try {
            LibraryLoader.loadLibrary(tmpDirectory);
            nativeLibraryLoaded = true;
        }
        catch (Error e) {
            nativeLoadError = e;
        }
        catch (Exception e) {
            nativeLoadException = e;
        }
    }

    public static boolean isLoaded() {
        return nativeLibraryLoaded;
    }

    public static V8 createV8Runtime() {
        return V8.createV8Runtime(null, null);
    }

    public static V8 createV8Runtime(String globalAlias) {
        return V8.createV8Runtime(globalAlias, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8 createV8Runtime(String globalAlias, String tempDirectory) {
        if (!nativeLibraryLoaded) {
            Object object = lock;
            synchronized (object) {
                if (!nativeLibraryLoaded) {
                    V8.load(tempDirectory);
                }
            }
        }
        V8.checkNativeLibraryLoaded();
        if (debugThread == null) {
            debugThread = Thread.currentThread();
        }
        V8 runtime = new V8(globalAlias);
        Object object = lock;
        synchronized (object) {
            ++runtimeCounter;
        }
        return runtime;
    }

    private static void checkNativeLibraryLoaded() {
        if (!nativeLibraryLoaded) {
            if (nativeLoadError != null) {
                throw new IllegalStateException("J2V8 native library not loaded.", nativeLoadError);
            }
            if (nativeLoadException != null) {
                throw new IllegalStateException("J2V8 native library not loaded.", nativeLoadException);
            }
            throw new IllegalStateException("J2V8 native library not loaded.");
        }
    }

    protected V8() {
        this((String)null);
    }

    protected V8(String globalAlias) {
        super(null);
        this.released = false;
        this.locker = new V8Locker();
        this.checkThread();
        this.v8RuntimePtr = this._createIsolate(globalAlias);
        this.objectHandle = this._getGlobalObject(this.v8RuntimePtr);
    }

    public static V8Value getUndefined() {
        return undefined;
    }

    @Deprecated
    public boolean enableDebugSupport(int port, boolean waitForConnection) {
        V8.checkDebugThread();
        this.debugEnabled = this.enableDebugSupport(this.getV8RuntimePtr(), port, waitForConnection);
        return this.debugEnabled;
    }

    @Deprecated
    public boolean enableDebugSupport(int port) {
        V8.checkDebugThread();
        this.debugEnabled = this.enableDebugSupport(this.getV8RuntimePtr(), port, false);
        return this.debugEnabled;
    }

    @Deprecated
    public static void processDebugMessages(V8 runtime) {
        runtime.checkThread();
        runtime._processDebugMessages(runtime.getV8RuntimePtr());
    }

    @Deprecated
    public void disableDebugSupport() {
        V8.checkDebugThread();
        this.disableDebugSupport(this.getV8RuntimePtr());
        this.debugEnabled = false;
    }

    @Deprecated
    public static void registerDebugHandler(Runnable handler) {
        debugHandler = handler;
    }

    public static int getActiveRuntimes() {
        return runtimeCounter;
    }

    protected long getV8RuntimePtr() {
        return this.v8RuntimePtr;
    }

    @Override
    public void release() {
        this.release(true);
    }

    public void terminateExecution() {
        this.forceTerminateExecutors = true;
        this.terminateExecution(this.v8RuntimePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean reportMemoryLeaks) {
        if (this.isReleased()) {
            return;
        }
        this.checkThread();
        if (this.debugEnabled) {
            this.disableDebugSupport();
        }
        this.releaseResources();
        this.shutdownExecutors(this.forceTerminateExecutors);
        if (this.executors != null) {
            this.executors.clear();
        }
        Object object = lock;
        synchronized (object) {
            --runtimeCounter;
        }
        this._releaseRuntime(this.v8RuntimePtr);
        this.v8RuntimePtr = 0L;
        this.released = true;
        if (reportMemoryLeaks && this.objectReferences > 0L) {
            throw new IllegalStateException(this.objectReferences + " Object(s) still exist in runtime");
        }
    }

    private void releaseResources() {
        if (this.resources != null) {
            for (Releasable releasable : this.resources) {
                releasable.release();
            }
            this.resources.clear();
            this.resources = null;
        }
    }

    public void registerV8Executor(V8Object key, V8Executor executor) {
        this.checkThread();
        if (this.executors == null) {
            this.executors = new V8Map();
        }
        this.executors.put(key, executor);
    }

    public V8Executor removeExecutor(V8Object key) {
        this.checkThread();
        if (this.executors == null) {
            return null;
        }
        return this.executors.remove(key);
    }

    public V8Executor getExecutor(V8Object key) {
        this.checkThread();
        if (this.executors == null) {
            return null;
        }
        return this.executors.get(key);
    }

    public void shutdownExecutors(boolean forceTerminate) {
        this.checkThread();
        if (this.executors == null) {
            return;
        }
        for (V8Executor executor : this.executors.values()) {
            if (forceTerminate) {
                executor.forceTermination();
                continue;
            }
            executor.shutdown();
        }
    }

    public void registerResource(Releasable resource) {
        this.checkThread();
        if (this.resources == null) {
            this.resources = new ArrayList<Releasable>();
        }
        this.resources.add(resource);
    }

    public int executeIntegerScript(String script) {
        return this.executeIntegerScript(script, null, 0);
    }

    public int executeIntegerScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeIntegerScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected void createTwin(V8Value value, V8Value twin) {
        this.checkThread();
        this.createTwin(this.v8RuntimePtr, value.getHandle(), twin.getHandle());
    }

    public double executeDoubleScript(String script) {
        return this.executeDoubleScript(script, null, 0);
    }

    public double executeDoubleScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeDoubleScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public String executeStringScript(String script) {
        return this.executeStringScript(script, null, 0);
    }

    public String executeStringScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeStringScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public boolean executeBooleanScript(String script) {
        return this.executeBooleanScript(script, null, 0);
    }

    public boolean executeBooleanScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeBooleanScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public V8Array executeArrayScript(String script) {
        return this.executeArrayScript(script, null, 0);
    }

    public V8Array executeArrayScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        Object result = this.executeScript(script, null, 0);
        if (result instanceof V8Array) {
            return (V8Array)result;
        }
        throw new V8ResultUndefined();
    }

    public Object executeScript(String script) {
        return this.executeScript(script, null, 0);
    }

    public Object executeScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeScript(this.getV8RuntimePtr(), 0, script, scriptName, lineNumber);
    }

    public V8Object executeObjectScript(String script) {
        return this.executeObjectScript(script, null, 0);
    }

    public V8Object executeObjectScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        Object result = this.executeScript(script, null, 0);
        if (result instanceof V8Object) {
            return (V8Object)result;
        }
        throw new V8ResultUndefined();
    }

    public void executeVoidScript(String script) {
        this.executeVoidScript(script, null, 0);
    }

    public void executeVoidScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        this.executeVoidScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public V8Locker getLocker() {
        return this.locker;
    }

    public long getBuildID() {
        return this._getBuildID();
    }

    void checkThread() {
        this.locker.checkThread();
        if (this.isReleased()) {
            throw new Error("Runtime disposed error.");
        }
    }

    static void checkDebugThread() {
        if (debugThread != null && debugThread != Thread.currentThread()) {
            throw new Error("Invalid V8 thread access.");
        }
    }

    static void checkScript(String script) {
        if (script == null) {
            throw new NullPointerException("Script is null");
        }
    }

    void registerCallback(Object object, Method method, long objectHandle, String jsFunctionName, boolean includeReceiver) {
        MethodDescriptor methodDescriptor = new MethodDescriptor();
        methodDescriptor.object = object;
        methodDescriptor.method = method;
        methodDescriptor.includeReceiver = includeReceiver;
        int methodID = this.methodReferenceCounter++;
        this.getFunctionRegistry().put(methodID, methodDescriptor);
        this.registerJavaMethod(this.getV8RuntimePtr(), objectHandle, jsFunctionName, methodID, this.isVoidMethod(method));
    }

    void registerVoidCallback(JavaVoidCallback callback, long objectHandle, String jsFunctionName) {
        MethodDescriptor methodDescriptor = new MethodDescriptor();
        methodDescriptor.voidCallback = callback;
        int methodID = this.methodReferenceCounter++;
        this.getFunctionRegistry().put(methodID, methodDescriptor);
        this.registerJavaMethod(this.getV8RuntimePtr(), objectHandle, jsFunctionName, methodID, true);
    }

    void registerCallback(JavaCallback callback, long objectHandle, String jsFunctionName) {
        MethodDescriptor methodDescriptor = new MethodDescriptor();
        methodDescriptor.callback = callback;
        int methodID = this.methodReferenceCounter++;
        this.getFunctionRegistry().put(methodID, methodDescriptor);
        this.registerJavaMethod(this.getV8RuntimePtr(), objectHandle, jsFunctionName, methodID, false);
    }

    private boolean isVoidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(Void.TYPE);
    }

    private Object getDefaultValue(Class<?> type) {
        if (type.equals(V8Object.class)) {
            return new V8Object.Undefined();
        }
        if (type.equals(V8Array.class)) {
            return new V8Array.Undefined();
        }
        return invalid;
    }

    protected Object callObjectJavaMethod(int methodID, V8Object receiver, V8Array parameters) throws Throwable {
        MethodDescriptor methodDescriptor = this.getFunctionRegistry().get(methodID);
        if (methodDescriptor.callback != null) {
            return this.checkResult(methodDescriptor.callback.invoke(receiver, parameters));
        }
        boolean hasVarArgs = methodDescriptor.method.isVarArgs();
        Object[] args = this.getArgs(receiver, methodDescriptor, parameters, hasVarArgs);
        this.checkArgs(args);
        try {
            Object result = methodDescriptor.method.invoke(methodDescriptor.object, args);
            Object object = this.checkResult(result);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            this.releaseArguments(args, hasVarArgs);
        }
    }

    private Object checkResult(Object result) {
        if (result == null) {
            return result;
        }
        if (result instanceof Float) {
            return ((Float)result).doubleValue();
        }
        if (result instanceof Integer || result instanceof Double || result instanceof Boolean || result instanceof String || result instanceof V8Value) {
            return result;
        }
        throw new V8RuntimeException("Unknown return type: " + result.getClass());
    }

    protected void callVoidJavaMethod(int methodID, V8Object receiver, V8Array parameters) throws Throwable {
        MethodDescriptor methodDescriptor = this.getFunctionRegistry().get(methodID);
        if (methodDescriptor.voidCallback != null) {
            methodDescriptor.voidCallback.invoke(receiver, parameters);
            return;
        }
        boolean hasVarArgs = methodDescriptor.method.isVarArgs();
        Object[] args = this.getArgs(receiver, methodDescriptor, parameters, hasVarArgs);
        this.checkArgs(args);
        try {
            methodDescriptor.method.invoke(methodDescriptor.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            this.releaseArguments(args, hasVarArgs);
        }
    }

    private void checkArgs(Object[] args) {
        for (Object argument : args) {
            if (argument != invalid) continue;
            throw new IllegalArgumentException("argument type mismatch");
        }
    }

    private void releaseArguments(Object[] args, boolean hasVarArgs) {
        if (hasVarArgs && args.length > 0 && args[args.length - 1] instanceof Object[]) {
            Object[] varArgs;
            for (Object object : varArgs = (Object[])args[args.length - 1]) {
                if (!(object instanceof V8Object)) continue;
                ((V8Value)object).release();
            }
        }
        for (Object arg : args) {
            if (!(arg instanceof V8Object)) continue;
            ((V8Value)arg).release();
        }
    }

    private Object[] getArgs(V8Object receiver, MethodDescriptor methodDescriptor, V8Array parameters, boolean hasVarArgs) {
        int numberOfParameters = methodDescriptor.method.getParameterTypes().length;
        int varArgIndex = hasVarArgs ? numberOfParameters - 1 : numberOfParameters;
        Object[] args = this.setDefaultValues(new Object[numberOfParameters], methodDescriptor.method.getParameterTypes(), receiver, methodDescriptor.includeReceiver);
        ArrayList<Object> varArgs = new ArrayList<Object>();
        this.populateParamters(parameters, varArgIndex, args, varArgs, methodDescriptor.includeReceiver);
        if (hasVarArgs) {
            Object varArgContainer = this.getVarArgContainer(methodDescriptor.method.getParameterTypes(), varArgs.size());
            System.arraycopy(varArgs.toArray(), 0, varArgContainer, 0, varArgs.size());
            args[varArgIndex] = varArgContainer;
        }
        return args;
    }

    private Object getVarArgContainer(Class<?>[] parameterTypes, int size) {
        Class<?> clazz = parameterTypes[parameterTypes.length - 1];
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        Object result = Array.newInstance(clazz, size);
        return result;
    }

    private void populateParamters(V8Array parameters, int varArgIndex, Object[] args, List<Object> varArgs, boolean includeReceiver) {
        int start = 0;
        if (includeReceiver) {
            start = 1;
        }
        for (int i = start; i < parameters.length() + start; ++i) {
            if (i >= varArgIndex) {
                varArgs.add(this.getArrayItem(parameters, i - start));
                continue;
            }
            args[i] = this.getArrayItem(parameters, i - start);
        }
    }

    private Object[] setDefaultValues(Object[] parameters, Class<?>[] parameterTypes, V8Object receiver, boolean includeReceiver) {
        int start = 0;
        if (includeReceiver) {
            start = 1;
            parameters[0] = receiver;
        }
        for (int i = start; i < parameters.length; ++i) {
            parameters[i] = this.getDefaultValue(parameterTypes[i]);
        }
        return parameters;
    }

    private Object getArrayItem(V8Array array, int index) {
        try {
            int type = array.getType(index);
            switch (type) {
                case 1: {
                    return array.getInteger(index);
                }
                case 2: {
                    return array.getDouble(index);
                }
                case 3: {
                    return array.getBoolean(index);
                }
                case 4: {
                    return array.getString(index);
                }
                case 5: {
                    return array.getArray(index);
                }
                case 6: {
                    return array.getObject(index);
                }
                case 7: {
                    return array.getObject(index);
                }
                case 99: {
                    return V8.getUndefined();
                }
            }
        }
        catch (V8ResultUndefined v8ResultUndefined) {
            // empty catch block
        }
        return null;
    }

    protected static void debugMessageReceived() {
        if (debugHandler != null) {
            debugHandler.run();
        }
    }

    private Map<Integer, MethodDescriptor> getFunctionRegistry() {
        if (this.functions == null) {
            this.functions = new HashMap<Integer, MethodDescriptor>();
        }
        return this.functions;
    }

    protected long initNewV8Object(long v8RuntimePtr) {
        return this._initNewV8Object(v8RuntimePtr);
    }

    protected void createTwin(long v8RuntimePtr, long objectHandle, long twinHandle) {
        this._createTwin(v8RuntimePtr, objectHandle, twinHandle);
    }

    protected int executeIntegerScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeIntegerScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected double executeDoubleScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeDoubleScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected String executeStringScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeStringScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected boolean executeBooleanScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeBooleanScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected Object executeScript(long v8RuntimePtr, int expectedType, String script, String scriptName, int lineNumber) {
        return this._executeScript(v8RuntimePtr, expectedType, script, scriptName, lineNumber);
    }

    protected void executeVoidScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        this._executeVoidScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected void release(long v8RuntimePtr, long objectHandle) {
        this._release(v8RuntimePtr, objectHandle);
    }

    protected boolean contains(long v8RuntimePtr, long objectHandle, String key) {
        return this._contains(v8RuntimePtr, objectHandle, key);
    }

    protected String[] getKeys(long v8RuntimePtr, long objectHandle) {
        return this._getKeys(v8RuntimePtr, objectHandle);
    }

    protected int getInteger(long v8RuntimePtr, long objectHandle, String key) {
        return this._getInteger(v8RuntimePtr, objectHandle, key);
    }

    protected boolean getBoolean(long v8RuntimePtr, long objectHandle, String key) {
        return this._getBoolean(v8RuntimePtr, objectHandle, key);
    }

    protected double getDouble(long v8RuntimePtr, long objectHandle, String key) {
        return this._getDouble(v8RuntimePtr, objectHandle, key);
    }

    protected String getString(long v8RuntimePtr, long objectHandle, String key) {
        return this._getString(v8RuntimePtr, objectHandle, key);
    }

    protected Object get(long v8RuntimePtr, int expectedType, long objectHandle, String key) {
        return this._get(v8RuntimePtr, expectedType, objectHandle, key);
    }

    protected int executeIntegerFunction(long v8RuntimePtr, long objectHandle, String name, long parametersHandle) {
        return this._executeIntegerFunction(v8RuntimePtr, objectHandle, name, parametersHandle);
    }

    protected double executeDoubleFunction(long v8RuntimePtr, long objectHandle, String name, long parametersHandle) {
        return this._executeDoubleFunction(v8RuntimePtr, objectHandle, name, parametersHandle);
    }

    protected String executeStringFunction(long v8RuntimePtr, long handle, String name, long parametersHandle) {
        return this._executeStringFunction(v8RuntimePtr, handle, name, parametersHandle);
    }

    protected boolean executeBooleanFunction(long v8RuntimePtr, long handle, String name, long parametersHandle) {
        return this._executeBooleanFunction(v8RuntimePtr, handle, name, parametersHandle);
    }

    protected Object executeFunction(long v8RuntimePtr, int expectedType, long objectHandle, String name, long parametersHandle) {
        return this._executeFunction(v8RuntimePtr, expectedType, objectHandle, name, parametersHandle);
    }

    protected Object executeFunction(long v8RuntimePtr, long receiverHandle, long functionHandle, long parametersHandle) {
        return this._executeFunction(v8RuntimePtr, receiverHandle, functionHandle, parametersHandle);
    }

    protected void executeVoidFunction(long v8RuntimePtr, long objectHandle, String name, long parametersHandle) {
        this._executeVoidFunction(v8RuntimePtr, objectHandle, name, parametersHandle);
    }

    protected boolean equals(long v8RuntimePtr, long objectHandle, long that) {
        return this._equals(v8RuntimePtr, objectHandle, that);
    }

    protected boolean strictEquals(long v8RuntimePtr, long objectHandle, long that) {
        return this._strictEquals(v8RuntimePtr, objectHandle, that);
    }

    protected boolean sameValue(long v8RuntimePtr, long objectHandle, long that) {
        return this._sameValue(v8RuntimePtr, objectHandle, that);
    }

    protected int identityHash(long v8RuntimePtr, long objectHandle) {
        return this._identityHash(v8RuntimePtr, objectHandle);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key, int value) {
        this._add(v8RuntimePtr, objectHandle, key, value);
    }

    protected void addObject(long v8RuntimePtr, long objectHandle, String key, long value) {
        this._addObject(v8RuntimePtr, objectHandle, key, value);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key, boolean value) {
        this._add(v8RuntimePtr, objectHandle, key, value);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key, double value) {
        this._add(v8RuntimePtr, objectHandle, key, value);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key, String value) {
        this._add(v8RuntimePtr, objectHandle, key, value);
    }

    protected void addUndefined(long v8RuntimePtr, long objectHandle, String key) {
        this._addUndefined(v8RuntimePtr, objectHandle, key);
    }

    protected void addNull(long v8RuntimePtr, long objectHandle, String key) {
        this._addNull(v8RuntimePtr, objectHandle, key);
    }

    protected void registerJavaMethod(long v8RuntimePtr, long objectHandle, String functionName, int methodID, boolean voidMethod) {
        this._registerJavaMethod(v8RuntimePtr, objectHandle, functionName, methodID, voidMethod);
    }

    protected long initNewV8Array(long v8RuntimePtr) {
        return this._initNewV8Array(v8RuntimePtr);
    }

    protected int arrayGetSize(long v8RuntimePtr, long arrayHandle) {
        return this._arrayGetSize(v8RuntimePtr, arrayHandle);
    }

    protected int arrayGetInteger(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetInteger(v8RuntimePtr, arrayHandle, index);
    }

    protected boolean arrayGetBoolean(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetBoolean(v8RuntimePtr, arrayHandle, index);
    }

    protected double arrayGetDouble(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetDouble(v8RuntimePtr, arrayHandle, index);
    }

    protected String arrayGetString(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetString(v8RuntimePtr, arrayHandle, index);
    }

    protected Object arrayGet(long v8RuntimePtr, int expectedType, long arrayHandle, int index) {
        return this._arrayGet(v8RuntimePtr, expectedType, arrayHandle, index);
    }

    protected void addArrayIntItem(long v8RuntimePtr, long arrayHandle, int value) {
        this._addArrayIntItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayBooleanItem(long v8RuntimePtr, long arrayHandle, boolean value) {
        this._addArrayBooleanItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayDoubleItem(long v8RuntimePtr, long arrayHandle, double value) {
        this._addArrayDoubleItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayStringItem(long v8RuntimePtr, long arrayHandle, String value) {
        this._addArrayStringItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayObjectItem(long v8RuntimePtr, long arrayHandle, long value) {
        this._addArrayObjectItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayUndefinedItem(long v8RuntimePtr, long arrayHandle) {
        this._addArrayUndefinedItem(v8RuntimePtr, arrayHandle);
    }

    protected void addArrayNullItem(long v8RuntimePtr, long arrayHandle) {
        this._addArrayNullItem(v8RuntimePtr, arrayHandle);
    }

    protected int getType(long v8RuntimePtr, long objectHandle, String key) {
        return this._getType(v8RuntimePtr, objectHandle, key);
    }

    protected int getType(long v8RuntimePtr, long objectHandle, int index) {
        return this._getType(v8RuntimePtr, objectHandle, index);
    }

    protected int getArrayType(long v8RuntimePtr, long objectHandle) {
        return this._getArrayType(v8RuntimePtr, objectHandle);
    }

    protected int getType(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._getType(v8RuntimePtr, objectHandle, index, length);
    }

    protected void setPrototype(long v8RuntimePtr, long objectHandle, long prototypeHandle) {
        this._setPrototype(v8RuntimePtr, objectHandle, prototypeHandle);
    }

    protected boolean enableDebugSupport(long v8RuntimePtr, int port, boolean waitForConnection) {
        return this._enableDebugSupport(v8RuntimePtr, port, waitForConnection);
    }

    protected void disableDebugSupport(long v8RuntimePtr) {
        this._disableDebugSupport(v8RuntimePtr);
    }

    protected void processDebugMessages(long v8RuntimePtr) {
        this._processDebugMessages(v8RuntimePtr);
    }

    protected int[] arrayGetIntegers(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetIntegers(v8RuntimePtr, objectHandle, index, length);
    }

    protected double[] arrayGetDoubles(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetDoubles(v8RuntimePtr, objectHandle, index, length);
    }

    protected boolean[] arrayGetBooleans(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetBooleans(v8RuntimePtr, objectHandle, index, length);
    }

    protected String[] arrayGetStrings(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetStrings(v8RuntimePtr, objectHandle, index, length);
    }

    protected int arrayGetIntegers(long v8RuntimePtr, long objectHandle, int index, int length, int[] resultArray) {
        return this._arrayGetIntegers(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetDoubles(long v8RuntimePtr, long objectHandle, int index, int length, double[] resultArray) {
        return this._arrayGetDoubles(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetBooleans(long v8RuntimePtr, long objectHandle, int index, int length, boolean[] resultArray) {
        return this._arrayGetBooleans(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetStrings(long v8RuntimePtr, long objectHandle, int index, int length, String[] resultArray) {
        return this._arrayGetStrings(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected void terminateExecution(long v8RuntimePtr) {
        this._terminateExecution(v8RuntimePtr);
    }

    private native long _initNewV8Object(long var1);

    private native void _createTwin(long var1, long var3, long var5);

    private native void _releaseRuntime(long var1);

    private native long _createIsolate(String var1);

    private native int _executeIntegerScript(long var1, String var3, String var4, int var5);

    private native double _executeDoubleScript(long var1, String var3, String var4, int var5);

    private native String _executeStringScript(long var1, String var3, String var4, int var5);

    private native boolean _executeBooleanScript(long var1, String var3, String var4, int var5);

    private native Object _executeScript(long var1, int var3, String var4, String var5, int var6);

    private native void _executeVoidScript(long var1, String var3, String var4, int var5);

    private native void _release(long var1, long var3);

    private native boolean _contains(long var1, long var3, String var5);

    private native String[] _getKeys(long var1, long var3);

    private native int _getInteger(long var1, long var3, String var5);

    private native boolean _getBoolean(long var1, long var3, String var5);

    private native double _getDouble(long var1, long var3, String var5);

    private native String _getString(long var1, long var3, String var5);

    private native Object _get(long var1, int var3, long var4, String var6);

    private native int _executeIntegerFunction(long var1, long var3, String var5, long var6);

    private native double _executeDoubleFunction(long var1, long var3, String var5, long var6);

    private native String _executeStringFunction(long var1, long var3, String var5, long var6);

    private native boolean _executeBooleanFunction(long var1, long var3, String var5, long var6);

    private native Object _executeFunction(long var1, int var3, long var4, String var6, long var7);

    private native Object _executeFunction(long var1, long var3, long var5, long var7);

    private native void _executeVoidFunction(long var1, long var3, String var5, long var6);

    private native boolean _equals(long var1, long var3, long var5);

    private native boolean _strictEquals(long var1, long var3, long var5);

    private native boolean _sameValue(long var1, long var3, long var5);

    private native int _identityHash(long var1, long var3);

    private native void _add(long var1, long var3, String var5, int var6);

    private native void _addObject(long var1, long var3, String var5, long var6);

    private native void _add(long var1, long var3, String var5, boolean var6);

    private native void _add(long var1, long var3, String var5, double var6);

    private native void _add(long var1, long var3, String var5, String var6);

    private native void _addUndefined(long var1, long var3, String var5);

    private native void _addNull(long var1, long var3, String var5);

    private native void _registerJavaMethod(long var1, long var3, String var5, int var6, boolean var7);

    private native long _initNewV8Array(long var1);

    private native int _arrayGetSize(long var1, long var3);

    private native int _arrayGetInteger(long var1, long var3, int var5);

    private native boolean _arrayGetBoolean(long var1, long var3, int var5);

    private native double _arrayGetDouble(long var1, long var3, int var5);

    private native String _arrayGetString(long var1, long var3, int var5);

    private native Object _arrayGet(long var1, int var3, long var4, int var6);

    private native void _addArrayIntItem(long var1, long var3, int var5);

    private native void _addArrayBooleanItem(long var1, long var3, boolean var5);

    private native void _addArrayDoubleItem(long var1, long var3, double var5);

    private native void _addArrayStringItem(long var1, long var3, String var5);

    private native void _addArrayObjectItem(long var1, long var3, long var5);

    private native void _addArrayUndefinedItem(long var1, long var3);

    private native void _addArrayNullItem(long var1, long var3);

    private native int _getType(long var1, long var3, String var5);

    private native int _getType(long var1, long var3, int var5);

    private native int _getArrayType(long var1, long var3);

    private native void _setPrototype(long var1, long var3, long var5);

    private native int _getType(long var1, long var3, int var5, int var6);

    private native boolean _enableDebugSupport(long var1, int var3, boolean var4);

    private native void _disableDebugSupport(long var1);

    private native void _processDebugMessages(long var1);

    private native double[] _arrayGetDoubles(long var1, long var3, int var5, int var6);

    private native int[] _arrayGetIntegers(long var1, long var3, int var5, int var6);

    private native boolean[] _arrayGetBooleans(long var1, long var3, int var5, int var6);

    private native String[] _arrayGetStrings(long var1, long var3, int var5, int var6);

    private native int _arrayGetIntegers(long var1, long var3, int var5, int var6, int[] var7);

    private native int _arrayGetDoubles(long var1, long var3, int var5, int var6, double[] var7);

    private native int _arrayGetBooleans(long var1, long var3, int var5, int var6, boolean[] var7);

    private native int _arrayGetStrings(long var1, long var3, int var5, int var6, String[] var7);

    private native void _terminateExecution(long var1);

    private native long _getGlobalObject(long var1);

    private native long _getBuildID();

    void addObjRef() {
        ++this.objectReferences;
    }

    void releaseObjRef() {
        --this.objectReferences;
    }

    private class MethodDescriptor {
        Object object;
        Method method;
        JavaCallback callback;
        JavaVoidCallback voidCallback;
        boolean includeReceiver;

        private MethodDescriptor() {
        }
    }
}

