/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8;

public abstract class V8Value
implements Releasable {
    public static final int NULL = 0;
    public static final int UNKNOWN = 0;
    public static final int INTEGER = 1;
    public static final int DOUBLE = 2;
    public static final int BOOLEAN = 3;
    public static final int STRING = 4;
    public static final int V8_ARRAY = 5;
    public static final int V8_OBJECT = 6;
    public static final int V8_FUNCTION = 7;
    public static final int UNDEFINED = 99;
    protected V8 v8;
    protected long objectHandle;
    protected boolean released = true;

    protected V8Value() {
    }

    protected V8Value(V8 v8) {
        this.v8 = v8 == null ? (V8)this : v8;
    }

    protected long initialize(long runtimePtr) {
        long objectHandle = this.v8.initNewV8Object(runtimePtr);
        this.v8.addObjRef();
        this.released = false;
        return objectHandle;
    }

    public boolean isUndefined() {
        return false;
    }

    @Deprecated
    public V8 getRutime() {
        return this.getRuntime();
    }

    public V8 getRuntime() {
        return this.v8;
    }

    public V8Value twin() {
        if (this.isUndefined()) {
            return this;
        }
        this.v8.checkThread();
        this.v8.checkReleaesd();
        V8Value twin = this.createTwin();
        this.v8.createTwin(this, twin);
        return twin;
    }

    @Override
    public void release() {
        this.v8.checkThread();
        if (!this.released) {
            this.released = true;
            this.v8.release(this.v8.getV8RuntimePtr(), this.objectHandle);
            this.v8.releaseObjRef();
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean strictEquals(Object that) {
        this.v8.checkThread();
        this.checkReleaesd();
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof V8Value)) {
            return false;
        }
        if (this.isUndefined() && ((V8Value)that).isUndefined()) {
            return true;
        }
        if (((V8Value)that).isUndefined()) {
            return false;
        }
        return this.v8.strictEquals(this.v8.getV8RuntimePtr(), this.getHandle(), ((V8Value)that).getHandle());
    }

    protected long getHandle() {
        this.checkReleaesd();
        return this.objectHandle;
    }

    protected abstract V8Value createTwin();

    public boolean equals(Object that) {
        return this.strictEquals(that);
    }

    public boolean jsEquals(Object that) {
        this.v8.checkThread();
        this.checkReleaesd();
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof V8Value)) {
            return false;
        }
        if (this.isUndefined() && ((V8Value)that).isUndefined()) {
            return true;
        }
        if (((V8Value)that).isUndefined()) {
            return false;
        }
        return this.v8.equals(this.v8.getV8RuntimePtr(), this.getHandle(), ((V8Value)that).getHandle());
    }

    public int hashCode() {
        this.v8.checkThread();
        this.checkReleaesd();
        return this.v8.identityHash(this.v8.getV8RuntimePtr(), this.getHandle());
    }

    protected void checkReleaesd() {
        if (this.released) {
            throw new IllegalStateException("Object released");
        }
    }
}

