/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.utils.V8Map;
import com.eclipsesource.v8.utils.V8PropertyMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class V8ObjectUtils {
    private static final Object IGNORE = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ? super Object> toMap(V8Object object) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Map<String, ? super Object> map = V8ObjectUtils.toMap(object, cache);
            return map;
        }
        finally {
            cache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<? super Object> toList(V8Array array) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            List<? super Object> list = V8ObjectUtils.toList(array, cache);
            return list;
        }
        finally {
            cache.release();
        }
    }

    public static Object getTypedArray(V8Array array, int arrayType, Object result) {
        int length = array.length();
        if (arrayType == 1) {
            int[] intArray = (int[])result;
            if (intArray == null || intArray.length < length) {
                intArray = new int[length];
            }
            array.getIntegers(0, length, intArray);
            return intArray;
        }
        if (arrayType == 2) {
            double[] doubleArray = (double[])result;
            if (doubleArray == null || doubleArray.length < length) {
                doubleArray = new double[length];
            }
            array.getDoubles(0, length, doubleArray);
            return doubleArray;
        }
        if (arrayType == 3) {
            boolean[] booleanArray = (boolean[])result;
            if (booleanArray == null || booleanArray.length < length) {
                booleanArray = new boolean[length];
            }
            array.getBooleans(0, length, booleanArray);
            return booleanArray;
        }
        if (arrayType == 4) {
            String[] stringArray = (String[])result;
            if (stringArray == null || stringArray.length < length) {
                stringArray = new String[length];
            }
            array.getStrings(0, length, stringArray);
            return stringArray;
        }
        throw new RuntimeException("Unsupported bulk load type: " + arrayType);
    }

    public static Object getTypedArray(V8Array array, int arrayType) {
        int length = array.length();
        if (arrayType == 1) {
            return array.getIntegers(0, length);
        }
        if (arrayType == 2) {
            return array.getDoubles(0, length);
        }
        if (arrayType == 3) {
            return array.getBooleans(0, length);
        }
        if (arrayType == 4) {
            return array.getStrings(0, length);
        }
        throw new RuntimeException("Unsupported bulk load type: " + arrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Object toV8Object(V8 v8, Map<String, ? extends Object> map) {
        Hashtable<Object, V8Object> cache = new Hashtable<Object, V8Object>();
        try {
            V8Object v8Object = V8ObjectUtils.toV8Object(v8, map, cache).twin();
            return v8Object;
        }
        finally {
            for (V8Object v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Array toV8Array(V8 v8, List<? extends Object> list) {
        Hashtable<Object, V8Object> cache = new Hashtable<Object, V8Object>();
        try {
            V8Array v8Array = V8ObjectUtils.toV8Array(v8, list, cache).twin();
            return v8Array;
        }
        finally {
            for (V8Object v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getV8Result(V8 v8, Object value) {
        if (value == null) {
            return null;
        }
        Hashtable<Object, V8Object> cache = new Hashtable<Object, V8Object>();
        try {
            Object result = V8ObjectUtils.getV8Result(v8, value, cache);
            if (result instanceof V8Object) {
                V8Object v8Object = ((V8Object)result).twin();
                return v8Object;
            }
            Object object = result;
            return object;
        }
        finally {
            for (V8Object v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushValue(V8 v8, V8Array array, Object value) {
        Hashtable<Object, V8Object> cache = new Hashtable<Object, V8Object>();
        try {
            V8ObjectUtils.pushValue(v8, array, value, cache);
        }
        finally {
            for (V8Object v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Array array, int index) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Object object = V8ObjectUtils.getValue(array, index, cache);
            return object;
        }
        finally {
            cache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Object object, String key) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Object object2 = V8ObjectUtils.getValue(object, key, cache);
            return object2;
        }
        finally {
            cache.release();
        }
    }

    private static Map<String, ? super Object> toMap(V8Object object, V8Map<Object> cache) {
        String[] keys;
        if (object == null) {
            return Collections.emptyMap();
        }
        if (cache.containsKey(object)) {
            return (Map)cache.get(object);
        }
        V8PropertyMap<Object> result = new V8PropertyMap<Object>();
        cache.put(object, (Object)result);
        for (String key : keys = object.getKeys()) {
            Object value = V8ObjectUtils.getValue(object, key, cache);
            if (value == IGNORE) continue;
            result.put(key, value);
        }
        return result;
    }

    private static List<? super Object> toList(V8Array array, V8Map<Object> cache) {
        if (array == null) {
            return Collections.emptyList();
        }
        if (cache.containsKey(array)) {
            return (List)cache.get(array);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        cache.put(array, (Object)result);
        for (int i = 0; i < array.length(); ++i) {
            Object value = V8ObjectUtils.getValue(array, i, cache);
            if (value == IGNORE) continue;
            result.add(V8ObjectUtils.getValue(array, i, cache));
        }
        return result;
    }

    private static V8Object toV8Object(V8 v8, Map<String, ? extends Object> map, Map<Object, V8Object> cache) {
        if (cache.containsKey(map)) {
            return cache.get(map);
        }
        V8Object result = new V8Object(v8);
        cache.put(map, result);
        try {
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                V8ObjectUtils.setValue(v8, result, entry.getKey(), entry.getValue(), cache);
            }
        }
        catch (IllegalStateException e) {
            result.release();
            throw e;
        }
        return result;
    }

    private static V8Array toV8Array(V8 v8, List<? extends Object> list, Map<Object, V8Object> cache) {
        if (cache.containsKey(new ListWrapper(list))) {
            return (V8Array)cache.get(new ListWrapper(list));
        }
        V8Array result = new V8Array(v8);
        cache.put(new ListWrapper(list), result);
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object value = list.get(i);
                V8ObjectUtils.pushValue(v8, result, value, cache);
            }
        }
        catch (IllegalStateException e) {
            result.release();
            throw e;
        }
        return result;
    }

    private static Object getV8Result(V8 v8, Object value, Map<Object, V8Object> cache) {
        if (cache.containsKey(value)) {
            return cache.get(value);
        }
        if (value instanceof Map) {
            return V8ObjectUtils.toV8Object(v8, (Map)value, cache);
        }
        if (value instanceof List) {
            return V8ObjectUtils.toV8Array(v8, (List)value, cache);
        }
        return value;
    }

    private static void pushValue(V8 v8, V8Array result, Object value, Map<Object, V8Object> cache) {
        if (value == null) {
            result.pushUndefined();
        } else if (value instanceof Integer) {
            result.push((Integer)value);
        } else if (value instanceof Long) {
            result.push(new Double(((Long)value).longValue()));
        } else if (value instanceof Double) {
            result.push((Double)value);
        } else if (value instanceof Float) {
            result.push(((Float)value).floatValue());
        } else if (value instanceof String) {
            result.push((String)value);
        } else if (value instanceof Boolean) {
            result.push((Boolean)value);
        } else if (value instanceof Map) {
            V8Object object = V8ObjectUtils.toV8Object(v8, (Map)value, cache);
            result.push(object);
        } else if (value instanceof List) {
            V8Array array = V8ObjectUtils.toV8Array(v8, (List)value, cache);
            result.push(array);
        } else {
            throw new IllegalStateException("Unsupported Object of type: " + value.getClass());
        }
    }

    private static void setValue(V8 v8, V8Object result, String key, Object value, Map<Object, V8Object> cache) {
        if (value == null) {
            result.addUndefined(key);
        } else if (value instanceof Integer) {
            result.add(key, (Integer)value);
        } else if (value instanceof Long) {
            result.add(key, (int)((Long)value).longValue());
        } else if (value instanceof Double) {
            result.add(key, (Double)value);
        } else if (value instanceof Float) {
            result.add(key, ((Float)value).floatValue());
        } else if (value instanceof String) {
            result.add(key, (String)value);
        } else if (value instanceof Boolean) {
            result.add(key, (Boolean)value);
        } else if (value instanceof Map) {
            V8Object object = V8ObjectUtils.toV8Object(v8, (Map)value, cache);
            result.add(key, object);
        } else if (value instanceof List) {
            V8Array array = V8ObjectUtils.toV8Array(v8, (List)value, cache);
            result.add(key, array);
        } else {
            throw new IllegalStateException("Unsupported Object of type: " + value.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getValue(V8Array array, int index, V8Map<Object> cache) {
        int valueType = array.getType(index);
        switch (valueType) {
            case 1: {
                return array.getInteger(index);
            }
            case 2: {
                return array.getDouble(index);
            }
            case 3: {
                return array.getBoolean(index);
            }
            case 4: {
                return array.getString(index);
            }
            case 7: {
                return IGNORE;
            }
            case 5: {
                V8Array arrayValue = array.getArray(index);
                try {
                    List<? super Object> list = V8ObjectUtils.toList(arrayValue, cache);
                    return list;
                }
                finally {
                    if (arrayValue instanceof V8Array) {
                        arrayValue.release();
                    }
                }
            }
            case 6: {
                V8Object objectValue = array.getObject(index);
                try {
                    Map<String, ? super Object> map = V8ObjectUtils.toMap(objectValue, cache);
                    return map;
                }
                finally {
                    if (objectValue instanceof V8Object) {
                        objectValue.release();
                    }
                }
            }
            case 0: {
                return null;
            }
            case 99: {
                return V8.getUndefined();
            }
        }
        throw new IllegalStateException("Cannot find type for index: " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getValue(V8Object object, String key, V8Map<Object> cache) {
        int valueType = object.getType(key);
        switch (valueType) {
            case 1: {
                return object.getInteger(key);
            }
            case 2: {
                return object.getDouble(key);
            }
            case 3: {
                return object.getBoolean(key);
            }
            case 4: {
                return object.getString(key);
            }
            case 7: {
                return IGNORE;
            }
            case 5: {
                V8Array array = object.getArray(key);
                try {
                    List<? super Object> list = V8ObjectUtils.toList(array, cache);
                    return list;
                }
                finally {
                    if (array instanceof V8Array) {
                        array.release();
                    }
                }
            }
            case 6: {
                V8Object child = object.getObject(key);
                try {
                    Map<String, ? super Object> map = V8ObjectUtils.toMap(child, cache);
                    return map;
                }
                finally {
                    if (child instanceof V8Object) {
                        child.release();
                    }
                }
            }
            case 0: {
                return null;
            }
            case 99: {
                return V8.getUndefined();
            }
        }
        throw new IllegalStateException("Cannot find type for key: " + key);
    }

    private V8ObjectUtils() {
    }

    static class ListWrapper {
        private List<? extends Object> list;

        public ListWrapper(List<? extends Object> list) {
            this.list = list;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListWrapper) {
                return ((ListWrapper)obj).list == this.list;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.list);
        }
    }
}

