/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.httptransport;

import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "", "mimeType", "", "(Ljava/lang/String;)V", "getMimeType", "()Ljava/lang/String;", "asString", "ByteArrayBody", "EmptyBody", "InputStreamBody", "JsonBody", "LocalFileBody", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody$EmptyBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody$JsonBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody$ByteArrayBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody$InputStreamBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody$LocalFileBody;", "api-client"})
public abstract class HttpBody {
    @NotNull
    private final String mimeType;

    @Nullable
    public final String asString() {
        String string;
        HttpBody httpBody = this;
        if (httpBody instanceof EmptyBody) {
            string = null;
        } else if (httpBody instanceof JsonBody) {
            string = ((JsonBody)this).getObj().toString();
        } else if (httpBody instanceof ByteArrayBody) {
            string = "[Binary data: from byte array of size " + ((ByteArrayBody)this).getBytes().length + ']';
        } else if (httpBody instanceof InputStreamBody) {
            string = "[Binary data: from stream]";
        } else if (httpBody instanceof LocalFileBody) {
            string = "[Binary data: from file '" + ((LocalFileBody)this).getFile().getAbsolutePath() + "']";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    private HttpBody(String mimeType) {
        this.mimeType = mimeType;
    }

    public /* synthetic */ HttpBody(String mimeType, DefaultConstructorMarker $constructor_marker) {
        this(mimeType);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/HttpBody$EmptyBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "()V", "api-client"})
    public static final class EmptyBody
    extends HttpBody {
        public static final EmptyBody INSTANCE;

        private EmptyBody() {
            super("", null);
        }

        static {
            EmptyBody emptyBody;
            INSTANCE = emptyBody = new EmptyBody();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/HttpBody$JsonBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "obj", "", "(Ljava/lang/Object;)V", "getObj", "()Ljava/lang/Object;", "api-client"})
    public static final class JsonBody
    extends HttpBody {
        @NotNull
        private final Object obj;

        @NotNull
        public final Object getObj() {
            return this.obj;
        }

        public JsonBody(@NotNull Object obj) {
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
            super("application/json", null);
            this.obj = obj;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/HttpBody$ByteArrayBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "bytes", "", "mimeType", "", "([BLjava/lang/String;)V", "getBytes", "()[B", "api-client"})
    public static final class ByteArrayBody
    extends HttpBody {
        @NotNull
        private final byte[] bytes;

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        public ByteArrayBody(@NotNull byte[] bytes, @NotNull String mimeType) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
            super(mimeType, null);
            this.bytes = bytes;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/HttpBody$InputStreamBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "stream", "Ljava/io/InputStream;", "mimeType", "", "(Ljava/io/InputStream;Ljava/lang/String;)V", "getStream", "()Ljava/io/InputStream;", "api-client"})
    public static final class InputStreamBody
    extends HttpBody {
        @NotNull
        private final InputStream stream;

        @NotNull
        public final InputStream getStream() {
            return this.stream;
        }

        public InputStreamBody(@NotNull InputStream stream, @NotNull String mimeType) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
            super(mimeType, null);
            this.stream = stream;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/HttpBody$LocalFileBody;", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "file", "Ljava/io/File;", "mimeType", "", "(Ljava/io/File;Ljava/lang/String;)V", "getFile", "()Ljava/io/File;", "api-client"})
    public static final class LocalFileBody
    extends HttpBody {
        @NotNull
        private final File file;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public LocalFileBody(@NotNull File file, @NotNull String mimeType) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
            super(mimeType, null);
            this.file = file;
        }
    }
}

