/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.impl;

import com.ecwid.apiclient.v3.config.ApiServerDomain;
import com.ecwid.apiclient.v3.config.ApiStoreCredentials;
import com.ecwid.apiclient.v3.config.LoggingSettings;
import com.ecwid.apiclient.v3.dto.ApiRequest;
import com.ecwid.apiclient.v3.dto.EcwidApiError;
import com.ecwid.apiclient.v3.exception.EcwidApiException;
import com.ecwid.apiclient.v3.exception.JsonDeserializationException;
import com.ecwid.apiclient.v3.httptransport.HttpBody;
import com.ecwid.apiclient.v3.httptransport.HttpRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.httptransport.HttpTransport;
import com.ecwid.apiclient.v3.impl.ApiClientHelper$WhenMappings;
import com.ecwid.apiclient.v3.impl.ApiClientHelperKt;
import com.ecwid.apiclient.v3.impl.RequestInfo;
import com.ecwid.apiclient.v3.jsontransformer.JsonTransformer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002JB\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u0010\b\u0002\u0010\u001b\u001a\n\u0018\u00010\u001cj\u0004\u0018\u0001`\u001dH\u0002J(\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J \u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J.\u0010-\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u00132\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u001e\u0010/\u001a\u0002H0\"\u0006\b\u0000\u00100\u0018\u00012\u0006\u00101\u001a\u000202H\u0086\b\u00a2\u0006\u0002\u00103J/\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u00104\u001a\b\u0012\u0004\u0012\u0002H005\u00a2\u0006\u0002\u00106J9\u00107\u001a\u0002H0\"\u0004\b\u0000\u001002\u0006\u00108\u001a\u0002092\f\u00104\u001a\b\u0012\u0004\u0012\u0002H0052\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/ecwid/apiclient/v3/impl/ApiClientHelper;", "", "apiServerDomain", "Lcom/ecwid/apiclient/v3/config/ApiServerDomain;", "storeCredentials", "Lcom/ecwid/apiclient/v3/config/ApiStoreCredentials;", "loggingSettings", "Lcom/ecwid/apiclient/v3/config/LoggingSettings;", "httpTransport", "Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;", "jsonTransformer", "Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiStoreCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;)V", "getJsonTransformer$api_client", "()Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "createApiEndpointUri", "", "endpoint", "logCannotParseResponseError", "", "requestId", "requestTime", "", "responseBody", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logEntry", "prefix", "logLevel", "Ljava/util/logging/Level;", "sections", "", "logErrorResponseIfNeeded", "httpStatusCode", "", "logRequestIfNeeded", "httpRequest", "Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "httpBody", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "logSuccessfulResponseIfNeeded", "logTransportErrorResponseIfNeeded", "errorMessage", "makeRequest", "V", "request", "Lcom/ecwid/apiclient/v3/dto/ApiRequest;", "(Lcom/ecwid/apiclient/v3/dto/ApiRequest;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;Lcom/ecwid/apiclient/v3/httptransport/HttpBody;Ljava/lang/Class;)Ljava/lang/Object;", "processHttpResponse", "httpResponse", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "(Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;Ljava/lang/Class;Ljava/lang/String;J)Ljava/lang/Object;", "api-client"})
public final class ApiClientHelper {
    private final Logger log;
    private final ApiServerDomain apiServerDomain;
    private final ApiStoreCredentials storeCredentials;
    private final LoggingSettings loggingSettings;
    private final HttpTransport httpTransport;
    @NotNull
    private final JsonTransformer jsonTransformer;

    public final /* synthetic */ <V> V makeRequest(@NotNull ApiRequest request) {
        HttpRequest httpRequest;
        int $i$f$makeRequest = 0;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        RequestInfo requestInfo = request.toRequestInfo();
        switch (ApiClientHelper$WhenMappings.$EnumSwitchMapping$0[requestInfo.getMethod().ordinal()]) {
            case 1: {
                httpRequest = new HttpRequest.HttpGetRequest(this.createApiEndpointUri(requestInfo.getEndpoint()), ApiClientHelperKt.access$withApiTokenParam(requestInfo.getParams(), this.storeCredentials.getApiToken()));
                break;
            }
            case 2: {
                httpRequest = new HttpRequest.HttpPostRequest(this.createApiEndpointUri(requestInfo.getEndpoint()), ApiClientHelperKt.access$withApiTokenParam(requestInfo.getParams(), this.storeCredentials.getApiToken()), ApiClientHelperKt.access$prepare(requestInfo.getHttpBody(), this.getJsonTransformer$api_client()));
                break;
            }
            case 3: {
                httpRequest = new HttpRequest.HttpPutRequest(this.createApiEndpointUri(requestInfo.getEndpoint()), ApiClientHelperKt.access$withApiTokenParam(requestInfo.getParams(), this.storeCredentials.getApiToken()), ApiClientHelperKt.access$prepare(requestInfo.getHttpBody(), this.getJsonTransformer$api_client()));
                break;
            }
            case 4: {
                httpRequest = new HttpRequest.HttpDeleteRequest(this.createApiEndpointUri(requestInfo.getEndpoint()), ApiClientHelperKt.access$withApiTokenParam(requestInfo.getParams(), this.storeCredentials.getApiToken()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest httpRequest2 = httpRequest;
        HttpBody httpBody = requestInfo.getHttpBody();
        Intrinsics.reifiedOperationMarker((int)4, (String)"V");
        return (V)this.makeRequest(httpRequest2, httpBody, Object.class);
    }

    public final <V> V makeRequest(@NotNull HttpRequest httpRequest, @NotNull HttpBody httpBody, @NotNull Class<V> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkParameterIsNotNull((Object)httpBody, (String)"httpBody");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        String requestId = ApiClientHelperKt.access$generateRequestId();
        this.logRequestIfNeeded(requestId, httpRequest, httpBody);
        long startTime = new Date().getTime();
        HttpResponse httpResponse = this.httpTransport.makeHttpRequest(httpRequest);
        return this.processHttpResponse(httpResponse, clazz, requestId, new Date().getTime() - startTime);
    }

    private final <V> V processHttpResponse(HttpResponse httpResponse, Class<V> clazz, String requestId, long requestTime) {
        Object responseBody;
        byte[] responseBytes = httpResponse.getResponseBytes();
        HttpResponse httpResponse2 = httpResponse;
        if (httpResponse2 instanceof HttpResponse.Success) {
            try {
                Object object;
                if (clazz.isAssignableFrom(String.class)) {
                    responseBody = ApiClientHelperKt.access$asString(responseBytes);
                    this.logSuccessfulResponseIfNeeded(requestId, requestTime, (String)responseBody);
                    object = responseBody;
                } else if (clazz.isAssignableFrom(byte[].class)) {
                    this.logSuccessfulResponseIfNeeded(requestId, requestTime, "[Binary data: byte array of size " + responseBytes.length + ']');
                    object = responseBytes;
                } else {
                    responseBody = ApiClientHelperKt.access$asString(responseBytes);
                    this.logSuccessfulResponseIfNeeded(requestId, requestTime, (String)responseBody);
                    object = this.jsonTransformer.deserialize(ApiClientHelperKt.access$asString(responseBytes), clazz);
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                }
                responseBody = object;
            }
            catch (JsonDeserializationException e) {
                this.logCannotParseResponseError(requestId, requestTime, ApiClientHelperKt.access$asString(responseBytes), e);
                throw (Throwable)new EcwidApiException(null, null, null, e.getMessage(), e, 7, null);
            }
        } else {
            if (httpResponse2 instanceof HttpResponse.Error) {
                try {
                    String responseBody2 = ApiClientHelperKt.access$asString(responseBytes);
                    this.logErrorResponseIfNeeded(requestId, requestTime, ((HttpResponse.Error)httpResponse).getStatusCode(), responseBody2);
                    EcwidApiError ecwidError = this.jsonTransformer.deserialize(responseBody2, EcwidApiError.class);
                    EcwidApiError ecwidApiError = ecwidError;
                    EcwidApiError ecwidApiError2 = ecwidError;
                    throw (Throwable)new EcwidApiException(((HttpResponse.Error)httpResponse).getStatusCode(), ((HttpResponse.Error)httpResponse).getReasonPhrase(), ecwidApiError != null ? ecwidApiError.getErrorCode() : null, ecwidApiError2 != null ? ecwidApiError2.getErrorMessage() : null, null, 16, null);
                }
                catch (JsonDeserializationException e) {
                    throw (Throwable)new EcwidApiException(((HttpResponse.Error)httpResponse).getStatusCode(), ((HttpResponse.Error)httpResponse).getReasonPhrase(), null, e.getMessage(), e, 4, null);
                }
            }
            if (httpResponse2 instanceof HttpResponse.TransportError) {
                this.logTransportErrorResponseIfNeeded(requestId, requestTime, ((HttpResponse.TransportError)httpResponse).getException().getMessage(), ((HttpResponse.TransportError)httpResponse).getException());
                throw (Throwable)new EcwidApiException(null, null, null, ((HttpResponse.TransportError)httpResponse).getException().getMessage(), ((HttpResponse.TransportError)httpResponse).getException(), 7, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (V)responseBody;
    }

    private final void logRequestIfNeeded(String requestId, HttpRequest httpRequest, HttpBody httpBody) {
        List list;
        if (!this.loggingSettings.getLogRequest()) {
            return;
        }
        Map params = this.loggingSettings.getMaskRequestApiToken() ? ApiClientHelperKt.access$withMaskedApiTokenParam(httpRequest.getParams()) : httpRequest.getParams();
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Request";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        List list2 = list = (List)new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        $this$apply.add(httpRequest.getMethod() + ' ' + httpRequest.getUri());
        $this$apply.add(ApiClientHelperKt.access$dumpToString(params));
        if (this.loggingSettings.getLogRequestBody()) {
            String string3 = httpBody.asString();
            if (string3 != null) {
                String string4 = string3;
                boolean bl5 = false;
                boolean bl6 = false;
                String it = string4;
                boolean bl7 = false;
                $this$apply.add(it);
            }
        }
        list = list2;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, list, null, 16, null);
    }

    private final String createApiEndpointUri(String endpoint) {
        String string = new URI("https", null, this.apiServerDomain.getHost(), this.apiServerDomain.getSecurePort() == 443 ? -1 : this.apiServerDomain.getSecurePort(), "/api/v3/" + this.storeCredentials.getStoreId() + '/' + endpoint, null, null).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URI(\n\t\t\t\t\"https\",\n\t\t\t\tnu\u2026,\n\t\t\t\tnull\n\t\t).toString()");
        return string;
    }

    private final void logSuccessfulResponseIfNeeded(String requestId, long requestTime, String responseBody) {
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        List list2 = list = (List)new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        $this$apply.add("OK");
        $this$apply.add(requestTime + " ms");
        if (this.loggingSettings.getLogSuccessfulResponseBody()) {
            $this$apply.add(responseBody);
        }
        list = list2;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, list, null, 16, null);
    }

    private final void logErrorResponseIfNeeded(String requestId, long requestTime, int httpStatusCode, String responseBody) {
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        List list2 = list = (List)new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        $this$apply.add("ERR " + httpStatusCode);
        $this$apply.add(requestTime + " ms");
        if (this.loggingSettings.getLogFailedResponseBody()) {
            $this$apply.add(responseBody);
        }
        list = list2;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, list, null, 16, null);
    }

    private final void logTransportErrorResponseIfNeeded(String requestId, long requestTime, String errorMessage, Exception exception) {
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        String string = requestId;
        Level level = Level.WARNING;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        List list2 = list = (List)new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        $this$apply.add("ERR");
        $this$apply.add(requestTime + " ms");
        if (errorMessage != null) {
            $this$apply.add(errorMessage);
        }
        list = list2;
        apiClientHelper.logEntry(string2, level, string, list, exception);
    }

    private final void logCannotParseResponseError(String requestId, long requestTime, String responseBody, Exception exception) {
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        String string = requestId;
        Level level = Level.WARNING;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        List list2 = list = (List)new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        $this$apply.add("ERR");
        $this$apply.add(requestTime + " ms");
        if (this.loggingSettings.getLogFailedResponseBody()) {
            $this$apply.add(responseBody);
        }
        list = list2;
        apiClientHelper.logEntry(string2, level, string, list, exception);
    }

    private final void logEntry(String prefix, Level logLevel, String requestId, List<String> sections, Exception exception) {
        String logMessage = prefix + " [" + requestId + "]: " + CollectionsKt.joinToString$default((Iterable)sections, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        if (exception != null) {
            this.log.log(logLevel, logMessage, exception);
        } else {
            this.log.log(logLevel, logMessage);
        }
    }

    static /* synthetic */ void logEntry$default(ApiClientHelper apiClientHelper, String string, Level level, String string2, List list, Exception exception, int n, Object object) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        apiClientHelper.logEntry(string, level, string2, list, exception);
    }

    @NotNull
    public final JsonTransformer getJsonTransformer$api_client() {
        return this.jsonTransformer;
    }

    public ApiClientHelper(@NotNull ApiServerDomain apiServerDomain, @NotNull ApiStoreCredentials storeCredentials, @NotNull LoggingSettings loggingSettings, @NotNull HttpTransport httpTransport, @NotNull JsonTransformer jsonTransformer) {
        Intrinsics.checkParameterIsNotNull((Object)apiServerDomain, (String)"apiServerDomain");
        Intrinsics.checkParameterIsNotNull((Object)storeCredentials, (String)"storeCredentials");
        Intrinsics.checkParameterIsNotNull((Object)loggingSettings, (String)"loggingSettings");
        Intrinsics.checkParameterIsNotNull((Object)httpTransport, (String)"httpTransport");
        Intrinsics.checkParameterIsNotNull((Object)jsonTransformer, (String)"jsonTransformer");
        this.apiServerDomain = apiServerDomain;
        this.storeCredentials = storeCredentials;
        this.loggingSettings = loggingSettings;
        this.httpTransport = httpTransport;
        this.jsonTransformer = jsonTransformer;
        this.log = Logger.getLogger(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName());
    }
}

